/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.ui.internal.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.IXMLSearchEngine;
import org.eclipse.wst.xml.search.core.XMLSearchEngine2;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.AbstractXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.AllFilesXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.requestor.IXMLSearchRequestor;
import org.eclipse.wst.xml.search.core.queryspecifications.visitor.IXMLSearchDOMDocumentVisitor;
import org.eclipse.wst.xml.search.core.queryspecifications.visitor.XPathNodeSetSearchVisitor;
import org.eclipse.wst.xml.search.core.util.StringUtils;
import org.eclipse.wst.xml.search.core.xpath.IXPathProcessorType;
import org.eclipse.wst.xml.search.core.xpath.NamespaceInfos;
import org.eclipse.wst.xml.search.core.xpath.XPathManager;
import org.eclipse.wst.xml.search.core.xpath.XPathProcessorManager;
import org.eclipse.wst.xml.search.ui.internal.Messages;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchQuery;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchUIPlugin;
import org.eclipse.wst.xml.search.ui.internal.util.FileTypeEditor;
import org.eclipse.wst.xml.search.ui.internal.util.SWTUtil;
import org.eclipse.wst.xml.search.ui.util.DOMUtils;
import org.eclipse.wst.xml.search.ui.util.SearchUtil;
import org.w3c.dom.Node;

public class XMLSearchPage
extends DialogPage
implements ISearchPage {
    private static final String DEFAULT_XML_EXT = "*.xml";
    private static final int HISTORY_SIZE = 12;
    private ISearchPageContainer container;
    private boolean fFirstTime = true;
    private Combo xpathCombo;
    private CLabel fStatusLabel;
    private Combo fExtensions;
    private ComboViewer xpathProcessorViewer;
    private FileTypeEditor fFileTypeEditor;
    private NamespaceInfos namespaceInfos = null;
    private static final String PAGE_NAME = "XMLSearchPage";
    private static final String STORE_HISTORY = "HISTORY";
    private static final String STORE_HISTORY_SIZE = "HISTORY_SIZE";
    private List<SearchPatternData> fPreviousSearchPatterns = new ArrayList<SearchPatternData>(20);

    public boolean performAction() {
        try {
            NewSearchUI.runQueryInBackground((ISearchQuery)this.newQuery());
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.XMLSearchPage_replace_searchproblems_title, (String)Messages.XMLSearchPage_replace_searchproblems_message, (IStatus)e.getStatus());
            return false;
        }
        return true;
    }

    private ISearchQuery newQuery() throws CoreException {
        SearchPatternData data = this.getPatternData();
        String xpath = data.xpath;
        IXMLSearchDOMDocumentVisitor visitor = XPathNodeSetSearchVisitor.INSTANCE;
        ArrayList<String> extensions = new ArrayList<String>();
        boolean acceptAllFiles = this.getExtensions(extensions);
        Object requestor = null;
        requestor = acceptAllFiles ? AllFilesXMLSearchRequestor.INSTANCE : new AbstractXMLSearchRequestor(){

            protected boolean accept(IFile file, IResource rootResource) {
                boolean accept = false;
                for (String extension : extensions) {
                    accept = extension.equals(file.getFileExtension());
                    if (!accept) continue;
                    return true;
                }
                return false;
            }
        };
        return new XMLSearchQuery((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IXMLSearchRequestor)requestor, visitor, xpath, this.getXPathProcessorId(), null, null, (IXMLSearchEngine)new XMLSearchEngine2(), null);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        this.addXPathControls(result);
        this.addXPathProcessorControls(result);
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        this.addFileNameControls(result);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)result, "org.eclipse.wst.xml.search.ui.xml_search_page_context");
    }

    public void setVisible(boolean visible) {
        if (visible && this.xpathCombo != null) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                this.xpathCombo.setItems(this.getPreviousSearchPatterns());
                this.xpathProcessorViewer.setInput((Object)XPathProcessorManager.getDefault().getProcessors());
                this.fExtensions.setItems(this.getPreviousExtensions());
                if (!this.initializeXPathControl()) {
                    this.xpathCombo.select(0);
                    this.fExtensions.setText(DEFAULT_XML_EXT);
                    this.handleWidgetSelected();
                }
            }
            this.xpathCombo.setFocus();
            if (this.xpathProcessorViewer.getSelection().isEmpty()) {
                this.selectXPathProcessor("org.eclipse.wst.xml.search.core.xpath.DefaultXPathProcessor");
            }
        }
        this.updateOKStatus();
        super.setVisible(visible);
    }

    private void addXPathControls(Composite group) {
        Label label = new Label(group, 16384);
        label.setText(Messages.SearchPage_xpath_text);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.xpathCombo = new Combo(group, 2052);
        this.xpathCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLSearchPage.this.handleWidgetSelected();
                XMLSearchPage.this.updateOKStatus();
            }
        });
        this.xpathCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLSearchPage.this.updateOKStatus();
            }
        });
        this.xpathCombo.setFont(group.getFont());
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.xpathCombo.setLayoutData((Object)data);
        this.fStatusLabel = new CLabel(group, 16384);
        this.fStatusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.fStatusLabel.setFont(group.getFont());
        this.fStatusLabel.setAlignment(16384);
        this.fStatusLabel.setText(Messages.SearchPage_xpath_hint);
    }

    private void addXPathProcessorControls(Composite group) {
        Label label = new Label(group, 16384);
        label.setText(Messages.SearchPage_XPathProcessor_text);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.xpathProcessorViewer = new ComboViewer(group, 2060);
        this.xpathProcessorViewer.setLabelProvider((IBaseLabelProvider)new XPathProcessorLabelProvider());
        this.xpathProcessorViewer.setContentProvider((IContentProvider)new XPathProcessorContentProvider());
        this.xpathProcessorViewer.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLSearchPage.this.updateOKStatus();
            }
        });
        this.xpathProcessorViewer.getCombo().setFont(group.getFont());
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.xpathProcessorViewer.getCombo().setLayoutData((Object)data);
    }

    private String getExtensionFromEditor() {
        IEditorInput elem;
        IEditorPart ep = this.getEditorPart();
        if (ep != null && (elem = ep.getEditorInput()) instanceof IFileEditorInput) {
            String extension = ((IFileEditorInput)elem).getFile().getFileExtension();
            if (extension == null) {
                return ((IFileEditorInput)elem).getFile().getName();
            }
            return "*." + extension;
        }
        return null;
    }

    private IEditorPart getEditorPart() {
        return XMLSearchUIPlugin.getActivePage().getActiveEditor();
    }

    private void addFileNameControls(Composite group) {
        Label label = new Label(group, 16384);
        label.setText(Messages.SearchPage_fileNamePatterns_text);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        label.setFont(group.getFont());
        this.fExtensions = new Combo(group, 2052);
        this.fExtensions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLSearchPage.this.updateOKStatus();
            }
        });
        GridData data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(50);
        this.fExtensions.setLayoutData((Object)data);
        this.fExtensions.setFont(group.getFont());
        Button button = new Button(group, 8);
        button.setText(Messages.SearchPage_browse);
        GridData gridData = new GridData(1, 0x1000000, false, false, 1, 1);
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData);
        button.setFont(group.getFont());
        this.fFileTypeEditor = new FileTypeEditor(this.fExtensions, button);
    }

    protected void handleWidgetSelected() {
        int selectionIndex = this.xpathCombo.getSelectionIndex();
        if (selectionIndex < 0 || selectionIndex >= this.fPreviousSearchPatterns.size()) {
            return;
        }
        SearchPatternData patternData = this.fPreviousSearchPatterns.get(selectionIndex);
        if (!this.xpathCombo.getText().equals(patternData.xpath)) {
            return;
        }
        this.xpathCombo.setText(patternData.xpath);
        this.fFileTypeEditor.setFileTypes(patternData.fileNamePatterns);
        this.selectXPathProcessor(patternData.xpathProcessorId);
        if (patternData.workingSets != null) {
            this.getContainer().setSelectedWorkingSets(patternData.workingSets);
        } else {
            this.getContainer().setSelectedScope(patternData.scope);
        }
    }

    private void selectXPathProcessor(String xpathProcessorId) {
        IXPathProcessorType provider = XPathProcessorManager.getDefault().getProcessor(xpathProcessorId);
        if (provider == null) {
            provider = XPathProcessorManager.getDefault().getProcessor("org.eclipse.wst.xml.search.core.xpath.DefaultXPathProcessor");
        }
        if (provider != null) {
            this.xpathProcessorViewer.setSelection((ISelection)new StructuredSelection((Object)provider));
        }
    }

    protected void updateOKStatus() {
        boolean valid = this.validateXPath();
        if (valid) {
            valid = this.validateXPathProcessor();
        }
        this.getContainer().setPerformActionEnabled(valid);
    }

    private boolean validateXPathProcessor() {
        if (this.xpathProcessorViewer.getSelection().isEmpty()) {
            this.statusMessage(true, Messages.SearchPage_xpathProcessor_errorRequired);
            return false;
        }
        return true;
    }

    private boolean validateXPath() {
        String xpath = this.xpathCombo.getText();
        if (xpath == null || xpath.length() < 1) {
            this.statusMessage(true, Messages.SearchPage_xpath_errorRequired);
            return false;
        }
        IStatus status = XPathManager.getManager().validateXPath(this.getXPathProcessorId(), xpath);
        if (!status.isOK() && status.getException() != null) {
            String error = this.getErrorMessage(status.getException());
            this.statusMessage(true, error != null ? error : "");
            return false;
        }
        this.statusMessage(false, Messages.SearchPage_xpath_hint);
        return true;
    }

    private String getErrorMessage(Throwable e) {
        if (e == null) {
            return null;
        }
        String locMessage = e.getLocalizedMessage();
        if (locMessage == null || locMessage.length() < 1) {
            locMessage = e.getMessage();
        }
        if (locMessage == null || locMessage.length() < 1) {
            return this.getErrorMessage(e.getCause());
        }
        int i = 0;
        while (i < locMessage.length() && "\n\r".indexOf(locMessage.charAt(i)) == -1) {
            ++i;
        }
        return locMessage.substring(0, i);
    }

    public void setContainer(ISearchPageContainer container) {
        this.container = container;
    }

    private ISearchPageContainer getContainer() {
        return this.container;
    }

    private boolean getExtensions(Collection<String> extensions) {
        String fileType = null;
        String[] fileTypes = this.fFileTypeEditor.getFileTypes();
        int i = 0;
        while (i < fileTypes.length) {
            fileType = fileTypes[i];
            if (fileType.equals("*") || fileType.equals("*.*")) {
                return true;
            }
            if (fileType.startsWith("*.")) {
                extensions.add(fileType.substring(2, fileType.length()));
            } else {
                extensions.add(fileType);
            }
            ++i;
        }
        return false;
    }

    private boolean initializeXPathControl() {
        ITextSelection textSelection;
        String text;
        ISelection selection = this.getSelection();
        if (selection instanceof ITextSelection && !selection.isEmpty() && (text = (textSelection = (ITextSelection)selection).getText()) != null && !text.isEmpty()) {
            IDOMNode selectedNode;
            ITextEditor textEditor = SearchUtil.getTextEditor(this.getEditorPart());
            if (textEditor != null && (selectedNode = DOMUtils.getSelectedNode(textEditor)) != null) {
                this.namespaceInfos = XPathManager.getManager().getNamespaceInfo((Node)selectedNode);
                String xpath = XPathManager.getManager().computeBasicXPath((Node)selectedNode, this.namespaceInfos);
                if (xpath != null) {
                    this.xpathCombo.setText(xpath);
                }
            }
            if (this.getPreviousExtensions().length > 0) {
                this.fExtensions.setText(this.getPreviousExtensions()[0]);
            } else {
                String extension = this.getExtensionFromEditor();
                if (extension != null) {
                    this.fExtensions.setText(extension);
                } else {
                    this.fExtensions.setText(DEFAULT_XML_EXT);
                }
            }
            return true;
        }
        return false;
    }

    private ISelection getSelection() {
        return this.container.getSelection();
    }

    private SearchPatternData getPatternData() {
        SearchPatternData match = this.findInPrevious(this.xpathCombo.getText());
        if (match != null) {
            this.fPreviousSearchPatterns.remove(match);
        }
        match = new SearchPatternData(this.getXPath(), this.getXPathProcessorId(), this.fFileTypeEditor.getFileTypes(), this.getContainer().getSelectedScope(), this.getContainer().getSelectedWorkingSets());
        this.fPreviousSearchPatterns.add(0, match);
        return match;
    }

    private String getXPath() {
        return this.xpathCombo.getText();
    }

    private String getXPathProcessorId() {
        ISelection selection = this.xpathProcessorViewer.getSelection();
        if (selection.isEmpty()) {
            return "org.eclipse.wst.xml.search.core.xpath.DefaultXPathProcessor";
        }
        return ((IXPathProcessorType)((IStructuredSelection)selection).getFirstElement()).getId();
    }

    private SearchPatternData findInPrevious(String pattern) {
        for (SearchPatternData element : this.fPreviousSearchPatterns) {
            if (!pattern.equals(element.xpath)) continue;
            return element;
        }
        return null;
    }

    private String[] getPreviousExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(this.fPreviousSearchPatterns.size());
        int size = this.fPreviousSearchPatterns.size();
        int i = 0;
        while (i < size) {
            SearchPatternData data = this.fPreviousSearchPatterns.get(i);
            String text = FileTypeEditor.typesToString(data.fileNamePatterns);
            if (!extensions.contains(text)) {
                extensions.add(text);
            }
            ++i;
        }
        return extensions.toArray(new String[extensions.size()]);
    }

    private String[] getPreviousSearchPatterns() {
        int size = this.fPreviousSearchPatterns.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = this.fPreviousSearchPatterns.get((int)i).xpath;
            ++i;
        }
        return patterns;
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    private IDialogSettings getDialogSettings() {
        return XMLSearchUIPlugin.getDefault().getDialogSettingsSection(PAGE_NAME);
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int historySize = s.getInt(STORE_HISTORY_SIZE);
            int i = 0;
            while (i < historySize) {
                SearchPatternData data;
                IDialogSettings histSettings = s.getSection(STORE_HISTORY + i);
                if (histSettings != null && (data = SearchPatternData.create(histSettings)) != null) {
                    this.fPreviousSearchPatterns.add(data);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        int historySize = Math.min(this.fPreviousSearchPatterns.size(), 12);
        s.put(STORE_HISTORY_SIZE, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(STORE_HISTORY + i);
            SearchPatternData data = this.fPreviousSearchPatterns.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    private void statusMessage(boolean error, String message) {
        this.fStatusLabel.setText(message);
        if (error) {
            this.fStatusLabel.setForeground(JFaceColors.getErrorText((Display)this.fStatusLabel.getDisplay()));
        } else {
            this.fStatusLabel.setForeground(null);
        }
    }

    private static class SearchPatternData {
        private static final String XPATH_SETTINGS_ID = "xpath";
        private static final String XPATH_EVALUATOR_SETTINGS_ID = "xpathProcessor";
        private static final String FILE_NAME_PATTERNS_SETTINGS_ID = "fileNamePatterns";
        private static final String SCOPE_SETTINGS_ID = "scope";
        private static final String WORKING_SETS_SETTINGS_ID = "workingSets";
        public final String xpath;
        public final String xpathProcessorId;
        public final String[] fileNamePatterns;
        public final int scope;
        public final IWorkingSet[] workingSets;

        public SearchPatternData(String xpath, String xpathProcessorId, String[] fileNamePatterns, int scope, IWorkingSet[] workingSets) {
            Assert.isNotNull((Object)fileNamePatterns);
            this.xpath = xpath;
            this.xpathProcessorId = xpathProcessorId;
            this.fileNamePatterns = fileNamePatterns;
            this.scope = scope;
            this.workingSets = workingSets;
        }

        public void store(IDialogSettings settings) {
            settings.put(XPATH_SETTINGS_ID, this.xpath);
            settings.put(XPATH_EVALUATOR_SETTINGS_ID, this.xpathProcessorId);
            settings.put(FILE_NAME_PATTERNS_SETTINGS_ID, this.fileNamePatterns);
            settings.put(SCOPE_SETTINGS_ID, this.scope);
            if (this.workingSets != null) {
                String[] wsIds = new String[this.workingSets.length];
                int i = 0;
                while (i < this.workingSets.length) {
                    wsIds[i] = this.workingSets[i].getLabel();
                    ++i;
                }
                settings.put(WORKING_SETS_SETTINGS_ID, wsIds);
            } else {
                settings.put(WORKING_SETS_SETTINGS_ID, new String[0]);
            }
        }

        public static SearchPatternData create(IDialogSettings settings) {
            String[] fileNamePatterns;
            String xpath = settings.get(XPATH_SETTINGS_ID);
            String xpathProcessorId = settings.get(XPATH_EVALUATOR_SETTINGS_ID);
            String[] wsIds = settings.getArray(WORKING_SETS_SETTINGS_ID);
            IWorkingSet[] workingSets = null;
            if (wsIds != null && wsIds.length > 0) {
                IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
                workingSets = new IWorkingSet[wsIds.length];
                int i = 0;
                while (workingSets != null && i < wsIds.length) {
                    workingSets[i] = workingSetManager.getWorkingSet(wsIds[i]);
                    if (workingSets[i] == null) {
                        workingSets = null;
                    }
                    ++i;
                }
            }
            if ((fileNamePatterns = settings.getArray(FILE_NAME_PATTERNS_SETTINGS_ID)) == null) {
                fileNamePatterns = StringUtils.EMPTY_ARRAY;
            }
            try {
                int scope = settings.getInt(SCOPE_SETTINGS_ID);
                return new SearchPatternData(xpath, xpathProcessorId, fileNamePatterns, scope, workingSets);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }

    private static class XPathProcessorContentProvider
    implements IStructuredContentProvider {
        private XPathProcessorContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return XPathProcessorManager.getDefault().getProcessors();
        }
    }

    private static class XPathProcessorLabelProvider
    extends LabelProvider {
        private XPathProcessorLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ((IXPathProcessorType)element).getName();
        }
    }
}

