/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.ui.util;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.search.core.XMLSearchEngine2;
import org.eclipse.wst.xml.search.core.queryspecifications.IXMLQuerySpecificationRegistry;
import org.eclipse.wst.xml.search.core.reporter.IXMLSearchReporter;
import org.eclipse.wst.xml.search.ui.internal.Messages;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchQuery;
import org.eclipse.wst.xml.search.ui.internal.participant.SearchParticipantDescriptor;

public class SearchUtil {
    public static void runQueryInBackground(Object query) {
        NewSearchUI.runQueryInBackground((ISearchQuery)((ISearchQuery)query));
    }

    public static IStatus runQueryInForeground(IRunnableContext context, Object query) {
        return NewSearchUI.runQueryInForeground((IRunnableContext)context, (ISearchQuery)((ISearchQuery)query));
    }

    public static ITextEditor getTextEditor(ExecutionEvent event) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        return SearchUtil.getTextEditor(editor);
    }

    public static ITextEditor getTextEditor(IEditorPart editor) {
        if (editor instanceof ITextEditor) {
            return (ITextEditor)editor;
        }
        Object o = editor.getAdapter(ITextEditor.class);
        if (o != null) {
            return (ITextEditor)o;
        }
        return null;
    }

    public static IFile getFile(IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof IFileEditorInput)) {
            return null;
        }
        return ((IFileEditorInput)editorInput).getFile();
    }

    public static void performNewSearch(Shell shell, IXMLQuerySpecificationRegistry querySpecificationRegistry, SearchParticipantDescriptor[] participantDescriptors, IXMLSearchReporter reporter) throws InterruptedException, CoreException {
        XMLSearchQuery query = new XMLSearchQuery(querySpecificationRegistry, participantDescriptors, XMLSearchEngine2.getDefault(), reporter);
        if (query.canRunInBackground()) {
            SearchUtil.runQueryInBackground(query);
        } else {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IStatus status = SearchUtil.runQueryInForeground((IRunnableContext)progressService, query);
            if (status.matches(7)) {
                ErrorDialog.openError((Shell)shell, (String)Messages.Search_Error_search_title, (String)Messages.Search_Error_search_message, (IStatus)status);
            }
        }
    }
}

