/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionRegistry;
import org.eclipse.persistence.jpa.jpql.utility.filter.Filter;
import org.eclipse.persistence.jpa.jpql.utility.filter.NullFilter;
import org.eclipse.persistence.jpa.jpql.utility.iterable.ArrayIterable;

public abstract class JPQLQueryBNF {
    private Map<String, ExpressionFactory> cachedExpressionFactories;
    private String[] cachedExpressionFactoryIds;
    private String[] cachedIdentifiers;
    private JPQLQueryBNF[] childQueryBNFs;
    private List<String> children;
    private boolean compound;
    private List<String> expressionFactoryIds;
    private ExpressionRegistry expressionRegistry;
    private String fallbackBNFId;
    private String fallbackExpressionFactoryId;
    private Boolean handleAggregate;
    private Boolean handleCollection;
    private boolean handleNestedArray;
    private boolean handleSubExpression;
    private String id;
    private JPQLQueryBNF[] nonCompoundChildren;
    private static final Filter<JPQLQueryBNF> nonCompoundFilter = JPQLQueryBNF.buildNonCompoundFilter();

    protected JPQLQueryBNF(String id) {
        this.initialize(id);
    }

    private static Filter<JPQLQueryBNF> buildNonCompoundFilter() {
        return new Filter<JPQLQueryBNF>(){

            @Override
            public boolean accept(JPQLQueryBNF queryBNF) {
                return !queryBNF.isCompound();
            }
        };
    }

    private void addChildren(Set<JPQLQueryBNF> queryBNFs, Filter<JPQLQueryBNF> filter) {
        if (this.children != null) {
            for (String id : this.children) {
                JPQLQueryBNF queryBNF = this.expressionRegistry.getQueryBNF(id);
                if (!queryBNFs.add(queryBNF) || !filter.accept(queryBNF)) continue;
                queryBNF.addChildren(queryBNFs, filter);
            }
        }
    }

    private JPQLQueryBNF[] buildChildren(Filter<JPQLQueryBNF> filter) {
        HashSet<JPQLQueryBNF> queryBNFs = new HashSet<JPQLQueryBNF>();
        queryBNFs.add(this);
        this.addChildren(queryBNFs, filter);
        JPQLQueryBNF[] children = new JPQLQueryBNF[queryBNFs.size()];
        queryBNFs.toArray(children);
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateExpressionFactories() {
        JPQLQueryBNF jPQLQueryBNF = this;
        synchronized (jPQLQueryBNF) {
            if (this.cachedExpressionFactories == null) {
                HashMap<String, ExpressionFactory> factories = new HashMap<String, ExpressionFactory>();
                String[] stringArray = this.getExpressionFactoryIdsImp();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String expressionFactoryId = stringArray[n2];
                    ExpressionFactory expressionFactory = this.expressionRegistry.getExpressionFactory(expressionFactoryId);
                    String[] stringArray2 = expressionFactory.identifiers();
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String identifier = stringArray2[n4];
                        factories.put(identifier, expressionFactory);
                        ++n4;
                    }
                    ++n2;
                }
                this.cachedIdentifiers = new String[factories.size()];
                factories.keySet().toArray(this.cachedIdentifiers);
                this.cachedExpressionFactories = factories;
            }
        }
    }

    private void calculateExpressionFactoryIds(Set<JPQLQueryBNF> queryBNFs, Set<String> factoryIds) {
        if (this.expressionFactoryIds != null) {
            factoryIds.addAll(this.expressionFactoryIds);
        }
        JPQLQueryBNF[] jPQLQueryBNFArray = this.getChildren();
        int n = jPQLQueryBNFArray.length;
        int n2 = 0;
        while (n2 < n) {
            JPQLQueryBNF queryBNF = jPQLQueryBNFArray[n2];
            if (queryBNF != this && queryBNFs.add(queryBNF)) {
                queryBNF.calculateExpressionFactoryIds(queryBNFs, factoryIds);
            }
            ++n2;
        }
    }

    private Boolean calculateHandleAggregate(Set<JPQLQueryBNF> queryBNFs) {
        if (this.handleAggregate != null) {
            return this.handleAggregate;
        }
        JPQLQueryBNF[] jPQLQueryBNFArray = this.getChildren();
        int n = jPQLQueryBNFArray.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean result;
            JPQLQueryBNF queryBNF = jPQLQueryBNFArray[n2];
            if (queryBNF != this && queryBNFs.add(queryBNF) && (result = queryBNF.calculateHandleAggregate(queryBNFs)) == Boolean.TRUE) {
                return result;
            }
            ++n2;
        }
        return Boolean.FALSE;
    }

    private Boolean calculateHandleCollection(Set<JPQLQueryBNF> queryBNFs) {
        if (this.handleCollection != null) {
            return this.handleCollection;
        }
        JPQLQueryBNF[] jPQLQueryBNFArray = this.getChildren();
        int n = jPQLQueryBNFArray.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean result;
            JPQLQueryBNF queryBNF = jPQLQueryBNFArray[n2];
            if (queryBNF != this && queryBNFs.add(queryBNF) && (result = queryBNF.calculateHandleCollection(queryBNFs)) == Boolean.TRUE) {
                return result;
            }
            ++n2;
        }
        return Boolean.FALSE;
    }

    public Iterable<JPQLQueryBNF> children() {
        return new ArrayIterable<JPQLQueryBNF>(this.getChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JPQLQueryBNF[] getChildren() {
        if (this.childQueryBNFs != null) {
            return this.childQueryBNFs;
        }
        JPQLQueryBNF jPQLQueryBNF = this;
        synchronized (jPQLQueryBNF) {
            if (this.childQueryBNFs == null) {
                this.childQueryBNFs = this.buildChildren(NullFilter.<JPQLQueryBNF>instance());
            }
        }
        return this.childQueryBNFs;
    }

    public ExpressionFactory getExpressionFactory(String identifier) {
        if (this.cachedExpressionFactories != null) {
            return this.cachedExpressionFactories.get(identifier.toUpperCase());
        }
        this.calculateExpressionFactories();
        return this.cachedExpressionFactories.get(identifier.toUpperCase());
    }

    public Iterable<String> getExpressionFactoryIds() {
        return new ArrayIterable<String>(this.getExpressionFactoryIdsImp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getExpressionFactoryIdsImp() {
        if (this.cachedExpressionFactoryIds != null) {
            return this.cachedExpressionFactoryIds;
        }
        JPQLQueryBNF jPQLQueryBNF = this;
        synchronized (jPQLQueryBNF) {
            if (this.cachedExpressionFactoryIds == null) {
                HashSet<JPQLQueryBNF> queryBNFs = new HashSet<JPQLQueryBNF>();
                HashSet<String> factoryIds = new HashSet<String>();
                this.calculateExpressionFactoryIds(queryBNFs, factoryIds);
                this.cachedExpressionFactoryIds = new String[factoryIds.size()];
                factoryIds.toArray(this.cachedExpressionFactoryIds);
            }
        }
        return this.cachedExpressionFactoryIds;
    }

    public ExpressionRegistry getExpressionRegistry() {
        return this.expressionRegistry;
    }

    public String getFallbackBNFId() {
        return this.fallbackBNFId;
    }

    public String getFallbackExpressionFactoryId() {
        return this.fallbackExpressionFactoryId;
    }

    public String getId() {
        return this.id;
    }

    public Iterable<String> getIdentifiers() {
        if (this.cachedExpressionFactoryIds != null) {
            return new ArrayIterable<String>(this.cachedIdentifiers);
        }
        this.calculateExpressionFactories();
        return new ArrayIterable<String>(this.cachedIdentifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleAggregate() {
        if (this.handleAggregate != null) {
            return this.handleAggregate;
        }
        JPQLQueryBNF jPQLQueryBNF = this;
        synchronized (jPQLQueryBNF) {
            if (this.handleAggregate == null) {
                HashSet<JPQLQueryBNF> children = new HashSet<JPQLQueryBNF>();
                this.handleAggregate = this.calculateHandleAggregate(children);
            }
        }
        return this.handleAggregate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleCollection() {
        if (this.handleCollection != null) {
            return this.handleCollection;
        }
        JPQLQueryBNF jPQLQueryBNF = this;
        synchronized (jPQLQueryBNF) {
            if (this.handleCollection == null) {
                HashSet<JPQLQueryBNF> children = new HashSet<JPQLQueryBNF>();
                this.handleCollection = this.calculateHandleCollection(children);
            }
        }
        return this.handleCollection;
    }

    public boolean handlesNestedArray() {
        return this.handleNestedArray;
    }

    public boolean handleSubExpression() {
        return this.handleSubExpression;
    }

    public boolean hasChild(String queryBNFId) {
        JPQLQueryBNF[] jPQLQueryBNFArray = this.getChildren();
        int n = jPQLQueryBNFArray.length;
        int n2 = 0;
        while (n2 < n) {
            JPQLQueryBNF child = jPQLQueryBNFArray[n2];
            if (child.getId() == queryBNFId) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasIdentifier(String word) {
        if (this.cachedExpressionFactories != null) {
            return this.cachedExpressionFactories.containsKey(word);
        }
        this.calculateExpressionFactories();
        return this.cachedExpressionFactories.containsKey(word);
    }

    protected void initialize() {
    }

    private void initialize(String id) {
        if (id == null) {
            throw new NullPointerException("The unique identifier of this JPQLQueryBNF cannot be null");
        }
        this.id = id;
        this.initialize();
    }

    public boolean isCompound() {
        return this.compound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<JPQLQueryBNF> nonCompoundChildren() {
        if (this.nonCompoundChildren != null) {
            return new ArrayIterable<JPQLQueryBNF>(this.nonCompoundChildren);
        }
        JPQLQueryBNF jPQLQueryBNF = this;
        synchronized (jPQLQueryBNF) {
            if (this.nonCompoundChildren == null) {
                this.nonCompoundChildren = this.buildChildren(nonCompoundFilter);
            }
        }
        return new ArrayIterable<JPQLQueryBNF>(this.nonCompoundChildren);
    }

    protected final void registerChild(String queryBNFId) {
        if (queryBNFId == null) {
            throw new NullPointerException("The queryBNFId cannot be null");
        }
        if (this.children == null) {
            this.children = new LinkedList<String>();
        }
        this.children.add(queryBNFId);
    }

    protected final void registerExpressionFactory(String expressionFactoryId) {
        if (expressionFactoryId == null) {
            throw new NullPointerException("The expressionFactoryId cannot be null");
        }
        if (this.expressionFactoryIds == null) {
            this.expressionFactoryIds = new LinkedList<String>();
        }
        this.expressionFactoryIds.add(expressionFactoryId);
    }

    public void setCompound(boolean compound) {
        this.compound = compound;
    }

    final void setExpressionRegistry(ExpressionRegistry expressionRegistry) {
        this.expressionRegistry = expressionRegistry;
    }

    public void setFallbackBNFId(String fallbackBNFId) {
        this.fallbackBNFId = fallbackBNFId;
    }

    public void setFallbackExpressionFactoryId(String fallbackExpressionFactoryId) {
        this.fallbackExpressionFactoryId = fallbackExpressionFactoryId;
    }

    public void setHandleAggregate(boolean handleAggregate) {
        this.handleAggregate = handleAggregate;
    }

    public void setHandleCollection(boolean handleCollection) {
        this.handleCollection = handleCollection;
    }

    public void setHandleNestedArray(boolean handleNestedArray) {
        this.handleNestedArray = handleNestedArray;
    }

    public void setHandleSubExpression(boolean handleSubExpression) {
        this.handleSubExpression = handleSubExpression;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        this.toString(sb);
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
        sb.append("(");
        sb.append(this.id);
        sb.append(")\n\nidentifiers=");
        sb.append(this.getIdentifiers());
        sb.append("\n\nexpressionFactories=");
        sb.append(Arrays.toString(this.getExpressionFactoryIdsImp()));
    }
}

