/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBException;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Attribute;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Descriptor;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.LinkTemplate;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Query;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jpa.rs.DataStorage;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactory;
import org.eclipse.persistence.jpa.rs.PersistenceContextFactoryProvider;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.ServiceVersion;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.list.LinkList;
import org.eclipse.persistence.jpa.rs.util.list.QueryList;

public abstract class AbstractResource {
    public static final String SERVICE_VERSION_FORMAT = "v\\d\\.\\d";
    protected PersistenceContextFactory factory;

    public void setPersistenceFactory(PersistenceContextFactory factory) {
        this.factory = factory;
    }

    public PersistenceContextFactory getPersistenceFactory() {
        return this.getPersistenceFactory(Thread.currentThread().getContextClassLoader());
    }

    public PersistenceContextFactory getPersistenceFactory(ClassLoader loader) {
        if (this.factory == null) {
            this.factory = this.buildPersistenceContextFactory(loader);
        }
        return this.factory;
    }

    protected PersistenceContextFactory buildPersistenceContextFactory(ClassLoader loader) {
        ServiceLoader<PersistenceContextFactoryProvider> contextFactoryLoader = ServiceLoader.load(PersistenceContextFactoryProvider.class, loader);
        for (PersistenceContextFactoryProvider provider : contextFactoryLoader) {
            PersistenceContextFactory factory = provider.getPersistenceContextFactory(null);
            if (factory == null) continue;
            return factory;
        }
        return null;
    }

    protected static Map<String, String> getMatrixParameters(UriInfo info, String segment) {
        HashMap<String, String> matrixParameters = new HashMap<String, String>();
        for (PathSegment pathSegment : info.getPathSegments()) {
            if (pathSegment.getPath() == null || !pathSegment.getPath().equals(segment)) continue;
            for (Map.Entry entry : pathSegment.getMatrixParameters().entrySet()) {
                matrixParameters.put((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
            }
            return matrixParameters;
        }
        return matrixParameters;
    }

    public static Map<String, Object> getQueryParameters(UriInfo info) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        for (String key : info.getQueryParameters().keySet()) {
            queryParameters.put(key, info.getQueryParameters().getFirst((Object)key));
        }
        return queryParameters;
    }

    protected static boolean isValidVersion(String version) {
        return ServiceVersion.hasCode(version);
    }

    protected PersistenceContext getPersistenceContext(String persistenceUnit, String entityType, URI baseURI, String version, Map<String, Object> initializationProperties) {
        if (!AbstractResource.isValidVersion(version)) {
            JPARSLogger.error("unsupported_service_version_in_the_request", new Object[]{version});
            throw new IllegalArgumentException();
        }
        PersistenceContext context = this.getPersistenceFactory().get(persistenceUnit, baseURI, version, initializationProperties);
        if (context == null) {
            JPARSLogger.error("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            throw JPARSException.persistenceContextCouldNotBeBootstrapped(persistenceUnit);
        }
        if (entityType != null && context.getClass(entityType) == null) {
            JPARSLogger.error("jpars_could_not_find_class_in_persistence_unit", new Object[]{entityType, persistenceUnit});
            throw JPARSException.classOrClassDescriptorCouldNotBeFoundForEntity(entityType, persistenceUnit);
        }
        return context;
    }

    protected String getRelationshipPartner(Map<String, String> matrixParams, Map<String, Object> queryParams) {
        String partner = null;
        if (queryParams != null && !queryParams.isEmpty()) {
            partner = (String)queryParams.get("eclipselink.jpars.partner");
        }
        if (partner == null && matrixParams != null && !matrixParams.isEmpty()) {
            partner = matrixParams.get("partner");
        }
        return partner;
    }

    protected String marshallMetadata(Object metadata, String mediaType) throws JAXBException {
        Class[] jaxbClasses = new Class[]{Link.class, Attribute.class, Descriptor.class, LinkTemplate.class, PersistenceUnit.class, Query.class, LinkList.class, QueryList.class};
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext((Class[])jaxbClasses, null);
        JAXBMarshaller marshaller = context.createMarshaller();
        marshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
        marshaller.setProperty("eclipselink.media-type", (Object)mediaType);
        marshaller.setProperty("eclipselink.json.reduce-any-arrays", (Object)true);
        StringWriter writer = new StringWriter();
        marshaller.marshal(metadata, (Writer)writer);
        return writer.toString();
    }

    private static String getEncodedUri(String uri) {
        try {
            return URLEncoder.encode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return uri;
        }
    }

    private static String getDecodedUri(String uri) {
        try {
            return URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return uri;
        }
    }

    protected void setRequestUniqueId() {
        DataStorage.set("requestId", UUID.randomUUID().toString());
    }
}

