/*
 * Decompiled with CFR 0.152.
 */
package tern.server.protocol.guesstypes;

import tern.server.protocol.IJSONObjectHelper;
import tern.server.protocol.ITernResultProcessor;
import tern.server.protocol.TernDoc;
import tern.server.protocol.completions.TernCompletionProposalRec;
import tern.server.protocol.guesstypes.ITernGuessTypesCollector;

public class TernGuessTypesResultProcessor
implements ITernResultProcessor<ITernGuessTypesCollector> {
    public static final TernGuessTypesResultProcessor INSTANCE = new TernGuessTypesResultProcessor();
    private static final String ARGS_FIELD_NAME = "!args";
    private static final String NAME_PROPERTY = "name";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private static final String TYPE_PROPERTY = "type";
    private static final String DOC_PROPERTY = "doc";
    private static final String URL_PROPERTY = "url";
    private static final String ORIGIN_PROPERTY = "origin";

    @Override
    public void process(TernDoc doc, IJSONObjectHelper objectHelper, Object jsonObject, ITernGuessTypesCollector collector) {
        Iterable<Object> args = objectHelper.getList(jsonObject, ARGS_FIELD_NAME);
        if (args != null) {
            String[] argTypes = null;
            String argType = null;
            int argIndex = 0;
            for (Object arg : args) {
                argTypes = objectHelper.getText(arg).split("[|]");
                int i = 0;
                while (i < argTypes.length) {
                    argType = argTypes[i];
                    Iterable<Object> namesForArg = objectHelper.getList(jsonObject, argType);
                    if (namesForArg != null) {
                        for (Object argValue : namesForArg) {
                            if (objectHelper.isString(argValue)) {
                                collector.addProposal(argIndex, new TernCompletionProposalRec(objectHelper.getText(argValue), objectHelper.getText(argValue), argType, null, null, null, 0, 0, false, false, false), argValue, objectHelper);
                                continue;
                            }
                            this.addProposal(argIndex, objectHelper, argValue, collector);
                        }
                    }
                    ++i;
                }
                ++argIndex;
            }
        }
    }

    private void addProposal(int argIndex, IJSONObjectHelper objectHelper, Object completion, ITernGuessTypesCollector collector) {
        String name = objectHelper.getText(completion, NAME_PROPERTY);
        String displayName = objectHelper.getText(completion, DISPLAY_NAME_PROPERTY);
        String type = objectHelper.getText(completion, TYPE_PROPERTY);
        String doc = objectHelper.getText(completion, DOC_PROPERTY);
        String url = objectHelper.getText(completion, URL_PROPERTY);
        String origin = objectHelper.getText(completion, ORIGIN_PROPERTY);
        collector.addProposal(argIndex, new TernCompletionProposalRec(name, displayName, type, doc, url, origin, 0, 0, false, false, false), completion, objectHelper);
    }
}

