/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.ui.editor;

import com.liferay.ide.server.core.portal.PortalRuntime;
import com.liferay.ide.server.ui.cmd.SetPortalServerHttpPortCommand;
import com.liferay.ide.server.ui.editor.AbstractPortalServerEditorSection;
import java.beans.PropertyChangeEvent;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PortalServerPortsEditorSection
extends AbstractPortalServerEditorSection {
    protected Text httpPort;

    @Override
    protected void addPropertyListeners(PropertyChangeEvent event) {
        if ("http-port".equals(event.getPropertyName())) {
            String s = (String)event.getNewValue();
            this.httpPort.setText(s);
            this.validate();
        }
    }

    @Override
    protected void createEditorSection(FormToolkit toolkit, Composite composite) {
        Label label = this.createLabel(toolkit, composite, Msgs.httpPort);
        GridData data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.httpPort = toolkit.createText(composite, null);
        this.httpPort.setLayoutData((Object)new GridData(4, 128, true, false));
        this.httpPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PortalServerPortsEditorSection.this.updating) {
                    return;
                }
                PortalServerPortsEditorSection.this.updating = true;
                PortalServerPortsEditorSection.this.execute((IUndoableOperation)new SetPortalServerHttpPortCommand(PortalServerPortsEditorSection.this.server, PortalServerPortsEditorSection.this.httpPort.getText().trim()));
                PortalServerPortsEditorSection.this.updating = false;
            }
        });
    }

    @Override
    protected String getSectionLabel() {
        return Msgs.ports;
    }

    @Override
    protected void initProperties() {
        this.httpPort.setText(this.portalServer.getHttpPort());
    }

    @Override
    protected void setDefault() {
        this.execute((IUndoableOperation)new SetPortalServerHttpPortCommand(this.server, "8080"));
        this.httpPort.setText("8080");
    }

    @Override
    protected boolean needCreate() {
        PortalRuntime runtime = (PortalRuntime)this.server.getRuntime().loadAdapter(PortalRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        return runtime != null;
    }

    private static class Msgs
    extends NLS {
        public static String httpPort;
        public static String ports;

        static {
            Msgs.initializeMessages((String)PortalServerPortsEditorSection.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

