/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.utils;

import com.google.common.io.Closeables;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.StringUtils;

public class Zips {
    public static void unzip(File zipFile, File destFolder) throws IOException {
        ZipInputStream zis = null;
        try {
            zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry entry = zis.getNextEntry();
            if (entry == null) {
                throw new IOException(MessageFormat.format("''{0}'' is empty or not a ZIP file.", zipFile));
            }
            do {
                if (entry.isDirectory()) continue;
                File file = new File(destFolder, entry.getName());
                Files.createParentDirs((File)file);
                Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND}).writeFrom((InputStream)zis);
            } while ((entry = zis.getNextEntry()) != null);
        }
        catch (Throwable throwable) {
            Closeables.close(zis, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)zis, (boolean)true);
    }

    public static void zip(File directory, File out) throws IOException {
        ZipOutputStream zos = null;
        try {
            OutputSupplier s = Files.newOutputStreamSupplier((File)out);
            zos = new ZipOutputStream((OutputStream)s.getOutput());
            for (File f : FileUtils.listFiles((File)directory, (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)DirectoryFileFilter.DIRECTORY)) {
                String path = StringUtils.removeStart((String)f.getPath(), (String)(String.valueOf(directory.getAbsolutePath()) + File.separator));
                path = path.replace(File.separatorChar, '/');
                ZipEntry e = new ZipEntry(path);
                zos.putNextEntry(e);
                Files.asByteSource((File)f).copyTo((OutputStream)zos);
                zos.closeEntry();
            }
        }
        catch (Throwable throwable) {
            Closeables.close(zos, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)zos, (boolean)false);
    }
}

