/*
 * Decompiled with CFR 0.152.
 */
package tern.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import tern.utils.StringUtils;

public class DOMUtils {
    private DOMUtils() {
    }

    public static String getNodeValue(Node node) {
        if (node == null) {
            return null;
        }
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ((Attr)node).getValue();
            }
            case 3: {
                return DOMUtils.getTextContent((Text)node);
            }
        }
        return node.getNodeValue();
    }

    public static String getTextContent(Text text) {
        return DOMUtils.getTextContent(text, true);
    }

    public static String getTextContent(Text text, boolean normalize) {
        if (normalize) {
            return StringUtils.normalizeSpace(text.getData());
        }
        return text.getData();
    }

    public static Element getFirstChildElementByTagName(Node parentNode, String elementName) {
        Element result = null;
        if (parentNode.getNodeType() == 9) {
            result = ((Document)parentNode).getDocumentElement();
            if (!result.getNodeName().equals(elementName)) {
                result = null;
            }
        } else {
            NodeList nodes = parentNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equals(elementName)) {
                    result = (Element)node;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static Collection<Element> getFirstChildElementsByTagName(Node contextNode, String elementName) {
        ArrayList<Element> elements = null;
        Element result = null;
        if (contextNode.getNodeType() == 9) {
            result = ((Document)contextNode).getDocumentElement();
            if (!result.getNodeName().equals(elementName)) {
                result = null;
            }
        } else {
            NodeList nodes = contextNode.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equals(elementName)) {
                    if (elements == null) {
                        elements = new ArrayList<Element>();
                    }
                    result = (Element)node;
                    elements.add(result);
                }
                ++i;
            }
        }
        if (elements == null) {
            return Collections.emptyList();
        }
        return elements;
    }

    public static Text getTextNode(Node parentNode) {
        if (parentNode == null) {
            return null;
        }
        Node result = null;
        parentNode.normalize();
        NodeList nodeList = parentNode.getNodeType() == 9 ? ((Document)parentNode).getDocumentElement().getChildNodes() : parentNode.getChildNodes();
        int len = nodeList.getLength();
        if (len == 0) {
            return null;
        }
        int i = 0;
        while (i < len) {
            result = nodeList.item(i);
            if (result.getNodeType() == 3) {
                return (Text)result;
            }
            if (result.getNodeType() == 4) {
                return (Text)result;
            }
            ++i;
        }
        return null;
    }

    public static String getTextNodeAsString(Node parentNode) {
        if (parentNode == null) {
            return null;
        }
        Text txt = DOMUtils.getTextNode(parentNode);
        if (txt == null) {
            return null;
        }
        return txt.getNodeValue();
    }

    public static Element getOwnerElement(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ((Attr)node).getOwnerElement();
            }
            case 3: {
                return (Element)((Text)node).getParentNode();
            }
            case 4: {
                return (Element)((CDATASection)node).getParentNode();
            }
            case 1: {
                return (Element)node;
            }
        }
        return null;
    }
}

