/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.project.core.BinaryProjectRecord;
import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.SDKProjectsImportOperation;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKManager;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.internal.BridgedRuntime;

public class BinaryProjectImportOperation
extends SDKProjectsImportOperation {
    public BinaryProjectImportOperation(IDataModel model) {
        super(model);
    }

    @Override
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Object selectedProjects = this.getDataModel().getProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS");
        BridgedRuntime bridgedRuntime = (BridgedRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        String sdkLocation = this.model.getStringProperty("ISDKProjectsImportDataModelProperties.SDK_LOCATION");
        if (selectedProjects != null) {
            SDKManager sdkManager = SDKManager.getInstance();
            SDK liferaySDK = sdkManager.getSDK((IPath)new Path(sdkLocation));
            Object[] seleBinaryRecords = (Object[])selectedProjects;
            ProjectRecord[] projectRecords = new ProjectRecord[1];
            if (seleBinaryRecords != null) {
                BinaryProjectRecord pluginBinaryRecord = (BinaryProjectRecord)seleBinaryRecords[0];
                try {
                    projectRecords[0] = ProjectImportUtil.createSDKPluginProject(bridgedRuntime, pluginBinaryRecord, liferaySDK);
                }
                catch (Exception e) {
                    throw new ExecutionException("Error while importing Binary:" + pluginBinaryRecord.getBinaryName(), (Throwable)e);
                }
                this.getDataModel().setProperty("ISDKProjectsImportDataModelProperties.SELECTED_PROJECTS", (Object)projectRecords);
            }
        }
        return super.execute(monitor, info);
    }
}

