/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.SDKClasspathContainer;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorations;
import org.eclipse.jst.common.jdt.internal.classpath.ClasspathDecorationsManager;

public class SDKClasspathContainerInitializer
extends ClasspathContainerInitializer {
    protected static final ClasspathDecorationsManager cpDecorations = SDKClasspathContainer.getDecorationsManager();

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    private IPath[] getSDKDependencies(IJavaProject project) {
        IPath[] dependencyJarPaths = null;
        SDK sdk = SDKUtil.getSDKFromProjectDir((File)project.getProject().getLocation().toFile());
        if (sdk != null) {
            dependencyJarPaths = sdk.getDependencyJarPaths();
        }
        return dependencyJarPaths;
    }

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        SDKClasspathContainer classpathContainer = null;
        String root = containerPath.segment(0);
        if (!"com.liferay.ide.sdk.container".equals(root)) {
            String msg = "Invalid plugin classpath container, expecting container root ";
            throw new CoreException(ProjectCore.createErrorStatus("Invalid plugin classpath container, expecting container root com.liferay.ide.sdk.container"));
        }
        PortalBundle bundle = ServerUtil.getPortalBundle((IProject)project.getProject());
        if (bundle == null) {
            String msg = "Invalid sdk properties setting.";
            throw new CoreException(ProjectCore.createErrorStatus("Invalid sdk properties setting."));
        }
        IPath globalDir = bundle.getAppServerLibGlobalDir();
        IPath portalDir = bundle.getAppServerPortalDir();
        IPath bundleDir = bundle.getAppServerDir();
        IPath[] bundleDependencyJars = bundle.getBundleDependencyJars();
        IPath[] sdkDependencyJarPaths = this.getSDKDependencies(project);
        if (portalDir == null) {
            return;
        }
        classpathContainer = new SDKClasspathContainer(containerPath, project, portalDir, null, null, globalDir, bundleDir, bundleDependencyJars, sdkDependencyJarPaths);
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{classpathContainer}, null);
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        String key = SDKClasspathContainer.getDecorationManagerKey(project.getProject(), containerPath.toString());
        IClasspathEntry[] entries = containerSuggestion.getClasspathEntries();
        cpDecorations.clearAllDecorations(key);
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            IPath srcpath = entry.getSourceAttachmentPath();
            IPath srcrootpath = entry.getSourceAttachmentRootPath();
            IClasspathAttribute[] attrs = entry.getExtraAttributes();
            if (srcpath != null || attrs.length > 0) {
                String eid = entry.getPath().toString();
                ClasspathDecorations dec = new ClasspathDecorations();
                dec.setSourceAttachmentPath(srcpath);
                dec.setSourceAttachmentRootPath(srcrootpath);
                dec.setExtraAttributes(attrs);
                cpDecorations.setDecorations(key, eid, dec);
            }
            ++i;
        }
        cpDecorations.save();
        IPath portalDir = null;
        IPath portalGlobalDir = null;
        String javadocURL = null;
        IPath sourceLocation = null;
        IPath bundleDir = null;
        IPath[] bundleDependencyJarPaths = null;
        PortalBundle bundle = ServerUtil.getPortalBundle((IProject)project.getProject());
        boolean containerChanged = true;
        if (containerSuggestion instanceof SDKClasspathContainer) {
            portalDir = ((SDKClasspathContainer)containerSuggestion).getPortalDir();
            bundleDir = ((SDKClasspathContainer)containerSuggestion).getBundleDir();
            portalGlobalDir = ((SDKClasspathContainer)containerSuggestion).getPortalGlobalDir();
            javadocURL = ((SDKClasspathContainer)containerSuggestion).getJavadocURL();
            sourceLocation = ((SDKClasspathContainer)containerSuggestion).getSourceLocation();
            bundleDependencyJarPaths = ((SDKClasspathContainer)containerSuggestion).getBundleLibDependencyPath();
            if (bundle != null && bundle.getAppServerPortalDir().equals((Object)portalDir)) {
                containerChanged = false;
            }
        }
        if (containerChanged) {
            if (bundle == null) {
                return;
            }
            portalDir = bundle.getAppServerPortalDir();
            portalGlobalDir = bundle.getAppServerLibGlobalDir();
            bundleDependencyJarPaths = bundle.getBundleDependencyJars();
        }
        IPath[] sdkDependencyPaths = this.getSDKDependencies(project);
        if (portalDir != null && portalGlobalDir != null) {
            SDKClasspathContainer newContainer = new SDKClasspathContainer(containerPath, project, portalDir, javadocURL, sourceLocation, portalGlobalDir, bundleDir, bundleDependencyJarPaths, sdkDependencyPaths);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{newContainer}, null);
        }
    }
}

