/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.descriptor;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.descriptor.IDescriptorOperation;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.internal.content.ContentTypeManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.osgi.framework.Version;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class LiferayDescriptorHelper {
    protected ArrayList<IDescriptorOperation> descriptorOperations = new ArrayList();
    protected IContentType contentType;
    protected String descriptorPath;
    protected IProject project;

    public static String getDescriptorVersion(IProject project) {
        return LiferayDescriptorHelper.getDescriptorVersion(project, "6.0.0");
    }

    public static String getDescriptorVersion(IProject project, String defaultValue) {
        String retval = defaultValue;
        try {
            ILiferayPortal portal;
            ILiferayProject lProject = LiferayCore.create((Object)project);
            if (lProject != null && (portal = (ILiferayPortal)lProject.adapt(ILiferayPortal.class)) != null) {
                String versionStr = portal.getVersion();
                retval = LiferayDescriptorHelper.getDescriptorVersionFromPortalVersion(versionStr);
            }
        }
        catch (Exception e) {
            LiferayCore.logError((String)"Could not get liferay runtime.", (Throwable)e);
        }
        if ("0.0.0".equals(retval)) {
            retval = defaultValue;
        }
        return retval;
    }

    protected static String getDescriptorVersionFromPortalVersion(String versionStr) {
        Version version = new Version(versionStr);
        int major = version.getMajor();
        int minor = version.getMinor();
        return String.valueOf(Integer.toString(major)) + "." + Integer.toString(minor) + ".0";
    }

    public LiferayDescriptorHelper() {
        this.addDescriptorOperations();
    }

    public LiferayDescriptorHelper(IProject project) {
        this.project = project;
        this.addDescriptorOperations();
    }

    protected void addDescriptorOperation(IDescriptorOperation operation) {
        this.descriptorOperations.add(operation);
    }

    protected abstract void addDescriptorOperations();

    protected List<Element> getChildElements(Element parent) {
        ArrayList<Element> retval = new ArrayList<Element>();
        if (parent != null) {
            NodeList children = parent.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child instanceof Element) {
                    retval.add((Element)child);
                }
                ++i;
            }
        }
        return retval;
    }

    public IContentType getContentType() {
        return this.contentType;
    }

    public abstract IFile getDescriptorFile();

    protected IFile getDescriptorFile(String fileName) {
        if (!CoreUtil.isLiferayProject((IProject)this.project)) {
            this.project = CoreUtil.getLiferayProject((IResource)this.project);
        }
        return this.project == null ? null : LiferayCore.create((Object)this.project).getDescriptorFile(fileName);
    }

    public IDescriptorOperation getDescriptorOperation(Class<? extends IDescriptorOperation> type) {
        for (IDescriptorOperation operation : this.descriptorOperations) {
            if (!type.isAssignableFrom(operation.getClass())) continue;
            return operation;
        }
        return null;
    }

    public String getDescriptorPath() {
        return this.descriptorPath;
    }

    protected String getDescriptorVersion() {
        return LiferayDescriptorHelper.getDescriptorVersion(this.project);
    }

    protected IProject getProject() {
        return this.project;
    }

    protected IStatus removeAllElements(IDOMDocument document, String tagName) {
        if (document == null) {
            return ProjectCore.createErrorStatus(MessageFormat.format("Could not remove {0} elements: null document", tagName));
        }
        NodeList elements = document.getElementsByTagName(tagName);
        try {
            if (elements != null && elements.getLength() > 0) {
                int i = 0;
                while (i < elements.getLength()) {
                    Node element = elements.item(i);
                    element.getParentNode().removeChild(element);
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            return ProjectCore.createErrorStatus(MessageFormat.format("Could not remove {0} elements", tagName), ex);
        }
        return Status.OK_STATUS;
    }

    public void setContentType(IContentType type) {
        this.contentType = type;
    }

    public void setContentType(String type) {
        this.contentType = ContentTypeManager.getInstance().getContentType(type);
    }

    public void setDescriptorPath(String path) {
        this.descriptorPath = path;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public abstract class DOMModelEditOperation
    extends DOMModelOperation {
        public DOMModelEditOperation(IFile descriptorFile) {
            super(descriptorFile);
        }

        public void createDefaultDescriptor(String templateString, String version) {
            String content = MessageFormat.format(templateString, version, version.replace('.', '_'));
            try {
                this.file.create((InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")), 1, null);
            }
            catch (Exception e) {
                LiferayCore.logError((Throwable)e);
            }
        }

        protected void createDefaultFile() {
        }

        @Override
        public IStatus execute() {
            IStatus retval = null;
            if (!this.file.exists()) {
                this.createDefaultFile();
            }
            IDOMModel domModel = null;
            try {
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(this.file);
                    domModel.aboutToChangeModel();
                    IDOMDocument document = domModel.getDocument();
                    retval = this.doExecute(document);
                    domModel.changedModel();
                    domModel.save();
                }
                catch (Exception e) {
                    retval = LiferayCore.createErrorStatus((Exception)e);
                    if (domModel != null) {
                        domModel.releaseFromEdit();
                    }
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromEdit();
                }
            }
            return retval;
        }
    }

    protected static abstract class DOMModelOperation {
        protected IFile file;

        public DOMModelOperation(IFile descriptorFile) {
            this.file = descriptorFile;
        }

        protected abstract IStatus doExecute(IDOMDocument var1);

        public abstract IStatus execute();
    }

    protected abstract class DOMModelReadOperation
    extends DOMModelOperation {
        public DOMModelReadOperation(IFile descriptorFile) {
            super(descriptorFile);
        }

        @Override
        public IStatus execute() {
            IStatus retval = null;
            if (!this.file.exists()) {
                return LiferayCore.createErrorStatus((String)(String.valueOf(this.file.getName()) + " doesn't exist"));
            }
            IDOMModel domModel = null;
            try {
                try {
                    domModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForRead(this.file);
                    IDOMDocument document = domModel.getDocument();
                    retval = this.doExecute(document);
                }
                catch (Exception e) {
                    retval = LiferayCore.createErrorStatus((Exception)e);
                    if (domModel != null) {
                        domModel.releaseFromRead();
                    }
                }
            }
            finally {
                if (domModel != null) {
                    domModel.releaseFromRead();
                }
            }
            return retval;
        }
    }
}

