/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.jsf;

import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.jsf.NewLiferayJSFModuleProjectOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;

public class NewLiferayJSFModuleProjectOpMethods {
    public static final Status execute(NewLiferayJSFModuleProjectOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Creating Liferay JSF project (this process may take several minutes)", 100);
        Status retval = null;
        try {
            NewLiferayProjectProvider projectProvider = (NewLiferayProjectProvider)op.getProjectProvider().content();
            IStatus status = projectProvider.createNewProject(op, monitor);
            retval = StatusBridge.create((IStatus)status);
            if (retval.ok()) {
                NewLiferayJSFModuleProjectOpMethods.updateBuildPrefs(op);
            }
        }
        catch (Exception e) {
            String msg = "Error creating Liferay module project.";
            ProjectCore.logError("Error creating Liferay module project.", e);
            return Status.createErrorStatus((String)("Error creating Liferay module project. " + e.getMessage()), (Throwable)e);
        }
        return retval;
    }

    private static void updateBuildPrefs(NewLiferayJSFModuleProjectOp op) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.liferay.ide.project.core");
            prefs.put("project-jsf-module-default-build-type-option", op.getProjectProvider().text());
            prefs.flush();
        }
        catch (Exception e) {
            String msg = "Error updating default project build type.";
            ProjectCore.logError("Error updating default project build type.", e);
        }
    }
}

