/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.project.core.model.NewLiferayPluginProjectOp;
import com.liferay.ide.project.core.model.NewLiferayPluginProjectOpMethods;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.services.ValidationService;

public class PluginTypeValidationService
extends ValidationService {
    protected void initValidationService() {
        super.initValidationService();
        FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                PluginTypeValidationService.this.refresh();
            }
        };
        this.op().getProjectProvider().attach((Listener)listener);
    }

    protected Status compute() {
        Status retval = Status.createOkStatus();
        try {
            Path sdkLocation;
            SDK sdk = SDKUtil.getWorkspaceSDK();
            NewLiferayPluginProjectOp op = this.op();
            if (sdk == null && (sdkLocation = (Path)op.getSdkLocation().content()) != null) {
                sdk = SDKUtil.createSDKFromLocation((IPath)PathBridge.create((Path)sdkLocation));
            }
            if (sdk != null) {
                if (((PluginType)((Object)op.getPluginType().content())).equals((Object)PluginType.web) && !NewLiferayPluginProjectOpMethods.supportsTypePlugin(op, "web")) {
                    retval = Status.createErrorStatus((String)"The selected Plugins SDK does not support creating new web type plugins.  Please configure version 7.0 or greater.");
                } else if (((PluginType)((Object)op.getPluginType().content())).equals((Object)PluginType.theme) && !NewLiferayPluginProjectOpMethods.supportsTypePlugin(op, "theme")) {
                    retval = Status.createErrorStatus((String)"The selected Plugins SDK does not support creating theme type plugins.  Please configure version 6.2 or less or using gulp way.");
                } else if (((PluginType)((Object)op.getPluginType().content())).equals((Object)PluginType.ext) && !NewLiferayPluginProjectOpMethods.supportsTypePlugin(op, "ext")) {
                    retval = Status.createErrorStatus((String)"The selected Plugins SDK does not support creating ext type plugins. Please try to confirm whether sdk has ext folder.");
                }
            } else if (((PluginType)((Object)op.getPluginType().content())).equals((Object)PluginType.ext) && !NewLiferayPluginProjectOpMethods.supportsTypePlugin(op, "ext")) {
                retval = Status.createErrorStatus((String)"New ext plugins with maven build type are no longer supported.");
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return retval;
    }

    private NewLiferayPluginProjectOp op() {
        return (NewLiferayPluginProjectOp)this.context(NewLiferayPluginProjectOp.class);
    }
}

