/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.model.internal;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.model.ParentSDKProjectImportOp;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.services.ValidationService;

public class SDKImportValidationService
extends ValidationService {
    protected Status compute() {
        Status retval = Status.createOkStatus();
        try {
            SDK sdk = SDKUtil.getWorkspaceSDK();
            if (sdk != null) {
                retval = StatusBridge.create((IStatus)ProjectCore.createErrorStatus(" This workspace already has another sdk."));
            } else {
                Path currentProjectLocation = (Path)this.op().getSdkLocation().content(true);
                if (currentProjectLocation != null && !currentProjectLocation.isEmpty()) {
                    sdk = SDKUtil.createSDKFromLocation((IPath)PathBridge.create((Path)currentProjectLocation));
                    if (sdk != null) {
                        IStatus sdkStatus = sdk.validate(true);
                        if (!sdkStatus.isOK()) {
                            retval = StatusBridge.create((IStatus)ProjectCore.createWarningStatus(sdkStatus.getChildren()[0].getMessage()));
                        }
                    } else {
                        retval = StatusBridge.create((IStatus)ProjectCore.createErrorStatus("This parent sdk project path is invalid."));
                    }
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return retval;
    }

    private ParentSDKProjectImportOp op() {
        return (ParentSDKProjectImportOp)this.context(ParentSDKProjectImportOp.class);
    }
}

