/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import aQute.bnd.deployer.repository.FixedIndexedRepo;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Processor;
import aQute.service.reporter.Reporter;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.StringBufferOutputStream;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.BladeCLIException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.Version;
import org.osgi.service.prefs.Preferences;

public class BladeCLI {
    public static final String BLADE_CLI_REPO_URL = "BLADE_CLI_REPO_URL";
    private static final IEclipsePreferences defaultPrefs = DefaultScope.INSTANCE.getNode("com.liferay.ide.project.core");
    private static final IEclipsePreferences instancePrefs = InstanceScope.INSTANCE.getNode("com.liferay.ide.project.core");
    private static final File _settingsDir = LiferayCore.GLOBAL_SETTINGS_PATH.toFile();
    private static final File repoCache = new File(_settingsDir, "repoCache");
    private static final IPath bladeJarInstanceArea = ProjectCore.getDefault().getStateLocation().append("blade-jar");
    private static final IPath bladeJarInstancePath = bladeJarInstanceArea.append("com.liferay.blade.cli.jar");

    static {
        _settingsDir.mkdirs();
        repoCache.mkdirs();
        bladeJarInstanceArea.toFile().mkdirs();
    }

    public static String[] execute(String args) throws BladeCLIException {
        IPath bladeCLIPath = BladeCLI.getBladeCLIPath();
        if (bladeCLIPath == null || !bladeCLIPath.toFile().exists()) {
            throw new BladeCLIException("Could not get blade cli jar.");
        }
        Project project = new Project();
        Java javaTask = new Java();
        javaTask.setProject(project);
        javaTask.setFork(true);
        javaTask.setFailonerror(true);
        javaTask.setJar(bladeCLIPath.toFile());
        javaTask.setArgs(args);
        DefaultLogger logger = new DefaultLogger();
        project.addBuildListener((BuildListener)logger);
        StringBufferOutputStream out = new StringBufferOutputStream();
        logger.setOutputPrintStream(new PrintStream((OutputStream)out));
        logger.setMessageOutputLevel(2);
        int returnCode = javaTask.executeJava();
        ArrayList<String> lines = new ArrayList<String>();
        Scanner scanner = new Scanner(out.toString());
        while (scanner.hasNextLine()) {
            lines.add(scanner.nextLine().replaceAll(".*\\[null\\] ", ""));
        }
        scanner.close();
        boolean hasErrors = false;
        StringBuilder errors = new StringBuilder();
        for (String line : lines) {
            if (line.startsWith("Error")) {
                hasErrors = true;
                continue;
            }
            if (!hasErrors) continue;
            errors.append(line);
        }
        if (returnCode != 0 || hasErrors) {
            throw new BladeCLIException(errors.toString());
        }
        return lines.toArray(new String[0]);
    }

    public static synchronized IPath getBladeCLIPath() throws BladeCLIException {
        File bladeJarInstanceFile = bladeJarInstancePath.toFile();
        if (bladeJarInstanceFile.exists()) {
            try {
                Domain jar = Domain.domain((File)bladeJarInstanceFile);
                if (BladeCLI.isSupportedVersion(jar.getBundleVersion())) {
                    return bladeJarInstancePath;
                }
            }
            catch (IOException jar) {
                // empty catch block
            }
        }
        try {
            return BladeCLI.getBladeJarFromBundle();
        }
        catch (IOException e) {
            throw new BladeCLIException("Could not find blade cli jar", e);
        }
    }

    private static IPath getBladeJarFromBundle() throws IOException {
        File bladeJarBundleFile = new File(FileLocator.toFileURL((URL)ProjectCore.getDefault().getBundle().getEntry("lib/com.liferay.blade.cli.jar")).getFile());
        return new Path(bladeJarBundleFile.getCanonicalPath());
    }

    public static File fetchBladeJarFromRepo() throws Exception {
        Processor reporter = new Processor();
        FixedIndexedRepo repo = new FixedIndexedRepo();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", "index1");
        props.put("locations", String.valueOf(BladeCLI.getRepoURL()) + "index.xml.gz");
        props.put("cache", repoCache.getAbsolutePath());
        repo.setProperties(props);
        repo.setReporter((Reporter)reporter);
        File[] files = repo.get("com.liferay.blade.cli", "[2.0.2,3)");
        return files[0];
    }

    public static synchronized String[] getProjectTemplates() throws BladeCLIException {
        String[] executeResult;
        ArrayList<String> templateNames = new ArrayList<String>();
        String[] stringArray = executeResult = BladeCLI.execute("create -l");
        int n = executeResult.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name.trim().indexOf(" ") != -1) {
                templateNames.add(name.substring(0, name.indexOf(" ")));
            } else {
                templateNames.add(name);
            }
            ++n2;
        }
        return templateNames.toArray(new String[0]);
    }

    private static String getRepoURL() {
        String repoURL = Platform.getPreferencesService().get(BLADE_CLI_REPO_URL, null, new Preferences[]{instancePrefs, defaultPrefs});
        if (!repoURL.endsWith("/")) {
            repoURL = String.valueOf(repoURL) + "/";
        }
        return repoURL;
    }

    private static boolean isSupportedVersion(String verisonValue) {
        Version version = new Version(verisonValue);
        Version lowVersion = new Version("2");
        Version highVersion = new Version("3");
        return version.compareTo(lowVersion) >= 0 && version.compareTo(highVersion) < 0;
    }

    public static synchronized void addToLocalInstance(File latestBladeJar) {
        FileUtil.copyFile((File)latestBladeJar, (File)bladeJarInstancePath.toFile());
    }

    public static synchronized void restoreOriginal() {
        bladeJarInstancePath.toFile().delete();
    }
}

