/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules;

import com.liferay.ide.core.ILiferayProjectProvider;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.NewLiferayModuleProjectOp;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

public class ModuleProjectNameListener
extends FilteredListener<PropertyContentEvent> {
    private static String[] WAR_TYPE_PROJECT = new String[]{"layout-template", "spring-mvc-portlet", "theme"};

    protected void handleTypedEvent(PropertyContentEvent event) {
        ModuleProjectNameListener.updateLocation(this.op(event));
    }

    protected NewLiferayModuleProjectOp op(PropertyContentEvent event) {
        return (NewLiferayModuleProjectOp)event.property().element().nearest(NewLiferayModuleProjectOp.class);
    }

    public static void updateLocation(NewLiferayModuleProjectOp op) {
        String currentProjectName = (String)op.getProjectName().content(true);
        if (currentProjectName == null || CoreUtil.isNullOrEmpty((String)currentProjectName.trim())) {
            return;
        }
        boolean useDefaultLocation = (Boolean)op.getUseDefaultLocation().content(true);
        if (useDefaultLocation) {
            Path newLocationBase = null;
            boolean hasLiferayWorkspace = false;
            boolean hasGradleWorkspace = false;
            boolean hasMavenWorkspace = false;
            try {
                hasLiferayWorkspace = LiferayWorkspaceUtil.hasWorkspace();
                hasGradleWorkspace = LiferayWorkspaceUtil.hasGradleWorkspace();
                hasMavenWorkspace = LiferayWorkspaceUtil.hasMavenWorkspace();
            }
            catch (Exception e) {
                ProjectCore.logError("Failed to check LiferayWorkspace project.");
            }
            if (!hasLiferayWorkspace) {
                newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
            } else {
                boolean isGradleModule = false;
                boolean isMavenModule = false;
                ILiferayProjectProvider iProvider = (ILiferayProjectProvider)op.getProjectProvider().content();
                if (iProvider != null) {
                    String shortName = iProvider.getShortName();
                    if (!CoreUtil.empty((String)shortName) && shortName.startsWith("gradle")) {
                        isGradleModule = true;
                    } else {
                        isMavenModule = true;
                    }
                }
                boolean isThemeProject = false;
                if (op instanceof NewLiferayModuleProjectOp) {
                    NewLiferayModuleProjectOp moduleProjectOp = op;
                    String projectTemplateName = (String)moduleProjectOp.getProjectTemplateName().content();
                    String[] stringArray = WAR_TYPE_PROJECT;
                    int n = WAR_TYPE_PROJECT.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String projectType = stringArray[n2];
                        if (projectType.equals(projectTemplateName)) {
                            isThemeProject = true;
                        }
                        ++n2;
                    }
                }
                if (isGradleModule && hasGradleWorkspace || isMavenModule && hasMavenWorkspace) {
                    IProject liferayWorkspaceProject = LiferayWorkspaceUtil.getWorkspaceProject();
                    if (liferayWorkspaceProject != null && liferayWorkspaceProject.exists()) {
                        if (isThemeProject) {
                            String[] warsNames = LiferayWorkspaceUtil.getWarsDirs(liferayWorkspaceProject);
                            newLocationBase = PathBridge.create((IPath)liferayWorkspaceProject.getLocation().append(warsNames[0]));
                        } else {
                            String folder = LiferayWorkspaceUtil.getModulesDir(liferayWorkspaceProject);
                            if (folder != null) {
                                IPath appendPath = liferayWorkspaceProject.getLocation().append(folder);
                                newLocationBase = PathBridge.create((IPath)appendPath);
                            }
                        }
                    }
                } else {
                    newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
                }
            }
            if (newLocationBase != null) {
                op.setLocation(newLocationBase);
            }
        }
    }
}

