/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.fragment;

import com.liferay.ide.core.ILiferayProjectProvider;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.fragment.NewModuleFragmentOp;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.platform.PathBridge;

public class FragmentProjectNameListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        FragmentProjectNameListener.updateLocation(this.op(event));
    }

    protected NewModuleFragmentOp op(PropertyContentEvent event) {
        return (NewModuleFragmentOp)event.property().element().nearest(NewModuleFragmentOp.class);
    }

    public static void updateLocation(NewModuleFragmentOp op) {
        String currentProjectName = (String)op.getProjectName().content(true);
        if (currentProjectName == null || CoreUtil.isNullOrEmpty((String)currentProjectName.trim())) {
            return;
        }
        boolean useDefaultLocation = (Boolean)op.getUseDefaultLocation().content(true);
        if (useDefaultLocation) {
            Path newLocationBase = null;
            boolean hasLiferayWorkspace = false;
            boolean hasGradleWorkspace = false;
            boolean hasMavenWorkspace = false;
            try {
                hasLiferayWorkspace = LiferayWorkspaceUtil.hasWorkspace();
                hasGradleWorkspace = LiferayWorkspaceUtil.hasGradleWorkspace();
                hasMavenWorkspace = LiferayWorkspaceUtil.hasMavenWorkspace();
            }
            catch (Exception e) {
                ProjectCore.logError("Failed to check LiferayWorkspace project.");
            }
            if (!hasLiferayWorkspace) {
                newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
            } else {
                boolean isGradleModule = false;
                boolean isMavenModule = false;
                ILiferayProjectProvider iProvider = (ILiferayProjectProvider)op.getProjectProvider().content();
                if (iProvider != null) {
                    String shortName = iProvider.getShortName();
                    if (!CoreUtil.empty((String)shortName) && shortName.startsWith("gradle")) {
                        isGradleModule = true;
                    } else {
                        isMavenModule = true;
                    }
                }
                if (isGradleModule && hasGradleWorkspace || isMavenModule && hasMavenWorkspace) {
                    String folder;
                    IProject liferayWorkspaceProject = LiferayWorkspaceUtil.getWorkspaceProject();
                    if (liferayWorkspaceProject != null && liferayWorkspaceProject.exists() && (folder = LiferayWorkspaceUtil.getModulesDir(liferayWorkspaceProject)) != null) {
                        IPath appendPath = liferayWorkspaceProject.getLocation().append(folder);
                        newLocationBase = PathBridge.create((IPath)appendPath);
                    }
                } else {
                    newLocationBase = PathBridge.create((IPath)CoreUtil.getWorkspaceRoot().getLocation());
                }
            }
            if (newLocationBase != null) {
                op.setLocation(newLocationBase);
            }
        }
    }
}

