/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.fragment;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.core.util.ZipUtil;
import com.liferay.ide.project.core.NewLiferayProjectProvider;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.fragment.NewModuleFragmentOp;
import com.liferay.ide.project.core.modules.fragment.OverrideFilePath;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.ProgressMonitorBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.wst.server.core.IRuntime;

public class NewModuleFragmentOpMethods {
    public static final Status execute(NewModuleFragmentOp op, ProgressMonitor pm) {
        IProgressMonitor monitor = ProgressMonitorBridge.create((ProgressMonitor)pm);
        monitor.beginTask("Creating Liferay module fragment project (this process may take several minutes)", 100);
        Status retval = null;
        try {
            NewLiferayProjectProvider projectProvider = (NewLiferayProjectProvider)op.getProjectProvider().content(true);
            IStatus status = projectProvider.createNewProject(op, monitor);
            retval = StatusBridge.create((IStatus)status);
            if (retval.ok()) {
                NewModuleFragmentOpMethods.updateBuildPrefs(op);
            }
        }
        catch (Exception e) {
            String msg = "Error creating Liferay module fragment project.";
            ProjectCore.logError("Error creating Liferay module fragment project.", e);
            return Status.createErrorStatus((String)"Error creating Liferay module fragment project. Please see Eclipse error log for more details.", (Throwable)e);
        }
        return retval;
    }

    public static void copyOverrideFiles(NewModuleFragmentOp op) {
        String hostBundleName = (String)op.getHostOsgiBundle().content();
        IPath temp = ProjectCore.getDefault().getStateLocation().append(hostBundleName.substring(0, hostBundleName.lastIndexOf(".jar")));
        String projectName = (String)op.getProjectName().content();
        IPath location = PathBridge.create((Path)((Path)op.getLocation().content()));
        ElementList<OverrideFilePath> files = op.getOverrideFiles();
        for (OverrideFilePath file : files) {
            IPath resources;
            String metaInfResources;
            String parent;
            File fragmentFile = temp.append((String)file.getValue().content()).toFile();
            if (!fragmentFile.exists()) continue;
            File folder = null;
            if (fragmentFile.getName().equals("portlet.properties")) {
                folder = location.append(projectName).append("src/main/java").toFile();
                FileUtil.copyFileToDir((File)fragmentFile, (String)"portlet-ext.properties", (File)folder);
                continue;
            }
            if (fragmentFile.getName().contains("default.xml")) {
                parent = fragmentFile.getParentFile().getPath();
                parent = parent.replaceAll("\\\\", "/");
                metaInfResources = "resource-actions";
                parent = parent.substring(parent.indexOf(metaInfResources) + metaInfResources.length());
                resources = location.append(projectName).append("src/main/resources/resource-actions");
                folder = resources.toFile();
                folder.mkdirs();
                if (!parent.equals("resource-actions") && !parent.equals("")) {
                    folder = resources.append(parent).toFile();
                    folder.mkdirs();
                }
                FileUtil.copyFileToDir((File)fragmentFile, (String)"default-ext.xml", (File)folder);
                try {
                    File ext = new File(location.append(projectName).append("src/main/resources") + "/portlet-ext.properties");
                    ext.createNewFile();
                    String extFileContent = "resource.actions.configs=resource-actions/default.xml,resource-actions/default-ext.xml";
                    FileUtil.writeFile((File)ext, (String)extFileContent, null);
                }
                catch (Exception exception) {}
                continue;
            }
            parent = fragmentFile.getParentFile().getPath();
            parent = parent.replaceAll("\\\\", "/");
            metaInfResources = "META-INF/resources";
            parent = parent.substring(parent.indexOf(metaInfResources) + metaInfResources.length());
            resources = location.append(projectName).append("src/main/resources/META-INF/resources");
            folder = resources.toFile();
            folder.mkdirs();
            if (!parent.equals("resources") && !parent.equals("")) {
                folder = resources.append(parent).toFile();
                folder.mkdirs();
            }
            FileUtil.copyFileToDir((File)fragmentFile, (File)folder);
        }
    }

    public static String[] getBsnAndVersion(NewModuleFragmentOp op) throws CoreException {
        String hostBundleName = (String)op.getHostOsgiBundle().content();
        IPath temp = ProjectCore.getDefault().getStateLocation().append(hostBundleName.substring(0, hostBundleName.lastIndexOf(".jar")));
        if (!temp.toFile().exists()) {
            IRuntime runtime = ServerUtil.getRuntime((String)((String)op.getLiferayRuntimeName().content()));
            PortalBundle portalBundle = LiferayServerCore.newPortalBundle((IPath)runtime.getLocation());
            File hostBundle = portalBundle.getOSGiBundlesDir().append("modules").append(hostBundleName).toFile();
            if (!hostBundle.exists()) {
                hostBundle = ProjectCore.getDefault().getStateLocation().append(hostBundleName).toFile();
            }
            try {
                ZipUtil.unzip((File)hostBundle, (File)temp.toFile());
            }
            catch (IOException e) {
                throw new CoreException(ProjectCore.createErrorStatus(e));
            }
        }
        String bundleSymbolicName = "";
        String version = "";
        if (temp.toFile().exists()) {
            String[] contents;
            File file = temp.append("META-INF/MANIFEST.MF").toFile();
            String[] stringArray = contents = FileUtil.readLinesFromFile((File)file);
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                String content = stringArray[n2];
                if (content.contains("Bundle-SymbolicName:")) {
                    bundleSymbolicName = content.substring(content.indexOf("Bundle-SymbolicName:") + "Bundle-SymbolicName:".length());
                }
                if (content.contains("Bundle-Version:")) {
                    version = content.substring(content.indexOf("Bundle-Version:") + "Bundle-Version:".length()).trim();
                }
                ++n2;
            }
        }
        return new String[]{bundleSymbolicName, version};
    }

    public static String getMavenParentPomGroupId(NewModuleFragmentOp op, String projectName, IPath path) {
        List groupId;
        String retval = null;
        File parentProjectDir = path.toFile();
        IStatus locationStatus = ((NewLiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(projectName, path);
        if (locationStatus.isOK() && parentProjectDir.exists() && parentProjectDir.list().length > 0 && !CoreUtil.isNullOrEmpty((List)(groupId = ((NewLiferayProjectProvider)op.getProjectProvider().content()).getData("parentGroupId", String.class, new Object[]{parentProjectDir})))) {
            retval = (String)groupId.get(0);
        }
        return retval;
    }

    public static String getMavenParentPomVersion(NewModuleFragmentOp op, String projectName, IPath path) {
        List version;
        String retval = null;
        File parentProjectDir = path.toFile();
        IStatus locationStatus = ((NewLiferayProjectProvider)op.getProjectProvider().content()).validateProjectLocation(projectName, path);
        if (locationStatus.isOK() && parentProjectDir.exists() && parentProjectDir.list().length > 0 && !CoreUtil.isNullOrEmpty((List)(version = ((NewLiferayProjectProvider)op.getProjectProvider().content()).getData("parentVersion", String.class, new Object[]{parentProjectDir})))) {
            retval = (String)version.get(0);
        }
        return retval;
    }

    private static void updateBuildPrefs(NewModuleFragmentOp op) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.liferay.ide.project.core");
            prefs.put("project-module-fragment-default-build-type-option", op.getProjectProvider().text());
            prefs.flush();
        }
        catch (Exception e) {
            String msg = "Error updating default project build type.";
            ProjectCore.logError("Error updating default project build type.", e);
        }
    }
}

