/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.fragment;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.fragment.NewModuleFragmentOp;
import com.liferay.ide.project.core.modules.fragment.OverrideFilePath;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.wst.server.core.IRuntime;

public class OverrideFilePathPossibleValuesService
extends PossibleValuesService {
    private static Set<String> possibleValues;
    private String osgiBundleName;

    protected void compute(Set<String> values) {
        NewModuleFragmentOp op = this.op();
        String hostOSGiBundle = (String)op.getHostOsgiBundle().content();
        if (hostOSGiBundle == null) {
            return;
        }
        if (this.osgiBundleName == null || !this.osgiBundleName.equals(hostOSGiBundle) || possibleValues == null) {
            this.osgiBundleName = hostOSGiBundle;
            possibleValues = new HashSet<String>();
            String runtimeName = (String)op.getLiferayRuntimeName().content();
            IRuntime runtime = ServerUtil.getRuntime((String)runtimeName);
            PortalBundle portalBundle = LiferayServerCore.newPortalBundle((IPath)runtime.getLocation());
            if (portalBundle != null) {
                Object temp2;
                Object module;
                if (!hostOSGiBundle.endsWith("jar")) {
                    hostOSGiBundle = String.valueOf(hostOSGiBundle) + ".jar";
                }
                if (!((File)(module = portalBundle.getOSGiBundlesDir().append("modules").append(hostOSGiBundle).toFile())).exists()) {
                    temp2 = ProjectCore.getDefault().getStateLocation();
                    module = new File(temp2.toFile(), hostOSGiBundle);
                }
                if (((File)module).exists()) {
                    try {
                        temp2 = null;
                        Object var9_11 = null;
                        try (JarFile jar = new JarFile((File)module);){
                            Enumeration<JarEntry> enu = jar.entries();
                            while (enu.hasMoreElements()) {
                                JarEntry entry = enu.nextElement();
                                String name = entry.getName();
                                if ((!name.startsWith("META-INF/resources/") || !name.endsWith(".jsp") && !name.endsWith(".jspf")) && !name.equals("portlet.properties") && !name.equals("resource-actions/default.xml")) continue;
                                possibleValues.add(name);
                            }
                        }
                        catch (Throwable throwable) {
                            if (temp2 == null) {
                                temp2 = throwable;
                            } else if (temp2 != throwable) {
                                ((Throwable)temp2).addSuppressed(throwable);
                            }
                            throw temp2;
                        }
                    }
                    catch (Exception temp2) {
                        // empty catch block
                    }
                }
            }
        }
        if (possibleValues != null) {
            String projectName;
            HashSet<String> possibleValuesSet = new HashSet<String>();
            possibleValuesSet.addAll(possibleValues);
            ElementList<OverrideFilePath> currentFiles = op.getOverrideFiles();
            if (currentFiles != null) {
                for (OverrideFilePath cj : currentFiles) {
                    String value = (String)cj.getValue().content();
                    if (value == null) continue;
                    possibleValuesSet.remove(value);
                }
            }
            if ((projectName = (String)this.op().getProjectName().content()) != null) {
                IProject project = CoreUtil.getProject((String)projectName);
                IFolder javaFolder = project.getFolder("src/main/java");
                IFolder resourceFolder = project.getFolder("src/main/resources");
                Iterator it = possibleValuesSet.iterator();
                while (it.hasNext()) {
                    String v = (String)it.next();
                    if (resourceFolder.getFile(v).exists()) {
                        it.remove();
                    }
                    if (!javaFolder.getFile("portlet-ext.properties").exists() || !v.equals("portlet.properties")) continue;
                    it.remove();
                }
            }
            values.addAll(possibleValuesSet);
        }
    }

    public Status problem(Value<?> value) {
        ElementList<OverrideFilePath> currentFiles = this.op().getOverrideFiles();
        int count = 0;
        for (OverrideFilePath currentFile : currentFiles) {
            String content = (String)currentFile.getValue().content();
            if (content == null || !value.content().toString().equals(content)) continue;
            ++count;
        }
        if (count >= 0 && (possibleValues.contains(value.content().toString()) || possibleValues.contains("resource-actions/default.xml"))) {
            return Status.createOkStatus();
        }
        return super.problem(value);
    }

    private NewModuleFragmentOp op() {
        return (NewModuleFragmentOp)this.context(NewModuleFragmentOp.class);
    }
}

