/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.templates;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.modules.templates.BndPropertiesValue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;

public class BndProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private Charset UTF8 = Charset.forName("UTF-8");
    private final int PAGE_SIZE = 4096;
    private List<String> keyList = new ArrayList<String>();

    public void addKeyList(String key) {
        if (this.keyList.contains(key)) {
            return;
        }
        this.keyList.add(key);
    }

    public void addValue(String key, BndPropertiesValue newBdValue) {
        BndPropertiesValue bdValue = (BndPropertiesValue)this.get(key);
        this.addKeyList(key);
        if (bdValue != null) {
            String originalValue = bdValue.getOriginalValue();
            if (originalValue != null && !CoreUtil.isNullOrEmpty((String)originalValue)) {
                StringBuilder formatedValueBuilder = new StringBuilder(bdValue.getFormatedValue());
                StringBuilder originalValueBuilder = new StringBuilder(bdValue.getOriginalValue());
                String newOriginalValue = newBdValue.getOriginalValue();
                String[] newOriginalValues = newOriginalValue.split(",");
                BndPropertiesValue inputValue = new BndPropertiesValue();
                String[] stringArray = newOriginalValues;
                int n = newOriginalValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String newValue = stringArray[n2];
                    if (!originalValue.contains(newValue)) {
                        if (bdValue.isMultiLine()) {
                            formatedValueBuilder.append(",\\" + System.getProperty("line.separator"));
                            formatedValueBuilder.append("\t" + newValue);
                            inputValue.setFormatedValue(formatedValueBuilder.toString());
                        } else {
                            originalValueBuilder.append(",").append(newValue);
                            inputValue.setFormatedValue(originalValueBuilder.toString());
                        }
                    }
                    ++n2;
                }
                this.put(key, inputValue);
            } else {
                this.put(key, newBdValue);
            }
        } else {
            this.put(key, newBdValue);
        }
    }

    private String convert(byte[] buffer, Charset charset) throws IOException {
        CharBuffer cb;
        ByteBuffer bb;
        CharsetDecoder decoder = charset.newDecoder();
        CoderResult result = decoder.decode(bb = ByteBuffer.wrap(buffer), cb = CharBuffer.allocate(buffer.length * 4), true);
        if (!result.isError()) {
            return new String(cb.array(), 0, cb.position());
        }
        throw new CharacterCodingException();
    }

    public String getReader(Reader a) throws IOException {
        StringWriter sw = new StringWriter();
        char[] buffer = new char[4096];
        int size = a.read(buffer);
        while (size > 0) {
            sw.write(buffer, 0, size);
            size = a.read(buffer);
        }
        return sw.toString();
    }

    private void formatForOutput(String str, StringBuilder buffer, boolean key) {
        if (key) {
            buffer.setLength(0);
            buffer.ensureCapacity(str.length());
        } else {
            buffer.ensureCapacity(buffer.length() + str.length());
        }
        boolean head = true;
        int size = str.length();
        int i = 0;
        while (i < size) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case ' ': {
                    buffer.append(head ? "\\ " : " ");
                    break;
                }
                case '!': 
                case '#': {
                    buffer.append('\\').append(c);
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String hex = Integer.toHexString(c);
                        buffer.append("\\u0000".substring(0, 6 - hex.length()));
                        buffer.append(hex);
                        break;
                    }
                    buffer.append(c);
                }
            }
            if (c != ' ') {
                head = key;
            }
            ++i;
        }
    }

    @Override
    public void store(OutputStream out, String header) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
        if (header != null) {
            writer.println("#" + header);
            writer.println("#" + Calendar.getInstance().getTime());
        }
        StringBuilder s = new StringBuilder();
        for (String keyString : this.keyList) {
            this.formatForOutput(keyString, s, true);
            s.append(": ");
            Object value = this.get(keyString);
            if (value instanceof BndPropertiesValue) {
                BndPropertiesValue bndValue = (BndPropertiesValue)value;
                writer.println(s.append(bndValue.getFormatedValue()));
                continue;
            }
            this.formatForOutput((String)value, s, false);
            writer.println(s);
        }
        writer.flush();
    }

    public void load(File bndFile) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream in = new FileInputStream(bndFile);){
                this.load(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        String buffer;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "ISO-8859-1"));
        while ((buffer = reader.readLine()) != null) {
            boolean isDelim;
            String line = this.convert(buffer.getBytes(), this.UTF8);
            BndPropertiesValue bnd = new BndPropertiesValue();
            char c = '\u0000';
            int pos = 0;
            while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
            if (line.length() - pos == 0 || line.charAt(pos) == '#' || line.charAt(pos) == '!') continue;
            int start = pos;
            boolean needsEscape = line.indexOf(92, pos) != -1;
            StringBuilder key = needsEscape ? new StringBuilder() : null;
            block14: while (pos < line.length() && !Character.isWhitespace(c = line.charAt(pos++)) && c != '=' && c != ':') {
                if (needsEscape && c == '\\') {
                    if (pos == line.length()) {
                        line = reader.readLine();
                        if (line == null) {
                            line = "";
                        }
                        pos = 0;
                        while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                            ++pos;
                        }
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            key.append('\n');
                            break;
                        }
                        case 't': {
                            key.append('\t');
                            break;
                        }
                        case 'r': {
                            key.append('\r');
                            break;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block14;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            key.append(uni);
                            pos += 4;
                            break;
                        }
                        default: {
                            key.append(c);
                            break;
                        }
                    }
                    continue;
                }
                if (!needsEscape) continue;
                key.append(c);
            }
            boolean bl = isDelim = c == ':' || c == '=';
            String keyString = needsEscape ? key.toString() : (isDelim || Character.isWhitespace(c) ? line.substring(start, pos - 1) : line.substring(start, pos));
            while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                ++pos;
            }
            if (!(isDelim || c != ':' && c != '=')) {
                ++pos;
                while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                    ++pos;
                }
            }
            if (!needsEscape) {
                bnd.setOriginalValue(line.substring(pos));
                bnd.setFormatedValue(line.substring(pos));
                this.addKeyList(keyString);
                this.put(keyString, bnd);
                continue;
            }
            StringBuilder element = new StringBuilder(line.length() - pos);
            StringBuilder formatedElement = new StringBuilder(line.substring(pos));
            block18: while (pos < line.length()) {
                if ((c = line.charAt(pos++)) == '\\') {
                    if (pos == line.length()) {
                        bnd.setMultiLine(true);
                        formatedElement.append(System.getProperty("line.separator"));
                        line = reader.readLine();
                        formatedElement.append(line);
                        if (line == null) break;
                        pos = 0;
                        while (pos < line.length() && Character.isWhitespace(c = line.charAt(pos))) {
                            ++pos;
                        }
                        element.ensureCapacity(line.length() - pos + element.length());
                        continue;
                    }
                    c = line.charAt(pos++);
                    switch (c) {
                        case 'n': {
                            element.append('\n');
                            formatedElement.append('\n');
                            break;
                        }
                        case 't': {
                            element.append('\t');
                            formatedElement.append('\t');
                            break;
                        }
                        case 'r': {
                            element.append('\r');
                            formatedElement.append('\r');
                            break;
                        }
                        case 'u': {
                            if (pos + 4 > line.length()) continue block18;
                            char uni = (char)Integer.parseInt(line.substring(pos, pos + 4), 16);
                            element.append(uni);
                            pos += 4;
                            break;
                        }
                        default: {
                            element.append(c);
                            break;
                        }
                    }
                    continue;
                }
                element.append(c);
            }
            bnd.setOriginalValue(element.toString());
            bnd.setFormatedValue(formatedElement.toString());
            this.addKeyList(keyString);
            this.put(keyString, bnd);
        }
    }
}

