/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.modules.templates.portletfilter;

import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.NewLiferayComponentOp;
import com.liferay.ide.project.core.modules.templates.AbstractLiferayComponentTemplate;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class NewLiferayComponentPortletFilterOperation
extends AbstractLiferayComponentTemplate {
    private static final String PORTLET_FILTER_TEMPLATE_FILE = "portletfilter/portletfilter.ftl";
    private static final String PORTLET_SUPER_CLASSES = "GenericPortlet";
    private static final String PORTLET_FILTER_SUPER_CLASSES = "RenderFilter";
    private static final String PORTLET_EXTENSION_CLASSES = "Portlet.class";
    private static final String PORTLET_FILTER_EXTENSION_CLASSES = "PortletFilter.class";
    private static final String[] PORTLET_PROPERTIES_LIST = new String[]{"com.liferay.portlet.display-category=category.sample", "com.liferay.portlet.instanceable=true", "javax.portlet.security-role-ref=power-user,user"};

    private List<String> getPortletImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("java.io.IOException");
        imports.add("java.io.PrintWriter");
        imports.add("javax.portlet.GenericPortlet");
        imports.add("javax.portlet.Portlet");
        imports.add("javax.portlet.PortletException");
        imports.add("javax.portlet.RenderRequest");
        imports.add("javax.portlet.RenderResponse");
        imports.addAll(super.getImports());
        return imports;
    }

    private List<String> getPortletFilterImports() {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add("java.io.IOException");
        imports.add("javax.portlet.filter.FilterChain");
        imports.add("javax.portlet.filter.FilterConfig");
        imports.add("javax.portlet.filter.PortletFilter");
        imports.add("javax.portlet.filter.RenderFilter");
        imports.add("javax.portlet.RenderRequest");
        imports.add("javax.portlet.RenderResponse");
        imports.add("javax.portlet.PortletException");
        imports.addAll(super.getImports());
        return imports;
    }

    private List<String> getPortletProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.addAll(Arrays.asList(PORTLET_PROPERTIES_LIST));
        for (String property : super.getProperties()) {
            properties.add(property);
        }
        properties.add("javax.portlet.display-name=" + this.componentNameWithoutTemplateName + " Filter Portlet");
        properties.add("javax.portlet.name=blade_portlet_filter_" + this.componentNameWithoutTemplateName + "Portlet");
        return properties;
    }

    private List<String> getPortletFilterProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        for (String property : super.getProperties()) {
            properties.add(property);
        }
        properties.add("javax.portlet.name=blade_portlet_filter_" + this.componentNameWithoutTemplateName + "Portlet");
        return properties;
    }

    private String getPortletExtensionClass() {
        return PORTLET_EXTENSION_CLASSES;
    }

    private String getPortletFilterExtensionClass() {
        return PORTLET_FILTER_EXTENSION_CLASSES;
    }

    private String getPortletSuperClass() {
        return PORTLET_SUPER_CLASSES;
    }

    private String getPortletFilterSuperClass() {
        return PORTLET_FILTER_SUPER_CLASSES;
    }

    @Override
    public void doExecute(NewLiferayComponentOp op, IProgressMonitor monitor) throws CoreException {
        try {
            this.initializeOperation(op);
            this.project = CoreUtil.getProject((String)this.projectName);
            if (this.project != null) {
                this.liferayProject = LiferayCore.create((Object)this.project);
                if (this.liferayProject != null) {
                    this.initFreeMarker();
                    IFile pollerClassFile = this.prepareClassFile(String.valueOf(this.componentNameWithoutTemplateName) + "Portlet");
                    this.doSourceCodeOperation(pollerClassFile, "portlet");
                    IFile pollerPortletClassFile = this.prepareClassFile(String.valueOf(this.componentNameWithoutTemplateName) + PORTLET_FILTER_SUPER_CLASSES);
                    this.doSourceCodeOperation(pollerPortletClassFile, "renderFilter");
                    op.setComponentClassName(String.valueOf(this.componentNameWithoutTemplateName) + PORTLET_FILTER_SUPER_CLASSES);
                    this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (Exception e) {
            throw new CoreException(ProjectCore.createErrorStatus(e));
        }
    }

    private Map<String, Object> getTemplateMap(String type) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        if (type.equals("portlet")) {
            root.put("importlibs", this.getPortletImports());
            root.put("properties", this.getPortletProperties());
            root.put("classname", String.valueOf(this.componentNameWithoutTemplateName) + "Portlet");
            root.put("supperclass", this.getPortletSuperClass());
            root.put("extensionclass", this.getPortletExtensionClass());
        } else {
            root.put("importlibs", this.getPortletFilterImports());
            root.put("properties", this.getPortletFilterProperties());
            root.put("classname", String.valueOf(this.componentNameWithoutTemplateName) + PORTLET_FILTER_SUPER_CLASSES);
            root.put("supperclass", this.getPortletFilterSuperClass());
            root.put("extensionclass", this.getPortletFilterExtensionClass());
        }
        root.put("packagename", this.packageName);
        root.put("projectname", this.projectName);
        root.put("componenttype", this.templateName);
        return root;
    }

    @Override
    protected String getTemplateFile() {
        return PORTLET_FILTER_TEMPLATE_FILE;
    }

    private void doSourceCodeOperation(IFile srcFile, String type) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileOutputStream fos = new FileOutputStream(srcFile.getLocation().toFile());){
                Template temp = this.cfg.getTemplate(this.getTemplateFile());
                Map<String, Object> root = this.getTemplateMap(type);
                OutputStreamWriter out = new OutputStreamWriter(fos);
                temp.process(root, (Writer)out);
                fos.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (TemplateException | IOException e) {
            throw new CoreException(ProjectCore.createErrorStatus((Exception)e));
        }
    }

    @Override
    protected List<String[]> getComponentDependency() throws CoreException {
        List<String[]> componentDependency = super.getComponentDependency();
        componentDependency.add(new String[]{"javax.portlet", "portlet-api", "2.0"});
        return componentDependency;
    }
}

