/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.core.util.PropertiesUtil;
import com.liferay.ide.project.core.ProjectCore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LiferayWorkspaceUtil {
    private static final String _GRADLE_PROPERTIES_FILE_NAME = "gradle.properties";
    private static final String _SETTINGS_GRADLE_FILE_NAME = "settings.gradle";
    private static final String _BUILD_GRADLE_FILE_NAME = "build.gradle";
    public static String multiWorkspaceErrorMsg = "More than one Liferay workspace build in current Eclipse workspace.";
    public static String hasLiferayWorkspaceMsg = "A Liferay Workspace project already exists in this Eclipse instance.";
    private static final Pattern PATTERN_WORKSPACE_PLUGIN = Pattern.compile(".*apply.*plugin.*:.*['\"]com\\.liferay\\.workspace['\"].*", 40);

    public static void clearWorkspace(String location) {
        File settings;
        File classpathFile;
        File projectFile = new File(location, ".project");
        if (projectFile.exists()) {
            projectFile.delete();
        }
        if ((classpathFile = new File(location, ".classpath")).exists()) {
            classpathFile.delete();
        }
        if ((settings = new File(location, ".settings")).exists() && settings.isDirectory()) {
            FileUtil.deleteDir((File)settings, (boolean)true);
        }
    }

    private static boolean isValidGradleWorkspace(IProject project) {
        return project != null && project.getLocation() != null && LiferayWorkspaceUtil.isValidGradleWorkspaceLocation(project.getLocation().toOSString());
    }

    private static boolean isValidMavenWorkspace(IProject project) {
        return project != null && project.getLocation() != null && LiferayWorkspaceUtil.isValidMavenWorkspaceLocation(project.getLocation().toOSString());
    }

    public static boolean isValidGradleWorkspaceLocation(String location) {
        File workspaceDir = new File(location);
        File buildGradle = new File(workspaceDir, _BUILD_GRADLE_FILE_NAME);
        File settingsGradle = new File(workspaceDir, _SETTINGS_GRADLE_FILE_NAME);
        File gradleProperties = new File(workspaceDir, _GRADLE_PROPERTIES_FILE_NAME);
        if (!(buildGradle.exists() && settingsGradle.exists() && gradleProperties.exists())) {
            return false;
        }
        String settingsContent = FileUtil.readContents((File)settingsGradle, (boolean)true);
        return settingsContent != null && PATTERN_WORKSPACE_PLUGIN.matcher(settingsContent).matches();
    }

    public static boolean isValidMavenWorkspaceLocation(String location) {
        String content;
        File workspaceDir = new File(location);
        File pomFile = new File(workspaceDir, "pom.xml");
        return pomFile.exists() && (content = FileUtil.readContents((File)pomFile)).contains("com.liferay.portal.tools.bundle.support");
    }

    public static boolean isValidWorkspaceLocation(String location) {
        return LiferayWorkspaceUtil.isValidMavenWorkspaceLocation(location) || LiferayWorkspaceUtil.isValidGradleWorkspaceLocation(location);
    }

    public static boolean isValidWorkspace(IProject project) {
        return project != null && project.getLocation() != null && LiferayWorkspaceUtil.isValidWorkspaceLocation(project.getLocation().toOSString());
    }

    public static boolean hasBundlesDir(String location) {
        File bundles = new File(location, LiferayWorkspaceUtil.getHomeDir(location));
        File outsideOfWorkspaceBundles = new File(LiferayWorkspaceUtil.getHomeDir(location));
        return bundles.exists() && bundles.isDirectory() || outsideOfWorkspaceBundles.exists() && outsideOfWorkspaceBundles.isDirectory();
    }

    public static boolean hasGradleWorkspace() throws CoreException {
        IProject[] projects = CoreUtil.getAllProjects();
        int count = 0;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (LiferayWorkspaceUtil.isValidGradleWorkspace(project)) {
                ++count;
            }
            ++n2;
        }
        if (count == 1) {
            return true;
        }
        if (count > 1) {
            throw new CoreException(ProjectCore.createErrorStatus(multiWorkspaceErrorMsg));
        }
        return false;
    }

    public static boolean hasMavenWorkspace() throws CoreException {
        IProject[] projects = CoreUtil.getAllProjects();
        int count = 0;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (LiferayWorkspaceUtil.isValidMavenWorkspace(project)) {
                ++count;
            }
            ++n2;
        }
        if (count == 1) {
            return true;
        }
        if (count > 1) {
            throw new CoreException(ProjectCore.createErrorStatus(multiWorkspaceErrorMsg));
        }
        return false;
    }

    public static boolean hasWorkspace() throws CoreException {
        IProject[] projects = CoreUtil.getAllProjects();
        int count = 0;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (LiferayWorkspaceUtil.isValidWorkspace(project)) {
                ++count;
            }
            ++n2;
        }
        if (count == 1) {
            return true;
        }
        if (count > 1) {
            throw new CoreException(ProjectCore.createErrorStatus(multiWorkspaceErrorMsg));
        }
        return false;
    }

    private static String getGradleProperty(String projectLocation, String key, String defaultValue) {
        File gradleProperties = new File(projectLocation, _GRADLE_PROPERTIES_FILE_NAME);
        String retVal = null;
        if (gradleProperties.exists()) {
            Properties properties = PropertiesUtil.loadProperties((File)gradleProperties);
            retVal = properties.getProperty(key, defaultValue);
        }
        return retVal;
    }

    public static IProject getWorkspaceProject() {
        IProject[] projects;
        IProject[] iProjectArray = projects = CoreUtil.getAllProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (LiferayWorkspaceUtil.isValidWorkspace(project)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public static String getModulesDir(IProject project) {
        return LiferayWorkspaceUtil.getModulesDirArray(project)[0];
    }

    public static String[] getModulesDirArray(IProject project) {
        IPath projectLocation;
        String[] retval = null;
        if (project != null && (projectLocation = project.getLocation()) != null) {
            String val = LiferayWorkspaceUtil.getGradleProperty(projectLocation.toPortableString(), "liferay.workspace.modules.dir", "modules");
            val = CoreUtil.empty((String)val) ? "modules" : val;
            retval = val.split(",");
        }
        return retval;
    }

    public static String getThemesDir(IProject project) {
        IPath projectLocation;
        String retval = null;
        if (project != null && (projectLocation = project.getLocation()) != null) {
            retval = LiferayWorkspaceUtil.getGradleProperty(projectLocation.toPortableString(), "liferay.workspace.themes.dir", "themes");
        }
        return CoreUtil.empty(retval) ? "themes" : retval;
    }

    public static String[] getWarsDirs(IProject project) {
        IPath projectLocation;
        String[] retval = null;
        if (project != null && (projectLocation = project.getLocation()) != null) {
            String val = LiferayWorkspaceUtil.getGradleProperty(projectLocation.toPortableString(), "liferay.workspace.wars.dir", "wars");
            val = CoreUtil.empty((String)val) ? "wars" : val;
            retval = val.split(",");
        }
        return retval;
    }

    public static String getWorkspaceType(String location) {
        if (LiferayWorkspaceUtil.isValidWorkspaceLocation(location)) {
            File pomFile = new File(location, "pom.xml");
            if (pomFile.exists()) {
                return "maven-liferay-workspace";
            }
            return "gradle-liferay-workspace";
        }
        return null;
    }

    public static String getHomeDir(String location) {
        String result = LiferayWorkspaceUtil.getGradleProperty(location, "liferay.workspace.home.dir", "bundles");
        return CoreUtil.empty((String)result) ? "bundles" : result;
    }

    public static IPath getHomeLocation(String location) {
        String homeNameOrPath = LiferayWorkspaceUtil.getHomeDir(location);
        IPath homePath = new Path(location).append(homeNameOrPath);
        if (homePath.toFile().exists()) {
            return homePath;
        }
        homePath = new Path(homeNameOrPath);
        if (homePath.toFile().exists()) {
            return homePath;
        }
        return null;
    }

    public static String getPluginsSDKDir(String location) {
        String result = LiferayWorkspaceUtil.getGradleProperty(location, "liferay.workspace.plugins.sdk.dir", "plugins-sdk");
        return CoreUtil.empty((String)result) ? "bundles" : result;
    }

    public static IPath getHomeLocation(IProject project) {
        return LiferayWorkspaceUtil.getHomeLocation(project.getLocation().toOSString());
    }

    public static File getWorkspaceDir(File dir) {
        return LiferayWorkspaceUtil.findParentFile(dir, new String[]{_SETTINGS_GRADLE_FILE_NAME, _GRADLE_PROPERTIES_FILE_NAME}, true);
    }

    public static String loadConfiguredHomeDir(String location) {
        return LiferayWorkspaceUtil.getLiferayWorkspaceGradleProperty(location, "liferay.workspace.home.dir", "bundles");
    }

    public static String read(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()));
    }

    public static File findParentFile(File dir, String[] fileNames, boolean checkParents) {
        if (dir == null) {
            return null;
        }
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File file = new File(dir, fileName);
            if (file.exists()) {
                return dir;
            }
            ++n2;
        }
        if (checkParents) {
            return LiferayWorkspaceUtil.findParentFile(dir.getParentFile(), fileNames, checkParents);
        }
        return null;
    }

    public static String[] getLiferayWorkspaceProjectWarsDirs(String workspaceLocation) {
        String[] retval = null;
        if (workspaceLocation != null) {
            String val = LiferayWorkspaceUtil.getLiferayWorkspaceGradleProperty(workspaceLocation, "liferay.workspace.wars.dir", "wars");
            retval = val.split(",");
        }
        return retval;
    }

    public static String getLiferayWorkspaceGradleProperty(String projectLocation, String key, String defaultValue) {
        File gradleProperties = new File(projectLocation, _GRADLE_PROPERTIES_FILE_NAME);
        String retVal = null;
        if (gradleProperties.exists()) {
            Properties properties = PropertiesUtil.loadProperties((File)gradleProperties);
            retVal = properties.getProperty(key, defaultValue);
        }
        return retVal;
    }
}

