/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.core.util;

import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.ServiceContainer;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;

public class TargetPlatformUtil {
    public static ServiceContainer getServicesList() throws Exception {
        File tpIndexFile = TargetPlatformUtil.checkCurrentTargetPlatform("service");
        return TargetPlatformUtil.getServicesNameList(tpIndexFile);
    }

    public static ServiceContainer getServiceBundle(String serviceName) throws Exception {
        File tpIndexFile = TargetPlatformUtil.checkCurrentTargetPlatform("service");
        return TargetPlatformUtil.getBundleAndVersion(tpIndexFile, serviceName);
    }

    public static ServiceContainer getServiceWrapperList() throws Exception {
        File tpIndexFile = TargetPlatformUtil.checkCurrentTargetPlatform("servicewrapper");
        return TargetPlatformUtil.getServicesNameList(tpIndexFile);
    }

    public static ServiceContainer getServiceWrapperBundle(String servicewrapperName) throws Exception {
        File tpIndexFile = TargetPlatformUtil.checkCurrentTargetPlatform("servicewrapper");
        return TargetPlatformUtil.getBundleAndVersion(tpIndexFile, servicewrapperName);
    }

    private static File checkCurrentTargetPlatform(String type) throws IOException {
        String currentVersion = Platform.getPreferencesService().getString("com.liferay.ide.project.core", "current_targetplatform_version", "CE-7.0.0-GA2", null);
        currentVersion = currentVersion.replace("[", "").replace("]", "").toLowerCase();
        return TargetPlatformUtil.useSpecificTargetPlatform(currentVersion, type);
    }

    private static File useSpecificTargetPlatform(String currentVersion, final String type) throws IOException {
        URL url = FileLocator.toFileURL((URL)ProjectCore.getDefault().getBundle().getEntry("OSGI-INF/target-platform/liferay-" + currentVersion));
        File tpFolder = new File(url.getFile());
        File[] listFiles = tpFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (type.equals("service") && name.endsWith("services.json")) {
                    return true;
                }
                return type.equals("servicewrapper") && name.endsWith("servicewrappers.json");
            }
        });
        return listFiles[0];
    }

    public static List<String> getAllTargetPlatfromVersions() throws IOException {
        File[] tpVersionFolder;
        URL url = FileLocator.toFileURL((URL)ProjectCore.getDefault().getBundle().getEntry("OSGI-INF/target-platform"));
        File targetPlatfolder = new File(url.getFile());
        ArrayList<String> tpVersionList = new ArrayList<String>();
        if (targetPlatfolder.isDirectory() && (tpVersionFolder = targetPlatfolder.listFiles()) != null) {
            File[] fileArray = tpVersionFolder;
            int n = tpVersionFolder.length;
            int n2 = 0;
            while (n2 < n) {
                File tp = fileArray[n2];
                String tpVersion = tp.getName().split("-", 2)[1].toUpperCase();
                tpVersionList.add(tpVersion);
                ++n2;
            }
        }
        return tpVersionList;
    }

    private static ServiceContainer getServicesNameList(File tpFile) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.readValue(tpFile, Map.class);
        String[] services = map.keySet().toArray(new String[0]);
        return new ServiceContainer(Arrays.asList(services));
    }

    private static ServiceContainer getBundleAndVersion(File tpFile, String _serviceName) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map map = (Map)mapper.readValue(tpFile, Map.class);
        List serviceBundle = (List)map.get(_serviceName);
        if (serviceBundle != null && serviceBundle.size() != 0) {
            return new ServiceContainer((String)serviceBundle.get(0), (String)serviceBundle.get(1), (String)serviceBundle.get(2));
        }
        return null;
    }

    public static ServiceContainer getThirdPartyBundleList(String _serviceName) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        URL url = FileLocator.toFileURL((URL)ProjectCore.getDefault().getBundle().getEntry("OSGI-INF/liferay-thirdparty-bundles.json"));
        File tpFile = new File(url.getFile());
        Map map = (Map)mapper.readValue(tpFile, Map.class);
        List serviceBundle = (List)map.get(_serviceName);
        if (serviceBundle != null && serviceBundle.size() != 0) {
            return new ServiceContainer((String)serviceBundle.get(0), (String)serviceBundle.get(1), (String)serviceBundle.get(2));
        }
        return null;
    }
}

