/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.theme.core;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.theme.core.ThemeCore;
import com.liferay.ide.theme.core.operation.ThemeDescriptorHelper;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ThemeDiffResourceListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (event == null) {
            return;
        }
        if (this.shouldProcessResourceChangedEvent(event)) {
            IResourceDelta delta = event.getDelta();
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (ThemeDiffResourceListener.this.shouldProcessResourceDelta(delta)) {
                            ThemeDiffResourceListener.this.processResourceChanged(delta);
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private IFile getWorkspaceFile(IPath path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        return root.getFile(path);
    }

    protected boolean isLiferayPluginProject(IPath deltaPath) {
        IFile pluginPackagePropertiesFile = this.getWorkspaceFile(deltaPath);
        if (pluginPackagePropertiesFile != null && pluginPackagePropertiesFile.exists()) {
            return ProjectUtil.isThemeProject((IProject)pluginPackagePropertiesFile.getProject());
        }
        return false;
    }

    protected void processResourceChanged(final IResourceDelta delta) throws CoreException {
        new WorkspaceJob(Msgs.compilingTheme){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IProject project = delta.getResource().getProject();
                SDK sdk = SDKUtil.getSDK((IProject)project);
                if (sdk == null) {
                    throw new CoreException(ThemeCore.createErrorStatus("No SDK for project configured. Could not deploy theme module"));
                }
                IStatus status = sdk.compileThemePlugin(project, null);
                if (!status.isOK()) {
                    throw new CoreException(status);
                }
                IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)project);
                if (webproject == null) {
                    return status;
                }
                IResource res = webproject.findDocrootResource((IPath)new Path("WEB-INF/liferay-look-and-feel.xml"));
                IFile lookAndFeelFile = null;
                if (res != null && res.exists()) {
                    lookAndFeelFile = (IFile)res;
                }
                if (lookAndFeelFile == null) {
                    String id = project.getName().replaceAll("-theme", "");
                    IResource propsRes = webproject.findDocrootResource((IPath)new Path("WEB-INF/liferay-plugin-package.properties"));
                    String name = id;
                    if (propsRes instanceof IFile && propsRes.exists()) {
                        Properties props = new Properties();
                        try {
                            props.load(((IFile)propsRes).getContents());
                            String nameValue = props.getProperty("name");
                            if (!CoreUtil.isNullOrEmpty((String)nameValue)) {
                                name = nameValue;
                            }
                        }
                        catch (IOException e) {
                            ThemeCore.logError("Unable to load plugin package properties.", e);
                        }
                    }
                    ThemeDescriptorHelper themeDescriptorHelper = new ThemeDescriptorHelper(project);
                    ILiferayProject lProject = LiferayCore.create((Object)project);
                    String type = lProject.getProperty("theme.type", "vm");
                    String version = "6.2.0";
                    ILiferayPortal portal = (ILiferayPortal)lProject.adapt(ILiferayPortal.class);
                    if (portal != null) {
                        version = portal.getVersion();
                    }
                    themeDescriptorHelper.createDefaultFile((IContainer)webproject.getDefaultDocrootFolder(), version, id, name, type);
                    try {
                        webproject.getDefaultDocrootFolder().refreshLocal(2, null);
                    }
                    catch (Exception e) {
                        ThemeCore.logError(e);
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected boolean shouldProcessResourceChangedEvent(IResourceChangeEvent event) {
        if (event == null) {
            return false;
        }
        IResourceDelta delta = event.getDelta();
        int deltaKind = delta.getKind();
        return deltaKind != 2 && deltaKind != 16;
    }

    protected boolean shouldProcessResourceDelta(IResourceDelta delta) {
        IPath fullPath = delta.getFullPath();
        IWebProject webproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)delta.getResource().getProject());
        if (webproject == null || webproject.getDefaultDocrootFolder() == null) {
            return false;
        }
        IFolder webappRoot = webproject.getDefaultDocrootFolder();
        IPath diffPath = webappRoot.getFolder((IPath)new Path("_diffs")).getFullPath();
        return diffPath.isPrefixOf(fullPath);
    }

    private static class Msgs
    extends NLS {
        public static String compilingTheme;

        static {
            Msgs.initializeMessages((String)ThemeDiffResourceListener.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

