/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.AutoMigrateException;
import com.liferay.blade.api.AutoMigrator;
import com.liferay.blade.api.Problem;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.migration.MarkDoneAction;
import com.liferay.ide.project.ui.migration.MigrateProjectHandler;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import com.liferay.ide.project.ui.migration.ProblemAction;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AutoCorrectAction
extends ProblemAction {
    private ISelectionProvider _provider;

    public AutoCorrectAction(ISelectionProvider provider) {
        super(provider, "Correct automatically");
        this._provider = provider;
    }

    @Override
    public void run() {
        List<Problem> problems = MigrationUtil.getProblemsFromSelection(this.getSelection());
        this.runWithAutoCorrect(problems);
    }

    public IStatus runWithAutoCorrect(final List<Problem> problems) {
        final IResource file = MigrationUtil.getIResourceFromProblem(problems.get(0));
        final BundleContext context = FrameworkUtil.getBundle(AutoCorrectAction.class).getBundleContext();
        WorkspaceJob job = new WorkspaceJob("Auto correcting migration problem."){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus retval = Status.OK_STATUS;
                try {
                    Problem problem = (Problem)problems.get(0);
                    String autoCorrectKey = null;
                    int filterKeyIndex = problem.autoCorrectContext.indexOf(":");
                    autoCorrectKey = filterKeyIndex > -1 ? problem.autoCorrectContext.substring(0, filterKeyIndex) : problem.autoCorrectContext;
                    Collection refs = context.getServiceReferences(AutoMigrator.class, "(auto.correct=" + autoCorrectKey + ")");
                    for (ServiceReference ref : refs) {
                        IMarker problemMarker;
                        IResource resource;
                        AutoMigrator autoMigrator = (AutoMigrator)context.getService(ref);
                        int problemsCorrected = autoMigrator.correctProblems(problem.file, Collections.singletonList(problem));
                        if (problemsCorrected <= 0 || (resource = MigrationUtil.getIResourceFromProblem(problem)) == null || (problemMarker = resource.findMarker(problem.markerId)) == null || !problemMarker.exists()) continue;
                        problemMarker.delete();
                    }
                    file.refreshLocal(1, monitor);
                    MigrateProjectHandler migrateHandler = new MigrateProjectHandler();
                    Path path = new Path(problem.getFile().getPath());
                    String projectName = "";
                    IProject project = CoreUtil.getProject((File)problem.getFile());
                    if (project.exists() && project != null) {
                        projectName = project.getName();
                    }
                    for (Problem p : problems) {
                        new MarkDoneAction().run(p, AutoCorrectAction.this._provider);
                    }
                    if (!projectName.equals("")) {
                        migrateHandler.findMigrationProblems((IPath[])new Path[]{path}, new String[]{projectName});
                    }
                }
                catch (InvalidSyntaxException problem) {
                }
                catch (AutoMigrateException | CoreException e) {
                    retval = ProjectUI.createErrorStatus("Unable to auto correct problem", (Exception)e);
                    return retval;
                }
                return retval;
            }
        };
        job.schedule();
        return Status.OK_STATUS;
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.setEnabled(false);
        } else {
            boolean selectionCompatible = true;
            Iterator items = selection.iterator();
            Object lastItem = null;
            while (items.hasNext()) {
                String prLastKey;
                String prCurrentKey;
                Object item = items.next();
                if (!(item instanceof Problem)) {
                    selectionCompatible = false;
                    break;
                }
                Problem problem = (Problem)item;
                if (problem.autoCorrectContext == null) {
                    selectionCompatible = false;
                    break;
                }
                if (lastItem != null && !(prCurrentKey = ((Problem)item).autoCorrectContext.substring(0, problem.autoCorrectContext.indexOf(":"))).equals(prLastKey = ((Problem)lastItem).autoCorrectContext.substring(0, problem.autoCorrectContext.indexOf(":")))) {
                    selectionCompatible = false;
                    break;
                }
                lastItem = item;
            }
            Iterator items2 = selection.iterator();
            ArrayList<String> autoCorrectContexts = new ArrayList<String>();
            while (items2.hasNext()) {
                Object item = items2.next();
                if (!(item instanceof Problem) || ((Problem)item).autoCorrectContext == null) continue;
                autoCorrectContexts.add(((Problem)item).autoCorrectContext);
            }
            this.setEnabled(selectionCompatible);
            ArrayList<String> allAutoCorrectContexts = new ArrayList<String>();
            if (this._provider instanceof TableViewer) {
                TableViewer viewer = (TableViewer)this._provider;
                Object obj = viewer.getInput();
                if (obj instanceof Object[]) {
                    Object[] problems;
                    Object[] objectArray = problems = (Object[])obj;
                    int n = problems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof Problem && ((Problem)o).autoCorrectContext != null) {
                            allAutoCorrectContexts.add(((Problem)o).autoCorrectContext);
                        }
                        ++n2;
                    }
                } else if (obj instanceof List) {
                    List list = (List)obj;
                    for (Object p : list) {
                        if (!(p instanceof Problem)) continue;
                        Problem problem = (Problem)p;
                        if (problem.autoCorrectContext == null) continue;
                        allAutoCorrectContexts.add(problem.autoCorrectContext);
                    }
                }
            }
            this.setText("Correct automatically");
        }
    }

    @Override
    protected IStatus runWithMarker(Problem problem, IMarker marker) {
        return null;
    }
}

