/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.migration;

import com.liferay.blade.api.Problem;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.upgrade.FileProblems;
import com.liferay.ide.project.core.upgrade.IgnoredProblemsContainer;
import com.liferay.ide.project.core.upgrade.MigrationProblems;
import com.liferay.ide.project.core.upgrade.UpgradeAssistantSettingsUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.migration.IgnoreAction;
import com.liferay.ide.project.ui.migration.MigrationContentProvider;
import com.liferay.ide.project.ui.migration.MigrationProblemsContainer;
import com.liferay.ide.project.ui.migration.MigrationUtil;
import com.liferay.ide.project.ui.upgrade.animated.FindBreakingChangesPage;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.project.ui.upgrade.animated.UpgradeView;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.actions.SelectionProviderAction;

public class IgnoreAlwaysAction
extends SelectionProviderAction
implements IAction {
    private ISelectionProvider _provider;

    public IgnoreAlwaysAction(ISelectionProvider provider) {
        super(provider, "Ignore all problems of this type");
        this._provider = provider;
    }

    public void run() {
        final Problem problem = MigrationUtil.getProblemFromSelection(this.getSelection());
        this.storeIgnoredProblem(problem);
        new WorkspaceJob("Ignore all problems of this type"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus retval = Status.OK_STATUS;
                try {
                    MigrationProblems[] projectProblem;
                    FindBreakingChangesPage page = UpgradeView.getPage(Page.FINDBREACKINGCHANGES_PAGE_ID, FindBreakingChangesPage.class);
                    TreeViewer treeViewer = page.getTreeViewer();
                    MigrationContentProvider contentProvider = (MigrationContentProvider)treeViewer.getContentProvider();
                    MigrationProblemsContainer mpContainer = (MigrationProblemsContainer)contentProvider._problems.get(0);
                    MigrationProblems[] migrationProblemsArray = projectProblem = mpContainer.getProblemsArray();
                    int n = projectProblem.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileProblems[] fProblems;
                        MigrationProblems pProblem = migrationProblemsArray[n2];
                        FileProblems[] fileProblemsArray = fProblems = pProblem.getProblems();
                        int n3 = fProblems.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            FileProblems fp = fileProblemsArray[n4];
                            List problems = fp.getProblems();
                            for (Problem p : problems) {
                                if (!p.getTicket().equals(problem.getTicket())) continue;
                                new IgnoreAction().run(p, IgnoreAlwaysAction.this._provider);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    retval = ProjectUI.createErrorStatus("Unable to get file from problem");
                }
                return retval;
            }
        }.schedule();
    }

    public void selectionChanged(IStructuredSelection selection) {
        Object element = this.getStructuredSelection().getFirstElement();
        if (element instanceof Problem && !CoreUtil.empty((String)((Problem)element).getTicket())) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private void storeIgnoredProblem(Problem problem) {
        try {
            IgnoredProblemsContainer ipContainer = MigrationUtil.getIgnoredProblemsContainer();
            if (ipContainer == null) {
                ipContainer = new IgnoredProblemsContainer();
            }
            ipContainer.add(problem);
            UpgradeAssistantSettingsUtil.setObjectToStore(IgnoredProblemsContainer.class, (Object)ipContainer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

