/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.modules;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.modules.BaseModuleOp;
import com.liferay.ide.project.ui.wizard.WorkingSetCustomPart;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.WizardDef;
import org.eclipse.sapphire.ui.forms.WizardPagePart;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.web.internal.DelegateConfigurationElement;

public class BaseProjectWizard<T extends Element>
extends SapphireWizard<T>
implements IWorkbenchWizard,
INewWizard {
    private boolean firstErrorMessageRemoved = false;

    public BaseProjectWizard(T t, DefinitionLoader.Reference<WizardDef> wizard) {
        super(t, wizard);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IResource resource;
        IPath location;
        Object element;
        if (selection != null && (element = selection.getFirstElement()) instanceof IResource && (location = (resource = (IResource)element).getProject().getLocation()) != null) {
            ((BaseModuleOp)this.element()).setInitialSelectionPath(PathBridge.create((IPath)location));
        }
    }

    protected void addToWorkingSets(IProject newProject) throws Exception {
        if (newProject != null) {
            for (FormComponentPart formPart : ((WizardPagePart)this.part().getPages().get(0)).children().all()) {
                WorkingSetCustomPart workingSetPart;
                Object[] workingSets;
                if (!(formPart instanceof WorkingSetCustomPart) || CoreUtil.isNullOrEmpty((Object[])(workingSets = (workingSetPart = (WorkingSetCustomPart)formPart).getWorkingSets()))) continue;
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)newProject, (IWorkingSet[])workingSets);
            }
        }
    }

    public IWizardPage[] getPages() {
        IWizardPage[] wizardPages = super.getPages();
        if (!this.firstErrorMessageRemoved && wizardPages != null) {
            SapphireWizardPage wizardPage = (SapphireWizardPage)wizardPages[0];
            String message = wizardPage.getMessage();
            int messageType = wizardPage.getMessageType();
            if (messageType == 3 && !CoreUtil.isNullOrEmpty((String)message)) {
                wizardPage.setMessage("Please enter a project name.", 0);
                this.firstErrorMessageRemoved = true;
            }
        }
        return wizardPages;
    }

    protected void openLiferayPerspective(IProject newProject) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IPerspectiveDescriptor perspective = workbench.getActiveWorkbenchWindow().getActivePage().getPerspective();
        if (perspective.getId().equals("com.liferay.ide.eclipse.ui.perspective.liferayworkspace")) {
            return;
        }
        DelegateConfigurationElement element = new DelegateConfigurationElement(null){

            public String getAttribute(String aName) {
                if (aName.equals("finalPerspective")) {
                    return "com.liferay.ide.eclipse.ui.perspective.liferayworkspace";
                }
                return super.getAttribute(aName);
            }
        };
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)element);
        BasicNewResourceWizard.selectAndReveal((IResource)newProject, (IWorkbenchWindow)workbench.getActiveWorkbenchWindow());
    }
}

