/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.dialog.CustomProjectSelectionDialog;
import com.liferay.ide.project.ui.upgrade.action.CompileAction;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;

public class BuildServicePage
extends Page {
    public BuildServicePage(Composite parent, int style, LiferayUpgradeDataModel dataModel) {
        super(parent, style, dataModel, BUILDSERVICE_PAGE_ID, true);
        Button buildServiceButton = new Button((Composite)this, 8);
        buildServiceButton.setText("Build Services");
        buildServiceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private void deleteLegacyFiles(IProject project, IProgressMonitor monitor) {
                try {
                    IFolder metaInfFolder;
                    String relativePath = "/docroot/WEB-INF/src/META-INF";
                    IFile portletSpringXML = project.getFile(String.valueOf(relativePath) + "/portlet-spring.xml");
                    IFile shardDataSourceSpringXML = project.getFile(String.valueOf(relativePath) + "/shard-data-source-spring.xml");
                    if (portletSpringXML.exists()) {
                        portletSpringXML.delete(true, monitor);
                    }
                    if (shardDataSourceSpringXML.exists()) {
                        shardDataSourceSpringXML.delete(true, monitor);
                    }
                    if ((metaInfFolder = project.getFolder("/src/main/resources/META-INF/")).exists()) {
                        metaInfFolder.delete(true, monitor);
                    }
                }
                catch (CoreException e) {
                    ProjectUI.logError((Exception)((Object)e));
                }
            }

            private List<IProject> getServiceBuilderProjects() {
                IProject[] projects;
                ArrayList<IProject> results = new ArrayList<IProject>();
                IProject[] iProjectArray = projects = CoreUtil.getAllProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    IFile serviceFile = project.getFile("/docroot/WEB-INF/service.xml");
                    if (!serviceFile.exists()) {
                        serviceFile = project.getFile("src/main/webapp/WEB-INF/service.xml");
                    }
                    if (serviceFile.exists()) {
                        results.add(project);
                    }
                    ++n2;
                }
                return results;
            }

            public void widgetSelected(SelectionEvent e) {
                Object[] selectedProjects;
                List<IProject> projects = this.getServiceBuilderProjects();
                CustomProjectSelectionDialog dialog = new CustomProjectSelectionDialog(UIUtil.getActiveShell());
                dialog.setProjects(projects);
                URL imageUrl = ProjectUI.getDefault().getBundle().getEntry("/icons/e16/service.png");
                Image serviceXmlImage = ImageDescriptor.createFromURL((URL)imageUrl).createImage();
                dialog.setImage(serviceXmlImage);
                dialog.setTitle("Liferay Service Project");
                dialog.setMessage("Select Liferay Service Project");
                final ArrayList<IProject> liferayServiceProjects = new ArrayList<IProject>();
                if (dialog.open() == 0 && (selectedProjects = dialog.getResult()) != null) {
                    Object[] objectArray = selectedProjects;
                    int n = selectedProjects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object project = objectArray[n2];
                        if (project instanceof IJavaProject) {
                            IJavaProject p = (IJavaProject)project;
                            liferayServiceProjects.add(p.getProject());
                        }
                        ++n2;
                    }
                }
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                for (IProject project : liferayServiceProjects) {
                                    ProcessConsole pc;
                                    IConsole console;
                                    this.deleteLegacyFiles(project, monitor);
                                    ILiferayProject liferayProject = LiferayCore.create((Object)project);
                                    if (liferayProject != null) {
                                        IProjectBuilder builder = (IProjectBuilder)liferayProject.adapt(IProjectBuilder.class);
                                        builder.buildService(monitor);
                                    }
                                    if ((console = CompileAction.getConsole("build-service")) == null || !(pc = (ProcessConsole)console).getDocument().get().contains("BUILD FAILED")) continue;
                                    return;
                                }
                            }
                            catch (CoreException coreException) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void createSpecialDescriptor(Composite parent, int style) {
        String descriptor = "In this step, we will delete some legacy servicebuilder related files and re-run build-service on servicebuilder projects.\nNote: Please make sure the default installed jre is JDK 8 (Preferences-Java-Installed JREs).";
        String url = "";
        Link link = SWTUtil.createHyperLink((Composite)this, (int)style, (String)"In this step, we will delete some legacy servicebuilder related files and re-run build-service on servicebuilder projects.\nNote: Please make sure the default installed jre is JDK 8 (Preferences-Java-Installed JREs).", (int)1, (String)url);
        link.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
    }

    @Override
    public String getPageTitle() {
        return "Build Services";
    }
}

