/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.ILiferayProjectImporter;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.core.util.IOUtil;
import com.liferay.ide.core.util.ZipUtil;
import com.liferay.ide.project.core.IProjectBuilder;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.core.modules.BladeCLI;
import com.liferay.ide.project.core.modules.BladeCLIException;
import com.liferay.ide.project.core.modules.ImportLiferayModuleProjectOpMethods;
import com.liferay.ide.project.core.util.LiferayWorkspaceUtil;
import com.liferay.ide.project.core.util.ProjectImportUtil;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.core.util.SearchFilesVisitor;
import com.liferay.ide.project.ui.IvyUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.upgrade.animated.BundleNameValidationService;
import com.liferay.ide.project.ui.upgrade.animated.BundleUrlValidationService;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import com.liferay.ide.project.ui.upgrade.animated.Page;
import com.liferay.ide.project.ui.upgrade.animated.PageNavigateEvent;
import com.liferay.ide.project.ui.upgrade.animated.PageValidateEvent;
import com.liferay.ide.project.ui.upgrade.animated.ProjectLocationValidationService;
import com.liferay.ide.project.ui.upgrade.animated.SelectionChangedListener;
import com.liferay.ide.project.ui.upgrade.animated.UpgradeView;
import com.liferay.ide.sdk.core.SDK;
import com.liferay.ide.sdk.core.SDKUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.util.ServerUtil;
import com.liferay.ide.ui.util.SWTUtil;
import com.liferay.ide.ui.util.UIUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ValuePropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.PathBridge;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.osgi.framework.Version;

public class InitConfigureProjectPage
extends Page
implements IServerLifecycleListener,
SelectionChangedListener {
    private static Color GRAY;
    private Label dirLabel;
    private Text dirField;
    private Combo layoutComb;
    private Label layoutLabel;
    private String[] layoutNames = new String[]{"Upgrade to Liferay Workspace", "Upgrade to Liferay Plugins SDK 7"};
    private Label serverLabel;
    private Combo serverComb;
    private Button serverButton;
    private Button showAllPagesButton;
    private Label bundleNameLabel;
    private Label bundleUrlLabel;
    private Text bundleNameField;
    private Text bundleUrlField;
    private boolean validationResult;
    private Button importButton;
    private Button downloadBundleCheckbox;
    private Composite pageParent;
    private Composite blankComposite;
    private Control createHorizontalSpacer;
    private Control createSeparator;
    private ProjectLocationValidationService sdkValidation = (ProjectLocationValidationService)this.dataModel.getSdkLocation().service(ProjectLocationValidationService.class);
    private BundleNameValidationService bundleNameValidation = (BundleNameValidationService)this.dataModel.getBundleName().service(BundleNameValidationService.class);
    private BundleUrlValidationService bundleUrlValidation = (BundleUrlValidationService)this.dataModel.getBundleUrl().service(BundleUrlValidationService.class);

    private boolean isMavenProject(String path) {
        return ImportLiferayModuleProjectOpMethods.getBuildType((String)path).getMessage().equals("maven");
    }

    public InitConfigureProjectPage(Composite parent, int style, final LiferayUpgradeDataModel dataModel) {
        super(parent, style, dataModel, INIT_CONFIGURE_PROJECT_PAGE_ID, false);
        dataModel.getSdkLocation().attach((org.eclipse.sapphire.Listener)new LiferayUpgradeValidationListener());
        dataModel.getBundleName().attach((org.eclipse.sapphire.Listener)new LiferayUpgradeValidationListener());
        dataModel.getBundleUrl().attach((org.eclipse.sapphire.Listener)new LiferayUpgradeValidationListener());
        dataModel.getBackupLocation().attach((org.eclipse.sapphire.Listener)new LiferayUpgradeValidationListener());
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 512);
        GridData scrolledData = new GridData(4, 4, true, true);
        scrolledData.widthHint = 500;
        scrolledComposite.setLayoutData((Object)scrolledData);
        this.pageParent = SWTUtil.createComposite((Composite)scrolledComposite, (int)this.getGridLayoutCount(), (int)1, (int)1808);
        scrolledComposite.setMinHeight(300);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setContent((Control)this.pageParent);
        this.dirLabel = this.createLabel(this.pageParent, "Plugins SDK or Maven Project Root Location:");
        this.dirField = this.createTextField(this.pageParent, 0);
        this.dirField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                dataModel.setSdkLocation(InitConfigureProjectPage.this.dirField.getText());
                if (InitConfigureProjectPage.this.dirField.getText().isEmpty()) {
                    InitConfigureProjectPage.this.disposeMigrateLayoutElement();
                    InitConfigureProjectPage.this.disposeBundleCheckboxElement();
                    InitConfigureProjectPage.this.disposeBundleElement();
                    InitConfigureProjectPage.this.disposeServerEelment();
                    InitConfigureProjectPage.this.disposeImportElement();
                    InitConfigureProjectPage.this.createMigrateLayoutElement();
                    InitConfigureProjectPage.this.createDownloaBundleCheckboxElement();
                    InitConfigureProjectPage.this.createBundleElement();
                    InitConfigureProjectPage.this.createImportElement();
                    InitConfigureProjectPage.this.pageParent.layout();
                    InitConfigureProjectPage.this.startCheckThread();
                }
            }
        });
        SWTUtil.createButton((Composite)this.pageParent, (String)"Browse...").addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dd = new DirectoryDialog(InitConfigureProjectPage.this.getShell());
                dd.setMessage("Plugins SDK top-level directory or Maven project root directory");
                String selectedDir = dd.open();
                if (selectedDir != null) {
                    InitConfigureProjectPage.this.dirField.setText(selectedDir);
                }
            }
        });
        this.createMigrateLayoutElement();
        this.createDownloaBundleCheckboxElement();
        this.createBundleElement();
        this.createImportElement();
        this.startCheckThread();
    }

    private void backup(IProgressMonitor monitor) {
        Boolean backup = (Boolean)this.dataModel.getBackupSdk().content();
        if (!backup.booleanValue()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                progress.setTaskName("Backup origial project folder into Eclipse workspace...");
                org.eclipse.sapphire.modeling.Path originalPath = (org.eclipse.sapphire.modeling.Path)this.dataModel.getSdkLocation().content();
                if (originalPath != null) {
                    IPath backupLocation = PathBridge.create((org.eclipse.sapphire.modeling.Path)((org.eclipse.sapphire.modeling.Path)this.dataModel.getBackupLocation().content()));
                    backupLocation.toFile().mkdirs();
                    progress.worked(30);
                    ZipUtil.zip((File)originalPath.toFile(), (File)backupLocation.append("backup.zip").toFile());
                    progress.setWorkRemaining(70);
                }
            }
            catch (IOException e) {
                ProjectUI.logError("Error to backup original project folder.", e);
                progress.done();
            }
        }
        finally {
            progress.done();
        }
    }

    public void checkAndConfigureIvy(final IProject project) {
        if (project != null && project.getFile("ivy.xml").exists()) {
            new WorkspaceJob("Configuring project with Ivy dependencies"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        IvyUtil.configureIvyProject(project, monitor);
                    }
                    catch (CoreException e) {
                        return ProjectCore.createErrorStatus((String)"com.liferay.ide.project.core", (String)"Failed to configured ivy project.", (Throwable)e);
                    }
                    return StatusBridge.create((Status)Status.createOkStatus());
                }
            }.schedule();
        }
    }

    private void checkProjectType(IProject project) {
        List searchFiles;
        if (ProjectUtil.isMavenProject((IProject)project)) {
            this.dataModel.setHasMavenProject(true);
        }
        if (ProjectUtil.isPortletProject((IProject)project)) {
            this.dataModel.setHasPortlet(true);
        }
        if (ProjectUtil.isHookProject((IProject)project)) {
            this.dataModel.setHasHook(true);
        }
        if ((searchFiles = new SearchFilesVisitor().searchFiles((IResource)project, "service.xml")).size() > 0) {
            this.dataModel.setHasServiceBuilder(true);
        }
        if (ProjectUtil.isLayoutTplProject((IProject)project)) {
            this.dataModel.setHasLayout(true);
        }
        if (ProjectUtil.isThemeProject((IProject)project)) {
            this.dataModel.setHasTheme(true);
        }
        if (ProjectUtil.isExtProject((IProject)project)) {
            this.dataModel.setHasExt(true);
        }
        if (ProjectUtil.isWebProject((IProject)project)) {
            this.dataModel.setHasWeb(true);
        }
    }

    private void clearExistingProjects(IPath location, IProgressMonitor monitor) throws CoreException {
        IProject project;
        int n;
        int n2;
        IProject[] iProjectArray;
        IProject[] projects;
        IProject sdkProject = SDKUtil.getWorkspaceSDKProject();
        if (sdkProject != null && sdkProject.getLocation().equals((Object)location)) {
            iProjectArray = projects = ProjectUtil.getAllPluginsSDKProjects();
            n2 = projects.length;
            n = 0;
            while (n < n2) {
                project = iProjectArray[n];
                project.delete(false, true, monitor);
                ++n;
            }
            sdkProject.delete(false, true, monitor);
        }
        iProjectArray = projects = CoreUtil.getAllProjects();
        n2 = projects.length;
        n = 0;
        while (n < n2) {
            project = iProjectArray[n];
            if (project.getLocation().toPortableString().startsWith(location.toPortableString())) {
                project.delete(false, true, monitor);
            }
            ++n;
        }
    }

    private void copyNewSDK(IPath targetSDKLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                progress.beginTask("Copy new SDK to override target SDK.", 100);
                URL sdkZipUrl = Platform.getBundle((String)"com.liferay.ide.project.ui").getEntry("resources/sdk70ga2.zip");
                File sdkZipFile = new File(FileLocator.toFileURL((URL)sdkZipUrl).getFile());
                IPath stateLocation = ProjectCore.getDefault().getStateLocation();
                File stateDir = stateLocation.toFile();
                progress.worked(30);
                ZipUtil.unzip((File)sdkZipFile, (File)stateDir);
                progress.worked(60);
                IOUtil.copyDirToDir((File)new File(stateDir, "com.liferay.portal.plugins.sdk-7.0"), (File)targetSDKLocation.toFile());
                progress.worked(100);
            }
            catch (Exception e) {
                ProjectUI.logError(e);
                throw new CoreException(StatusBridge.create((Status)Status.createErrorStatus((String)"Failed copy new SDK..", (Throwable)e)));
            }
        }
        finally {
            progress.done();
        }
    }

    @Override
    public void createSpecialDescriptor(Composite parent, int style) {
        Composite fillLayoutComposite = SWTUtil.createComposite((Composite)parent, (int)2, (int)2, (int)768);
        String descriptor = "The initial step will be to upgrade to Liferay Workspace or Liferay Plugins SDK 7.0. For more details, please see <a>dev.liferay.com</a>.";
        String url = "https://dev.liferay.com/develop/tutorials";
        SWTUtil.createHyperLink((Composite)fillLayoutComposite, (int)64, (String)"The initial step will be to upgrade to Liferay Workspace or Liferay Plugins SDK 7.0. For more details, please see <a>dev.liferay.com</a>.", (int)1, (String)url);
        String extensionDec = "The first step will help you convert a Liferay Plugins SDK 6.2 to Liferay Plugins SDK 7.0 or to Liferay Workspace.\nClick the \"import\" button to import your project into Eclipse workspace(this process maybe need 5-10 mins for bundle init).\nNote:\n       In order to save time, downloading 7.0 ivy cache locally could be a good choice to upgrade to liferay plugins sdk 7. \n       Theme and ext projects will be ignored for that we do not support to upgrade them in this tool currently. \n";
        Label image = new Label(fillLayoutComposite, 64);
        image.setImage(this.loadImage("question.png"));
        final PopupDialog popupDialog = new PopupDialog(fillLayoutComposite.getShell(), 16, true, false, false, false, false, null, null){
            private static final int CURSOR_SIZE = 15;

            protected Point getInitialLocation(Point initialSize) {
                Display display = this.getShell().getDisplay();
                Point location = display.getCursorLocation();
                location.x += 15;
                location.y += 15;
                return location;
            }

            protected Control createDialogArea(Composite parent) {
                Label label = new Label(parent, 64);
                label.setText("The first step will help you convert a Liferay Plugins SDK 6.2 to Liferay Plugins SDK 7.0 or to Liferay Workspace.\nClick the \"import\" button to import your project into Eclipse workspace(this process maybe need 5-10 mins for bundle init).\nNote:\n       In order to save time, downloading 7.0 ivy cache locally could be a good choice to upgrade to liferay plugins sdk 7. \n       Theme and ext projects will be ignored for that we do not support to upgrade them in this tool currently. \n");
                label.setFont(new Font(null, "Times New Roman", 11, 0));
                GridData gd = new GridData(1809);
                gd.horizontalIndent = 1;
                gd.verticalIndent = 1;
                label.setLayoutData((Object)gd);
                return label;
            }
        };
        image.addListener(32, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                popupDialog.open();
            }
        });
        image.addListener(7, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                popupDialog.close();
            }
        });
    }

    private void createBundleControl() {
        this.disposeServerEelment();
        this.disposeImportElement();
        this.disposeBundleElement();
        this.createDownloaBundleCheckboxElement();
        this.createBundleElement();
        this.createImportElement();
        this.pageParent.layout();
    }

    private void createServerControl() {
        this.disposeServerEelment();
        this.disposeImportElement();
        this.disposeBundleCheckboxElement();
        this.disposeBundleElement();
        this.createServerElement();
        this.createImportElement();
        this.pageParent.layout();
    }

    private void createMigrateLayoutElement() {
        this.layoutLabel = this.createLabel(this.pageParent, "Select Migrate Layout:");
        this.layoutComb = new Combo(this.pageParent, 12);
        this.layoutComb.setLayoutData((Object)new GridData(768));
        this.layoutComb.setItems(this.layoutNames);
        this.layoutComb.select(0);
        this.layoutComb.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int sel = InitConfigureProjectPage.this.layoutComb.getSelectionIndex();
                if (sel == 1) {
                    InitConfigureProjectPage.this.createServerControl();
                    InitConfigureProjectPage.this.dataModel.setDownloadBundle(false);
                } else {
                    InitConfigureProjectPage.this.createBundleControl();
                }
                InitConfigureProjectPage.this.dataModel.setLayout(InitConfigureProjectPage.this.layoutComb.getText());
                InitConfigureProjectPage.this.startCheckThread();
            }
        });
        this.dataModel.setLayout(this.layoutComb.getText());
    }

    private void createDownloaBundleCheckboxElement() {
        this.disposeBundleCheckboxElement();
        this.downloadBundleCheckbox = SWTUtil.createCheckButton((Composite)this.pageParent, (String)"Download Liferay bundle (recommended)", null, (boolean)true, (int)1);
        GridDataFactory.generate((Control)this.downloadBundleCheckbox, (int)2, (int)1);
        this.downloadBundleCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InitConfigureProjectPage.this.dataModel.setDownloadBundle(InitConfigureProjectPage.this.downloadBundleCheckbox.getSelection());
                if (((Boolean)InitConfigureProjectPage.this.dataModel.getDownloadBundle().content()).booleanValue()) {
                    InitConfigureProjectPage.this.disposeImportElement();
                    InitConfigureProjectPage.this.createBundleElement();
                    InitConfigureProjectPage.this.createImportElement();
                    InitConfigureProjectPage.this.pageParent.layout();
                } else {
                    InitConfigureProjectPage.this.disposeBundleElement();
                    InitConfigureProjectPage.this.disposeImportElement();
                    InitConfigureProjectPage.this.createImportElement();
                    InitConfigureProjectPage.this.pageParent.layout();
                }
                InitConfigureProjectPage.this.startCheckThread();
            }
        });
    }

    private void createBundleElement() {
        this.bundleNameLabel = this.createLabel(this.pageParent, "Server Name:");
        this.bundleNameField = this.createTextField(this.pageParent, 0);
        this.bundleNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InitConfigureProjectPage.this.dataModel.setBundleName(InitConfigureProjectPage.this.bundleNameField.getText());
            }
        });
        String bundleName = (String)this.dataModel.getBundleName().content();
        this.bundleNameField.setText(bundleName != null ? bundleName : "");
        this.bundleUrlLabel = this.createLabel(this.pageParent, "Bundle URL:");
        this.bundleUrlField = this.createTextField(this.pageParent, 0);
        this.bundleUrlField.setForeground(this.pageParent.getDisplay().getSystemColor(16));
        this.bundleUrlField.setText((String)this.dataModel.getBundleUrl().content(true));
        this.bundleUrlField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InitConfigureProjectPage.this.dataModel.setBundleUrl(InitConfigureProjectPage.this.bundleUrlField.getText());
            }
        });
        this.bundleUrlField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                String input = ((Text)e.getSource()).getText();
                if (input.equals("https://cdn.lfrs.sl/releases.liferay.com/portal/7.0.2-ga3/liferay-ce-portal-tomcat-7.0-ga3-20160804222206210.zip")) {
                    InitConfigureProjectPage.this.bundleUrlField.setText("");
                }
                InitConfigureProjectPage.this.bundleUrlField.setForeground(InitConfigureProjectPage.this.pageParent.getDisplay().getSystemColor(2));
            }

            public void focusLost(FocusEvent e) {
                String input = ((Text)e.getSource()).getText();
                if (CoreUtil.isNullOrEmpty((String)input)) {
                    InitConfigureProjectPage.this.bundleUrlField.setForeground(InitConfigureProjectPage.this.pageParent.getDisplay().getSystemColor(16));
                    InitConfigureProjectPage.this.bundleUrlField.setText("https://cdn.lfrs.sl/releases.liferay.com/portal/7.0.2-ga3/liferay-ce-portal-tomcat-7.0-ga3-20160804222206210.zip");
                }
            }
        });
        this.dataModel.setBundleUrl(this.bundleUrlField.getText());
    }

    private void createImportElement() {
        this.createHorizontalSpacer = InitConfigureProjectPage.createHorizontalSpacer(this.pageParent, 3);
        this.createSeparator = InitConfigureProjectPage.createSeparator(this.pageParent, 3);
        String backupFolderName = "Backup project into folder";
        this.importButton = SWTUtil.createButton((Composite)this.pageParent, (String)"Import Projects");
        this.importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Boolean importFinished = (Boolean)InitConfigureProjectPage.this.dataModel.getImportFinished().content();
                    if (InitConfigureProjectPage.this.isPageValidate() && !importFinished.booleanValue()) {
                        InitConfigureProjectPage.this.saveSettings();
                        InitConfigureProjectPage.this.importButton.setEnabled(false);
                        InitConfigureProjectPage.this.importProject();
                        UpgradeView.resetPages();
                        PageNavigateEvent event = new PageNavigateEvent();
                        if (UpgradeView.getPageNumber() < 3) {
                            Boolean showAllPages = MessageDialog.openQuestion((Shell)UIUtil.getActiveShell(), (String)"Show All Pages", (String)"There is no project need to be upgraded.\nDo you want to show all the following steps?");
                            if (showAllPages.booleanValue()) {
                                UpgradeView.showAllPages();
                            } else {
                                event.setTargetPage(1);
                            }
                        } else {
                            event.setTargetPage(2);
                        }
                        for (UpgradeView.PageNavigatorListener listener : InitConfigureProjectPage.this.naviListeners) {
                            listener.onPageNavigate(event);
                        }
                        InitConfigureProjectPage.this.setNextPage(true);
                        InitConfigureProjectPage.this.importButton.setEnabled(true);
                        InitConfigureProjectPage.this.setSelectedAction(InitConfigureProjectPage.this.getSelectedAction("PageFinishAction"));
                    }
                }
                catch (CoreException ex) {
                    ProjectUI.logError((Exception)((Object)ex));
                    PageValidateEvent pe = new PageValidateEvent();
                    pe.setMessage(ex.getMessage());
                    pe.setType(PageValidateEvent.ERROR);
                    InitConfigureProjectPage.this.triggerValidationEvent(pe);
                }
            }
        });
    }

    private void createInitBundle(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                progress.beginTask("Execute Liferay Worksapce Bundle Init Command...", 100);
                String layout = (String)this.dataModel.getLayout().content();
                if (layout.equals(this.layoutNames[0])) {
                    IPath sdkLocation = PathBridge.create((org.eclipse.sapphire.modeling.Path)((org.eclipse.sapphire.modeling.Path)this.dataModel.getSdkLocation().content()));
                    IProject project = CoreUtil.getProject((String)sdkLocation.lastSegment());
                    String bundleUrl = (String)this.dataModel.getBundleUrl().content();
                    String bundleName = (String)this.dataModel.getBundleName().content();
                    IProjectBuilder projectBuilder = this.getProjectBuilder(project);
                    progress.worked(30);
                    if (bundleUrl != null && projectBuilder != null) {
                        projectBuilder.execInitBundle(project, "initBundle", bundleUrl, monitor);
                    }
                    if (sdkLocation.append("bundles").toFile().exists()) {
                        progress.worked(60);
                        IPath runtimeLocation = sdkLocation.append(LiferayWorkspaceUtil.getHomeDir((String)sdkLocation.toOSString()));
                        ServerUtil.addPortalRuntimeAndServer((String)bundleName, (IPath)runtimeLocation, (IProgressMonitor)monitor);
                        IServer bundleServer = ServerCore.findServer((String)((String)this.dataModel.getBundleName().content()));
                        if (bundleServer != null) {
                            org.eclipse.sapphire.modeling.Path newPath = (org.eclipse.sapphire.modeling.Path)this.dataModel.getSdkLocation().content();
                            SDK sdk = SDKUtil.createSDKFromLocation((IPath)PathBridge.create((org.eclipse.sapphire.modeling.Path)newPath).append("plugins-sdk"));
                            IPath bundleLocation = bundleServer.getRuntime().getLocation();
                            sdk.addOrUpdateServerProperties(bundleLocation);
                        }
                        project.refreshLocal(2, monitor);
                    }
                }
                progress.worked(100);
            }
            catch (Exception e) {
                ProjectUI.logError(e);
                throw new CoreException(StatusBridge.create((Status)Status.createErrorStatus((String)"Failed to execute Liferay Workspace Bundle Init Command...", (Throwable)e)));
            }
        }
        finally {
            progress.done();
        }
    }

    private void createLiferayWorkspace(IPath targetSDKLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            try {
                progress.beginTask("Initializing Liferay Workspace...", 100);
                StringBuilder sb = new StringBuilder();
                sb.append("-b ");
                sb.append("\"" + targetSDKLocation.toFile().getAbsolutePath() + "\" ");
                sb.append("init -u");
                progress.worked(30);
                BladeCLI.execute((String)sb.toString());
                progress.worked(100);
            }
            catch (BladeCLIException e) {
                ProjectUI.logError((Exception)((Object)e));
                throw new CoreException(StatusBridge.create((Status)Status.createErrorStatus((String)"Faild execute Liferay Workspace Init Command...", (Throwable)e)));
            }
        }
        finally {
            progress.done();
        }
    }

    private void createServerElement() {
        this.serverLabel = this.createLabel(this.pageParent, "Liferay Server Name:");
        this.serverComb = new Combo(this.pageParent, 12);
        this.serverComb.setLayoutData((Object)new GridData(768));
        this.serverButton = SWTUtil.createButton((Composite)this.pageParent, (String)"Add Server...");
        this.serverButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerUIUtil.showNewServerWizard((Shell)InitConfigureProjectPage.this.pageParent.getShell(), (String)"liferay.bundle", null, (String)"com.liferay.");
            }
        });
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this);
        Object[] servers = ServerCore.getServers();
        ArrayList<String> serverNames = new ArrayList<String>();
        if (!CoreUtil.isNullOrEmpty((Object[])servers)) {
            Object[] objectArray = servers;
            int n = servers.length;
            int n2 = 0;
            while (n2 < n) {
                Object server = objectArray[n2];
                if (LiferayServerCore.newPortalBundle((IPath)server.getRuntime().getLocation()) != null) {
                    serverNames.add(server.getName());
                }
                ++n2;
            }
        }
        this.serverComb.setItems(serverNames.toArray(new String[serverNames.size()]));
        this.serverComb.select(0);
    }

    private void deleteEclipseConfigFiles(File project) {
        File[] fileArray = project.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().contentEquals(".classpath") || file.getName().contentEquals(".settings") || file.getName().contentEquals(".project")) {
                if (file.isDirectory()) {
                    FileUtil.deleteDir((File)file, (boolean)true);
                }
                file.delete();
            }
            ++n2;
        }
    }

    private void deleteSDKLegacyProjects(IPath sdkLocation) {
        String[] needDeletedPaths;
        String[] stringArray = needDeletedPaths = new String[]{"shared/portal-http-service", "webs/resources-importer-web"};
        int n = needDeletedPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = sdkLocation.append(path).toFile();
            if (file.exists()) {
                FileUtil.deleteDir((File)file, (boolean)true);
            }
            ++n2;
        }
    }

    private void deleteServiceBuilderJarFile(IProject project, IProgressMonitor monitor) {
        try {
            IFile serviceJarFile;
            IFolder docrootFolder = CoreUtil.getDefaultDocrootFolder((IProject)project);
            if (docrootFolder != null && (serviceJarFile = docrootFolder.getFile("WEB-INF/lib/" + project.getName() + "-service.jar")).exists()) {
                serviceJarFile.delete(true, monitor);
            }
        }
        catch (CoreException e) {
            ProjectUI.logError((Exception)((Object)e));
        }
    }

    private void disposeBundleCheckboxElement() {
        if (this.downloadBundleCheckbox != null && this.downloadBundleCheckbox != null) {
            this.downloadBundleCheckbox.dispose();
        }
    }

    private void disposeBundleElement() {
        if (this.bundleNameField != null && this.bundleUrlField != null) {
            this.bundleNameField.dispose();
            this.bundleNameLabel.dispose();
            this.bundleUrlField.dispose();
            this.bundleUrlLabel.dispose();
        }
    }

    private void disposeMigrateLayoutElement() {
        if (this.layoutLabel != null && this.layoutComb != null) {
            this.layoutLabel.dispose();
            this.layoutComb.dispose();
        }
    }

    private void disposeImportElement() {
        this.createSeparator.dispose();
        this.createHorizontalSpacer.dispose();
        this.importButton.dispose();
    }

    private void disposeServerEelment() {
        if (this.serverLabel != null && this.serverComb != null && this.serverButton != null) {
            this.serverLabel.dispose();
            this.serverComb.dispose();
            this.serverButton.dispose();
        }
    }

    @Override
    public int getGridLayoutCount() {
        return 2;
    }

    @Override
    public boolean getGridLayoutEqualWidth() {
        return false;
    }

    private void getLiferayBundle(IPath targetSDKLocation, IProgressMonitor monitor) throws BladeCLIException {
        StringBuilder sb = new StringBuilder();
        sb.append("-b ");
        sb.append("\"" + targetSDKLocation.toFile().getAbsolutePath() + "\" ");
        sb.append("init");
        BladeCLI.execute((String)sb.toString());
    }

    @Override
    public String getPageTitle() {
        return "Select project(s) to upgrade";
    }

    private IProjectBuilder getProjectBuilder(IProject project) throws CoreException {
        ILiferayProject liferayProject = LiferayCore.create((Object)project);
        if (liferayProject == null) {
            throw new CoreException(ProjectUI.createErrorStatus("Can't find Liferay workspace project."));
        }
        IProjectBuilder builder = (IProjectBuilder)liferayProject.adapt(IProjectBuilder.class);
        if (builder == null) {
            throw new CoreException(ProjectUI.createErrorStatus("Can't find Liferay Gradle project builder."));
        }
        return builder;
    }

    protected void importProject() throws CoreException {
        final String layout = (String)this.dataModel.getLayout().content();
        final IPath location = PathBridge.create((org.eclipse.sapphire.modeling.Path)((org.eclipse.sapphire.modeling.Path)this.dataModel.getSdkLocation().content()));
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        String newPath = "";
                        InitConfigureProjectPage.this.backup(monitor);
                        InitConfigureProjectPage.this.clearExistingProjects(location, monitor);
                        InitConfigureProjectPage.this.deleteEclipseConfigFiles(location.toFile());
                        if (InitConfigureProjectPage.this.isMavenProject(location.toPortableString())) {
                            ILiferayProjectImporter importer = LiferayCore.getImporter((String)"maven");
                            List projects = importer.importProjects(location.toPortableString(), monitor);
                            for (IProject project : projects) {
                                InitConfigureProjectPage.this.checkProjectType(project);
                            }
                        } else if (layout.equals("Upgrade to Liferay Workspace")) {
                            InitConfigureProjectPage.this.createLiferayWorkspace(location, monitor);
                            InitConfigureProjectPage.this.removeIvyPrivateSetting(location.append("plugins-sdk"));
                            newPath = InitConfigureProjectPage.this.renameProjectFolder(location, monitor);
                            IPath sdkLocation = new Path(newPath).append("plugins-sdk");
                            InitConfigureProjectPage.this.deleteSDKLegacyProjects(sdkLocation);
                            ILiferayProjectImporter importer = LiferayCore.getImporter((String)"gradle");
                            importer.importProjects(newPath, monitor);
                            if (((Boolean)InitConfigureProjectPage.this.dataModel.getDownloadBundle().content()).booleanValue()) {
                                InitConfigureProjectPage.this.createInitBundle(monitor);
                            }
                            InitConfigureProjectPage.this.importSDKProject(sdkLocation, monitor);
                            InitConfigureProjectPage.this.dataModel.setConvertLiferayWorkspace(true);
                        } else {
                            InitConfigureProjectPage.this.deleteEclipseConfigFiles(location.toFile());
                            InitConfigureProjectPage.this.copyNewSDK(location, monitor);
                            InitConfigureProjectPage.this.removeIvyPrivateSetting(location);
                            InitConfigureProjectPage.this.deleteSDKLegacyProjects(location);
                            String serverName = (String)InitConfigureProjectPage.this.dataModel.getLiferay70ServerName().content();
                            IServer server = ServerUtil.getServer((String)serverName);
                            newPath = InitConfigureProjectPage.this.renameProjectFolder(location, monitor);
                            SDK sdk = SDKUtil.createSDKFromLocation((IPath)new Path(newPath));
                            sdk.addOrUpdateServerProperties(ServerUtil.getLiferayRuntime((IServer)server).getLiferayHome());
                            SDKUtil.openAsProject((SDK)sdk, (IProgressMonitor)monitor);
                            InitConfigureProjectPage.this.importSDKProject(sdk.getLocation(), monitor);
                        }
                        InitConfigureProjectPage.this.dataModel.setImportFinished(true);
                    }
                    catch (Exception e) {
                        ProjectUI.logError(e);
                        throw new InvocationTargetException(e, e.getMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            ProjectUI.logError(e);
            throw new CoreException(StatusBridge.create((Status)Status.createErrorStatus((String)e.getMessage(), (Throwable)e)));
        }
    }

    private void importSDKProject(IPath targetSDKLocation, IProgressMonitor monitor) {
        ArrayList eclipseProjectFiles = new ArrayList();
        ArrayList liferayProjectDirs = new ArrayList();
        if (ProjectUtil.collectSDKProjectsFromDirectory(eclipseProjectFiles, liferayProjectDirs, (File)targetSDKLocation.toFile(), null, (boolean)true, (IProgressMonitor)monitor)) {
            IProject importProject2;
            for (File project : liferayProjectDirs) {
                try {
                    this.deleteEclipseConfigFiles(project);
                    importProject2 = ProjectImportUtil.importProject((IPath)new Path(project.getPath()), (IProgressMonitor)monitor, null);
                    if (importProject2 != null && importProject2.isAccessible() && importProject2.isOpen()) {
                        this.checkProjectType(importProject2);
                        this.deleteServiceBuilderJarFile(importProject2, monitor);
                    }
                    if (ProjectUtil.isExtProject((IProject)importProject2) || ProjectUtil.isThemeProject((IProject)importProject2)) {
                        importProject2.delete(false, true, monitor);
                    }
                    this.checkAndConfigureIvy(importProject2);
                }
                catch (CoreException importProject2) {
                    // empty catch block
                }
            }
            for (File project : eclipseProjectFiles) {
                try {
                    this.deleteEclipseConfigFiles(project.getParentFile());
                    importProject2 = ProjectImportUtil.importProject((IPath)new Path(project.getParent()), (IProgressMonitor)monitor, null);
                    if (importProject2 != null && importProject2.isAccessible() && importProject2.isOpen()) {
                        this.checkProjectType(importProject2);
                        this.deleteServiceBuilderJarFile(importProject2, monitor);
                    }
                    if (ProjectUtil.isExtProject((IProject)importProject2) || ProjectUtil.isThemeProject((IProject)importProject2)) {
                        importProject2.delete(false, true, monitor);
                    }
                    this.checkAndConfigureIvy(importProject2);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void onSelectionChanged(int targetSelection) {
        if (targetSelection == 1) {
            this.startCheckThread();
        }
    }

    private void removeIvyPrivateSetting(IPath sdkLocation) throws CoreException {
        IPath ivySettingPath = sdkLocation.append("ivy-settings.xml");
        File ivySettingFile = ivySettingPath.toFile();
        SAXBuilder builder = new SAXBuilder(false);
        builder.setValidation(false);
        builder.setFeature("http://xml.org/sax/features/validation", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileInputStream ivyInput = new FileInputStream(ivySettingFile);){
                if (ivySettingFile.exists()) {
                    Document doc = builder.build((InputStream)ivyInput);
                    Element itemRem = null;
                    Element elementRoot = doc.getRootElement();
                    List resolversElements = elementRoot.getChildren("resolvers");
                    for (Element resolversElement : resolversElements) {
                        List chainElements = resolversElement.getChildren("chain");
                        for (Element chainElement : chainElements) {
                            List resolverElements = chainElement.getChildren("resolver");
                            Iterator resolverIterator = resolverElements.iterator();
                            while (resolverIterator.hasNext()) {
                                Element resolverItem = (Element)resolverIterator.next();
                                String resolverRefItem = resolverItem.getAttributeValue("ref");
                                if (!resolverRefItem.equals("liferay-private")) continue;
                                resolverIterator.remove();
                                itemRem = resolverItem;
                            }
                        }
                        elementRoot.removeContent(itemRem);
                        List ibiblioElements = resolversElement.getChildren("ibiblio");
                        Iterator ibiblioIterator = ibiblioElements.iterator();
                        while (ibiblioIterator.hasNext()) {
                            Element ibiblioElement = (Element)ibiblioIterator.next();
                            String liferayPrivateName = ibiblioElement.getAttributeValue("name");
                            if (!liferayPrivateName.equals("liferay-private")) continue;
                            ibiblioIterator.remove();
                            itemRem = ibiblioElement;
                        }
                        elementRoot.removeContent(itemRem);
                    }
                    this.saveXML(ivySettingFile, doc);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException | JDOMException e) {
            ProjectUI.logError((Exception)e);
            throw new CoreException(StatusBridge.create((Status)Status.createErrorStatus((String)"Failed to remove Liferay private url configuration of ivy-settings.xml.", (Throwable)e)));
        }
    }

    private String renameProjectFolder(IPath targetSDKLocation, IProgressMonitor monitor) throws CoreException {
        return targetSDKLocation.toString();
    }

    private void saveSettings() {
        this.dataModel.setHasExt(false);
        this.dataModel.setHasHook(false);
        this.dataModel.setHasLayout(false);
        this.dataModel.setHasPortlet(false);
        this.dataModel.setHasServiceBuilder(false);
        this.dataModel.setHasTheme(false);
        this.dataModel.setHasWeb(false);
        if (this.bundleNameField != null && !this.bundleNameField.isDisposed()) {
            this.dataModel.setLiferay70ServerName(this.bundleNameField.getText());
        }
        if (this.serverComb != null && !this.serverComb.isDisposed()) {
            this.dataModel.setLiferay70ServerName(this.serverComb.getText());
        }
        SDK sdk = SDKUtil.createSDKFromLocation((IPath)new Path(this.dirField.getText()));
        try {
            if (sdk != null) {
                String liferay62ServerLocation = (String)sdk.getBuildProperties(true).get("app.server.parent.dir");
                this.dataModel.setLiferay62ServerLocation(liferay62ServerLocation);
            }
        }
        catch (Exception xe) {
            ProjectUI.logError(xe);
        }
    }

    private void saveXML(File templateFile, Document doc) throws CoreException {
        XMLOutputter out = new XMLOutputter();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fos = new FileOutputStream(templateFile);){
                out.output(doc, (OutputStream)fos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            ProjectUI.logError(e);
            throw new CoreException(StatusBridge.create((Status)Status.createErrorStatus((String)"Failed to save change for ivy-settings.xml.", (Throwable)e)));
        }
    }

    public void serverAdded(final IServer server) {
        UIUtil.async((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean serverExisted = false;
                if (InitConfigureProjectPage.this.serverComb != null && !InitConfigureProjectPage.this.serverComb.isDisposed()) {
                    String[] serverNames = InitConfigureProjectPage.this.serverComb.getItems();
                    ArrayList<String> serverList = new ArrayList<String>(Arrays.asList(serverNames));
                    for (String serverName : serverList) {
                        if (!server.getName().equals(serverName)) continue;
                        serverExisted = true;
                    }
                    if (!serverExisted) {
                        serverList.add(server.getName());
                        InitConfigureProjectPage.this.serverComb.setItems(serverList.toArray(new String[serverList.size()]));
                        InitConfigureProjectPage.this.serverComb.select(serverList.size() - 1);
                    }
                    InitConfigureProjectPage.this.startCheckThread();
                }
            }
        });
    }

    public void serverChanged(IServer server) {
    }

    public void serverRemoved(final IServer server) {
        UIUtil.async((Runnable)new Runnable(){

            @Override
            public void run() {
                if (InitConfigureProjectPage.this.serverComb != null && !InitConfigureProjectPage.this.serverComb.isDisposed()) {
                    String[] serverNames = InitConfigureProjectPage.this.serverComb.getItems();
                    ArrayList<String> serverList = new ArrayList<String>(Arrays.asList(serverNames));
                    Iterator serverNameiterator = serverList.iterator();
                    while (serverNameiterator.hasNext()) {
                        String serverName = (String)serverNameiterator.next();
                        if (!server.getName().equals(serverName)) continue;
                        serverNameiterator.remove();
                    }
                    InitConfigureProjectPage.this.serverComb.setItems(serverList.toArray(new String[serverList.size()]));
                    InitConfigureProjectPage.this.serverComb.select(0);
                    InitConfigureProjectPage.this.startCheckThread();
                }
            }
        });
    }

    private void startCheckThread() {
        Thread t = new Thread(){

            @Override
            public void run() {
                InitConfigureProjectPage.this.validate();
            }
        };
        t.start();
    }

    private void validate() {
        UIUtil.async((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean inputValidation = true;
                boolean layoutValidation = true;
                boolean downloadBundle = (Boolean)InitConfigureProjectPage.this.dataModel.getDownloadBundle().content();
                String bundUrl = (String)InitConfigureProjectPage.this.dataModel.getBundleUrl().content();
                String message = "ok";
                PageValidateEvent pe = new PageValidateEvent();
                pe.setType(PageValidateEvent.ERROR);
                if (!InitConfigureProjectPage.this.sdkValidation.compute().ok()) {
                    message = InitConfigureProjectPage.this.sdkValidation.compute().message();
                    inputValidation = false;
                } else if (!InitConfigureProjectPage.this.dataModel.getBackupLocation().validation().ok()) {
                    message = InitConfigureProjectPage.this.dataModel.getBackupLocation().validation().message();
                    inputValidation = false;
                } else {
                    inputValidation = true;
                }
                if (!InitConfigureProjectPage.this.layoutComb.isDisposed()) {
                    if (InitConfigureProjectPage.this.layoutComb.getSelectionIndex() == 1) {
                        int itemCount = InitConfigureProjectPage.this.serverComb.getItemCount();
                        if (itemCount < 1) {
                            message = "You should add at least one Liferay 7 portal bundle.";
                            layoutValidation = false;
                        }
                    } else if (InitConfigureProjectPage.this.layoutComb.getSelectionIndex() == 0) {
                        boolean liferayWorksapceValidation = true;
                        String workspaceValidationMessage = "ok";
                        try {
                            if (LiferayWorkspaceUtil.hasWorkspace()) {
                                liferayWorksapceValidation = false;
                                workspaceValidationMessage = LiferayWorkspaceUtil.hasLiferayWorkspaceMsg;
                            }
                        }
                        catch (CoreException e) {
                            liferayWorksapceValidation = false;
                            workspaceValidationMessage = e.getMessage();
                        }
                        if (!liferayWorksapceValidation && inputValidation) {
                            message = workspaceValidationMessage;
                            layoutValidation = false;
                        } else if (downloadBundle && !InitConfigureProjectPage.this.bundleNameValidation.compute().ok()) {
                            message = InitConfigureProjectPage.this.bundleNameValidation.compute().message();
                            layoutValidation = false;
                        } else if (downloadBundle && bundUrl != null && bundUrl.length() > 0 && !InitConfigureProjectPage.this.bundleUrlValidation.compute().ok()) {
                            message = InitConfigureProjectPage.this.bundleUrlValidation.compute().message();
                            layoutValidation = false;
                        } else {
                            layoutValidation = true;
                        }
                    }
                }
                if (((Boolean)InitConfigureProjectPage.this.dataModel.getImportFinished().content()).booleanValue()) {
                    message = "Import has finished. If you want to reimport, please click swirling arrows in the view.";
                    pe.setType(PageValidateEvent.WARNING);
                    inputValidation = false;
                }
                pe.setMessage(message);
                InitConfigureProjectPage.this.triggerValidationEvent(pe);
                InitConfigureProjectPage.this.validationResult = layoutValidation && inputValidation;
                InitConfigureProjectPage.this.importButton.setEnabled(InitConfigureProjectPage.this.validationResult);
            }
        });
    }

    private boolean isPageValidate() {
        return this.validationResult;
    }

    private class LiferayUpgradeValidationListener
    extends org.eclipse.sapphire.Listener {
        private LiferayUpgradeValidationListener() {
        }

        public void handle(Event event) {
            if (!(event instanceof ValuePropertyContentEvent)) {
                return;
            }
            Property property = ((ValuePropertyContentEvent)event).property();
            if (!property.name().equals("SdkLocation")) {
                InitConfigureProjectPage.this.startCheckThread();
                return;
            }
            org.eclipse.sapphire.modeling.Path path = (org.eclipse.sapphire.modeling.Path)InitConfigureProjectPage.this.dataModel.getSdkLocation().content();
            if (path == null || !InitConfigureProjectPage.this.sdkValidation.compute().ok()) {
                if (!InitConfigureProjectPage.this.layoutComb.isDisposed()) {
                    InitConfigureProjectPage.this.layoutComb.setEnabled(true);
                }
                InitConfigureProjectPage.this.startCheckThread();
                return;
            }
            if (InitConfigureProjectPage.this.isMavenProject(path.toPortableString())) {
                InitConfigureProjectPage.this.disposeBundleCheckboxElement();
                InitConfigureProjectPage.this.disposeBundleElement();
                InitConfigureProjectPage.this.disposeServerEelment();
                InitConfigureProjectPage.this.disposeMigrateLayoutElement();
                InitConfigureProjectPage.this.pageParent.layout();
            } else {
                InitConfigureProjectPage.this.disposeMigrateLayoutElement();
                InitConfigureProjectPage.this.createMigrateLayoutElement();
                InitConfigureProjectPage.this.createBundleControl();
                InitConfigureProjectPage.this.pageParent.layout();
                String version = SDKUtil.createSDKFromLocation((IPath)PathBridge.create((org.eclipse.sapphire.modeling.Path)path)).getVersion();
                if (version != null && new Version(version).compareTo(new Version("7.0.0")) >= 0) {
                    UIUtil.async((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (InitConfigureProjectPage.this.layoutComb.getSelectionIndex() != 0) {
                                InitConfigureProjectPage.this.layoutComb.select(1);
                            }
                            InitConfigureProjectPage.this.layoutComb.setEnabled(false);
                            ((LiferayUpgradeValidationListener)LiferayUpgradeValidationListener.this).InitConfigureProjectPage.this.dataModel.setLayout(InitConfigureProjectPage.this.layoutComb.getText());
                        }
                    });
                } else {
                    InitConfigureProjectPage.this.layoutComb.setEnabled(true);
                }
            }
            InitConfigureProjectPage.this.startCheckThread();
        }
    }
}

