/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.upgrade.animated;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.project.core.ProjectCore;
import com.liferay.ide.project.ui.upgrade.animated.LiferayUpgradeDataModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;

public class UpgradeSettingsUtil {
    private static File codeUpgradeFile;
    private static Properties codeUpgradeProperties;

    public static String getProperty(String key) {
        return codeUpgradeProperties.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return codeUpgradeProperties.getProperty(key, defaultValue);
    }

    public static void init(LiferayUpgradeDataModel dataModel) {
        IPath stateLocation = ProjectCore.getDefault().getStateLocation();
        File stateDir = stateLocation.toFile();
        codeUpgradeFile = new File(stateDir, "liferay-code-upgrade.properties");
        if (!codeUpgradeFile.exists()) {
            try {
                codeUpgradeFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (codeUpgradeProperties == null) {
            codeUpgradeProperties = new Properties();
            try {
                Throwable throwable = null;
                Object var4_7 = null;
                try (FileInputStream in = new FileInputStream(codeUpgradeFile);){
                    codeUpgradeProperties.load(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        UpgradeSettingsUtil.retrieveProperties(dataModel);
    }

    public static void resetStoreProperties() {
        if (codeUpgradeProperties != null) {
            codeUpgradeProperties.clear();
            UpgradeSettingsUtil.storeProperty(null, null);
        }
    }

    public static void retrieveProperties(LiferayUpgradeDataModel dataModel) {
        String liferay70ServerName = UpgradeSettingsUtil.getProperty("Liferay70ServerName");
        String liferay62ServerLocation = UpgradeSettingsUtil.getProperty("Liferay62ServerLocation");
        if (!CoreUtil.isNullOrEmpty((String)liferay62ServerLocation)) {
            dataModel.setLiferay62ServerLocation(liferay62ServerLocation);
        }
        if (!CoreUtil.isNullOrEmpty((String)liferay70ServerName)) {
            dataModel.setLiferay70ServerName(liferay70ServerName);
        }
        dataModel.setHasMavenProject(Boolean.parseBoolean(UpgradeSettingsUtil.getProperty("HasMavenProject", "false")));
        dataModel.setHasPortlet(Boolean.parseBoolean(UpgradeSettingsUtil.getProperty("HasPortlet", "false")));
        dataModel.setHasServiceBuilder(Boolean.parseBoolean(UpgradeSettingsUtil.getProperty("HasServiceBuilder", "false")));
        dataModel.setHasHook(Boolean.parseBoolean(UpgradeSettingsUtil.getProperty("HasHook", "false")));
        dataModel.setHasLayout(Boolean.parseBoolean(UpgradeSettingsUtil.getProperty("HasLayout", "false")));
        dataModel.setHasTheme(Boolean.parseBoolean(UpgradeSettingsUtil.getProperty("HasTheme", "false")));
        dataModel.setHasExt(Boolean.parseBoolean(UpgradeSettingsUtil.getProperty("HasExt", "false")));
        dataModel.setHasWeb(Boolean.parseBoolean(UpgradeSettingsUtil.getProperty("HasWeb", "false")));
        dataModel.setConvertLiferayWorkspace(Boolean.parseBoolean(UpgradeSettingsUtil.getProperty("ConvertLiferayWorkspace", "false")));
        dataModel.setImportFinished(Boolean.parseBoolean(UpgradeSettingsUtil.getProperty("ImportFinished", "false")));
    }

    public static void storeProperty(Object key, Object value) {
        if (key != null) {
            codeUpgradeProperties.setProperty(String.valueOf(key), String.valueOf(value));
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(codeUpgradeFile);){
                codeUpgradeProperties.store(out, "");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

