/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.wizard.PossibleValuesAuxTextProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.services.ValueImageService;
import org.eclipse.sapphire.services.ValueLabelService;
import org.eclipse.sapphire.ui.forms.swt.AbstractBinding;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.RadioButtonsGroup;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public final class PossibleValuesRadioButtonsGroupBinding<T>
extends AbstractBinding {
    @Text(value="<value not set>")
    private static LocalizableText nullValueLabel;
    private RadioButtonsGroup buttonsGroup;
    private Button badValueButton;
    private List<String> possibleValues;

    static {
        LocalizableText.init(PossibleValuesRadioButtonsGroupBinding.class);
    }

    public PossibleValuesRadioButtonsGroupBinding(PropertyEditorPresentation propertyEditorPresentation, RadioButtonsGroup buttonsGroup) {
        super(propertyEditorPresentation, (Control)buttonsGroup);
    }

    protected void initialize(PropertyEditorPresentation propertyEditorPresentation, Control control) {
        super.initialize(propertyEditorPresentation, control);
        PossibleValuesService possibleValuesService = (PossibleValuesService)propertyEditorPresentation.property().service(PossibleValuesService.class);
        this.possibleValues = new ArrayList<String>(possibleValuesService.values());
        this.buttonsGroup = (RadioButtonsGroup)control;
        Property property = propertyEditorPresentation.property();
        String auxTextProviderName = (String)propertyEditorPresentation.part().getRenderingHint("possible.values.aux.text.provider", null);
        PossibleValuesAuxTextProvider auxTextProvider = null;
        if (auxTextProviderName != null) {
            try {
                Class providerClass = ProjectUI.getDefault().getBundle().loadClass(auxTextProviderName);
                auxTextProvider = (PossibleValuesAuxTextProvider)providerClass.newInstance();
            }
            catch (Exception providerClass) {
                // empty catch block
            }
        }
        for (String possibleValue : this.possibleValues) {
            ValueLabelService labelService = (ValueLabelService)property.service(ValueLabelService.class);
            String possibleValueText = labelService.provide(possibleValue);
            String auxText = (String)propertyEditorPresentation.part().getRenderingHint("aux.text." + possibleValue, null);
            if (auxText == null && auxTextProvider != null) {
                auxText = auxTextProvider.getAuxText(this.element(), property.definition(), possibleValue);
            }
            ValueImageService imageService = (ValueImageService)property.service(ValueImageService.class);
            ImageData imageData = imageService.provide(possibleValue);
            Image image = this.presentation().resources().image(imageData);
            Button button = this.buttonsGroup.addRadioButton(possibleValueText, auxText, image);
            button.setData((Object)possibleValue);
        }
        this.buttonsGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PossibleValuesRadioButtonsGroupBinding.this.updateModel();
                PossibleValuesRadioButtonsGroupBinding.this.updateTargetAttributes();
            }
        });
    }

    private int getSelectionIndex() {
        return this.buttonsGroup.getSelectionIndex();
    }

    private void setSelectionIndex(int index) {
        this.buttonsGroup.setSelectionIndex(index);
    }

    private void createMalformedItem(String label) {
        if (this.badValueButton == null) {
            this.badValueButton = this.buttonsGroup.addRadioButton("");
        }
        this.badValueButton.setText(label);
        this.presentation().layout();
    }

    private void removeMalformedItem() {
        if (!this.buttonsGroup.isDisposed() && this.badValueButton != null) {
            this.badValueButton.dispose();
            this.badValueButton = null;
            this.presentation().layout();
        }
    }

    public Value<T> property() {
        return (Value)super.property();
    }

    protected final void doUpdateModel() {
        int index = this.getSelectionIndex();
        if (index >= 0 && index < this.possibleValues.size()) {
            this.property().write((Object)this.possibleValues.get(index));
            this.removeMalformedItem();
        }
    }

    protected final void doUpdateTarget() {
        int existingSelection = this.getSelectionIndex();
        Value<T> value = this.property();
        int newSelection = this.possibleValues.size();
        if (!value.malformed()) {
            Object newValue = value.content(true);
            int i = 0;
            int n = this.possibleValues.size();
            while (i < n) {
                if (this.possibleValues.get(i).equals(newValue.toString())) {
                    newSelection = i;
                    break;
                }
                ++i;
            }
        }
        if (newSelection == this.possibleValues.size()) {
            String newValueString = value.text(true);
            String label = newValueString == null ? nullValueLabel.text() : newValueString;
            this.createMalformedItem(label);
        } else {
            this.removeMalformedItem();
        }
        if (existingSelection != newSelection) {
            this.setSelectionIndex(newSelection);
        }
    }
}

