/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.project.ui.wizard;

import com.liferay.ide.project.core.ProjectRecord;
import com.liferay.ide.project.core.model.NamedItem;
import com.liferay.ide.project.core.model.PluginType;
import com.liferay.ide.project.core.model.ProjectNamedItem;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.ProjectUI;
import com.liferay.ide.project.ui.wizard.AbstractCheckboxCustomPart;
import com.liferay.ide.project.ui.wizard.ElementLabelProvider;
import com.liferay.ide.ui.util.UIUtil;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.sapphire.ElementList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public abstract class ProjectsCheckboxCustomPart
extends AbstractCheckboxCustomPart {
    protected ProjectCheckboxElement[] checkboxElements;

    @Override
    protected void checkAndUpdateCheckboxElement() {
        List<ProjectCheckboxElement> checkboxElementList = this.getInitItemsList();
        this.checkboxElements = checkboxElementList.toArray(new ProjectCheckboxElement[checkboxElementList.size()]);
        UIUtil.async((Runnable)new Runnable(){

            @Override
            public void run() {
                ProjectsCheckboxCustomPart.this.checkBoxViewer.setInput((Object)ProjectsCheckboxCustomPart.this.checkboxElements);
                ElementList<ProjectNamedItem> selectedElements = ProjectsCheckboxCustomPart.this.getSelectedElements();
                block0: for (NamedItem projectItem : selectedElements) {
                    ProjectCheckboxElement[] projectCheckboxElementArray = ProjectsCheckboxCustomPart.this.checkboxElements;
                    int n = ProjectsCheckboxCustomPart.this.checkboxElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ProjectCheckboxElement checkboxElement = projectCheckboxElementArray[n2];
                        if (checkboxElement.name.equals(projectItem.getName().content())) {
                            ProjectsCheckboxCustomPart.this.checkBoxViewer.setChecked((Object)checkboxElement, true);
                            continue block0;
                        }
                        ++n2;
                    }
                }
                ProjectsCheckboxCustomPart.this.updateValidation();
            }
        });
    }

    protected abstract ElementList<ProjectNamedItem> getCheckboxList();

    protected abstract List<ProjectCheckboxElement> getInitItemsList();

    protected abstract ElementList<ProjectNamedItem> getSelectedElements();

    @Override
    protected void handleCheckStateChangedEvent(CheckStateChangedEvent event) {
        if (event.getSource().equals(this.checkBoxViewer)) {
            ElementList<ProjectNamedItem> selectedElements;
            Object element = event.getElement();
            if (element instanceof AbstractCheckboxCustomPart.CheckboxElement) {
                this.checkBoxViewer.setGrayed(element, false);
            }
            if ((selectedElements = this.getSelectedElements()) != null) {
                selectedElements.clear();
                ProjectCheckboxElement[] projectCheckboxElementArray = this.checkboxElements;
                int n = this.checkboxElements.length;
                int n2 = 0;
                while (n2 < n) {
                    ProjectCheckboxElement checkboxElement = projectCheckboxElementArray[n2];
                    if (this.checkBoxViewer.getChecked((Object)checkboxElement)) {
                        ProjectNamedItem newProjectItem = (ProjectNamedItem)selectedElements.insert();
                        newProjectItem.setName(checkboxElement.name);
                        newProjectItem.setExtDesc(checkboxElement.context);
                        newProjectItem.setLocation(checkboxElement.location);
                    }
                    ++n2;
                }
            }
            this.updateValidation();
        }
    }

    @Override
    protected void handleDeSelectAllEvent() {
        ProjectCheckboxElement[] projectCheckboxElementArray = this.checkboxElements;
        int n = this.checkboxElements.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectCheckboxElement checkboxElement = projectCheckboxElementArray[n2];
            this.checkBoxViewer.setChecked((Object)checkboxElement, false);
            ++n2;
        }
        this.getCheckboxList().clear();
        this.updateValidation();
    }

    @Override
    protected void handleSelectAllEvent() {
        ProjectCheckboxElement[] projectCheckboxElementArray = this.checkboxElements;
        int n = this.checkboxElements.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectCheckboxElement checkboxElement = projectCheckboxElementArray[n2];
            this.checkBoxViewer.setChecked((Object)checkboxElement, true);
            ElementList<ProjectNamedItem> projectItems = this.getCheckboxList();
            if (!projectItems.contains((Object)checkboxElement)) {
                ProjectNamedItem projectItem = (ProjectNamedItem)projectItems.insert();
                projectItem.setName(checkboxElement.name);
                projectItem.setExtDesc(checkboxElement.context);
                projectItem.setLocation(checkboxElement.location);
            }
            ++n2;
        }
        this.updateValidation();
    }

    class ProjectCheckboxElement
    extends AbstractCheckboxCustomPart.CheckboxElement {
        public final String location;

        public ProjectCheckboxElement(String name, String context, String location) {
            super(ProjectsCheckboxCustomPart.this, name, context);
            this.location = location;
        }
    }

    class SDKImportProjectsLabelProvider
    extends ElementLabelProvider
    implements IColorProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private static final String GREY_COLOR = "sdk import projects";
        private final ColorRegistry COLOR_REGISTRY = JFaceResources.getColorRegistry();
        private final StyledString.Styler GREYED_STYLER;

        public SDKImportProjectsLabelProvider() {
            this.COLOR_REGISTRY.put(GREY_COLOR, new RGB(128, 128, 128));
            this.GREYED_STYLER = StyledString.createColorRegistryStyler((String)GREY_COLOR, null);
        }

        @Override
        public Image getImage(Object element) {
            String projectLocation;
            ProjectRecord projectRecord;
            if (element instanceof ProjectCheckboxElement && (projectRecord = ProjectUtil.getProjectRecordForDir((String)(projectLocation = ((ProjectCheckboxElement)element).location))) != null) {
                IPath location = projectRecord.getProjectLocation();
                String suffix = ProjectUtil.getLiferayPluginType((String)location.toPortableString());
                return this.getImageRegistry().get(suffix);
            }
            return null;
        }

        @Override
        public StyledString getStyledText(Object element) {
            if (element instanceof ProjectCheckboxElement) {
                String srcLableString = ((ProjectCheckboxElement)element).context;
                String projectName = ((ProjectCheckboxElement)element).name;
                StyledString styled = new StyledString(projectName);
                return StyledCellLabelProvider.styleDecoratedString((String)srcLableString, (StyledString.Styler)this.GREYED_STYLER, (StyledString)styled);
            }
            return new StyledString(((ProjectCheckboxElement)element).context);
        }

        @Override
        protected void initalizeImageRegistry(ImageRegistry imageRegistry) {
            imageRegistry.put(PluginType.portlet.name(), ProjectUI.imageDescriptorFromPlugin((String)"com.liferay.ide.project.ui", (String)"/icons/e16/portlet.png"));
            imageRegistry.put(PluginType.hook.name(), ProjectUI.imageDescriptorFromPlugin((String)"com.liferay.ide.project.ui", (String)"/icons/e16/hook.png"));
            imageRegistry.put(PluginType.layouttpl.name(), ProjectUI.imageDescriptorFromPlugin((String)"com.liferay.ide.project.ui", (String)"/icons/e16/layout.png"));
            imageRegistry.put(PluginType.servicebuilder.name(), ProjectUI.imageDescriptorFromPlugin((String)"com.liferay.ide.project.ui", (String)"/icons/e16/portlet.png"));
            imageRegistry.put(PluginType.ext.name(), ProjectUI.imageDescriptorFromPlugin((String)"com.liferay.ide.project.ui", (String)"/icons/e16/ext.png"));
            imageRegistry.put(PluginType.theme.name(), ProjectUI.imageDescriptorFromPlugin((String)"com.liferay.ide.project.ui", (String)"/icons/e16/theme.png"));
            imageRegistry.put(PluginType.web.name(), ProjectUI.imageDescriptorFromPlugin((String)"com.liferay.ide.project.ui", (String)"/icons/e16/web.png"));
        }
    }
}

