/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core;

import com.liferay.ide.core.AbstractDefaultHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.XMLContentDescriber;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractContentDescriber
extends XMLContentDescriber
implements IExecutableExtension {
    public int describe(InputStream contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        if (super.describe(contents, description) == 0) {
            return 0;
        }
        contents.reset();
        return this.checkCriteria(new InputSource(contents));
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private int checkCriteria(InputSource contents) throws IOException {
        AbstractDefaultHandler contentHandler = this.createDefaultHandler();
        try {
            if (!contentHandler.parseContents(contents)) {
                return 1;
            }
        }
        catch (SAXException e) {
            return 1;
        }
        catch (ParserConfigurationException e) {
            String message = "Internal Error: XML parser configuration error during content description for Service Builder files";
            throw new RuntimeException(message);
        }
        if (contentHandler.hasDTD()) {
            if (contentHandler.hasTopLevelElement()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    protected abstract AbstractDefaultHandler createDefaultHandler();
}

