/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.core;

import com.liferay.ide.core.AbstractLiferayProjectImporter;
import com.liferay.ide.core.ExtensionReader;
import com.liferay.ide.core.ILiferayProjectImporter;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;

public class LiferayProjectImporterReader
extends ExtensionReader<ILiferayProjectImporter> {
    private static final String ATTRIBUTE_BUILDTYPE = "buildType";
    private static final String ATTRIBUTE_PRIORITY = "priority";
    private static final String EXTENSION = "liferayProjectImporters";
    private static final String PROVIDER_ELEMENT = "liferayProjectImporter";

    public LiferayProjectImporterReader() {
        super("com.liferay.ide.core", EXTENSION, PROVIDER_ELEMENT);
    }

    public ILiferayProjectImporter[] getImporters() {
        ILiferayProjectImporter[] importers = this.getExtensions().toArray(new ILiferayProjectImporter[0]);
        Arrays.sort(importers, new Comparator<ILiferayProjectImporter>(){

            @Override
            public int compare(ILiferayProjectImporter importer1, ILiferayProjectImporter importer2) {
                return importer1.getPriority() > importer2.getPriority() ? 1 : -1;
            }
        });
        return importers;
    }

    @Override
    protected ILiferayProjectImporter initElement(IConfigurationElement configElement, ILiferayProjectImporter importer) {
        String buildType = configElement.getAttribute(ATTRIBUTE_BUILDTYPE);
        String priority = configElement.getAttribute(ATTRIBUTE_PRIORITY);
        AbstractLiferayProjectImporter projectImporter = (AbstractLiferayProjectImporter)importer;
        projectImporter.setBuildType(buildType);
        projectImporter.setPriority(Integer.valueOf(priority));
        return importer;
    }

    public ILiferayProjectImporter getImporter(String buildType) {
        ILiferayProjectImporter[] importers;
        ILiferayProjectImporter retval = null;
        ILiferayProjectImporter[] iLiferayProjectImporterArray = importers = this.getImporters();
        int n = importers.length;
        int n2 = 0;
        while (n2 < n) {
            ILiferayProjectImporter importer = iLiferayProjectImporterArray[n2];
            if (importer.getBuildType().equals(buildType)) {
                retval = importer;
            }
            ++n2;
        }
        return retval;
    }
}

