/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileListing;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.server.util.LiferayPortalValueLoader;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractPortalBundle
implements PortalBundle {
    private static final String CONFIG_TYPE_SERVER = "server";
    private static final String CONFIG_TYPE_VERSION = "version";
    private static final Version MANIFEST_VERSION_REQUIRED = ILiferayConstants.V700;
    private static boolean clearedConfigInfoCacheOnce = false;
    protected IPath autoDeployPath;
    protected IPath liferayHome;
    protected IPath modulesPath;
    protected IPath bundlePath;

    public AbstractPortalBundle(IPath path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        this.bundlePath = path;
        this.liferayHome = this.bundlePath.append("..");
        this.autoDeployPath = this.liferayHome.append("deploy");
        this.modulesPath = this.liferayHome.append("osgi");
    }

    public AbstractPortalBundle(Map<String, String> appServerProperties) {
        if (appServerProperties == null) {
            throw new IllegalArgumentException("bundle parameters cannot be null");
        }
        String appServerPath = appServerProperties.get("app.server.dir");
        String appServerDeployPath = appServerProperties.get("app.server.deploy.dir");
        String appServerParentPath = appServerProperties.get("app.server.parent.dir");
        this.bundlePath = new Path(appServerPath);
        this.liferayHome = new Path(appServerParentPath);
        this.autoDeployPath = new Path(appServerDeployPath);
        this.modulesPath = null;
    }

    @Override
    public IPath getAppServerDir() {
        return this.bundlePath;
    }

    @Override
    public IPath[] getBundleDependencyJars() {
        ArrayList<Path> libs = new ArrayList<Path>();
        IPath bundleLibPath = this.getAppServerLibDir();
        try {
            List libFiles = FileListing.getFileListing((File)new File(bundleLibPath.toOSString()));
            for (File lib : libFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return libs.toArray(new IPath[libs.size()]);
    }

    protected abstract IPath getAppServerLibDir();

    protected abstract int getDefaultJMXRemotePort();

    public String[] getHookSupportedProperties() {
        IPath portalDir = this.getAppServerPortalDir();
        IPath[] extraLibs = this.getBundleDependencyJars();
        return new LiferayPortalValueLoader(portalDir, extraLibs).loadHookPropertiesFromClass();
    }

    protected String getHttpPortValue(File xmlFile, String tagName, String attriName, String attriValue, String targetName) {
        DocumentBuilder db = null;
        DocumentBuilderFactory dbf = null;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
            Document document = db.parse(xmlFile);
            NodeList connectorNodes = document.getElementsByTagName(tagName);
            int i = 0;
            while (i < connectorNodes.getLength()) {
                Node node = connectorNodes.item(i);
                NamedNodeMap attributes = node.getAttributes();
                Node protocolNode = attributes.getNamedItem(attriName);
                if (protocolNode != null && protocolNode.getNodeValue().equals(attriValue)) {
                    Node portNode = attributes.getNamedItem(targetName);
                    return portNode.getNodeValue();
                }
                ++i;
            }
        }
        catch (Exception e) {
            LiferayServerCore.logError(e);
        }
        return null;
    }

    @Override
    public int getJmxRemotePort() {
        return this.getDefaultJMXRemotePort();
    }

    @Override
    public IPath getAutoDeployPath() {
        return this.autoDeployPath;
    }

    @Override
    public IPath getModulesPath() {
        return this.modulesPath;
    }

    @Override
    public IPath getLiferayHome() {
        return this.liferayHome;
    }

    public String getVersion() {
        return this.getPortalVersion(this.getAppServerPortalDir(), this.getBundleDependencyJars());
    }

    @Override
    public IPath getOSGiBundlesDir() {
        IPath retval = null;
        if (this.liferayHome != null) {
            retval = this.liferayHome.append("osgi");
        }
        return retval;
    }

    public Properties getPortletCategories() {
        return ServerUtil.getPortletCategories(this.getAppServerPortalDir());
    }

    public Properties getPortletEntryCategories() {
        return ServerUtil.getEntryCategories(this.getAppServerPortalDir(), this.getVersion());
    }

    private IPath getConfigInfoPath(String configType) {
        IPath configInfoPath = null;
        if (configType.equals(CONFIG_TYPE_VERSION)) {
            configInfoPath = LiferayServerCore.getDefault().getStateLocation().append("version.properties");
        } else if (configType.equals(CONFIG_TYPE_SERVER)) {
            configInfoPath = LiferayServerCore.getDefault().getStateLocation().append("serverInfos.properties");
        }
        if (!clearedConfigInfoCacheOnce) {
            configInfoPath.toFile().delete();
            clearedConfigInfoCacheOnce = true;
        }
        return configInfoPath;
    }

    private String getConfigInfoFromCache(String configType, IPath portalDir) {
        block13: {
            File configInfoFile = this.getConfigInfoPath(configType).toFile();
            String portalDirKey = CoreUtil.createStringDigest((String)portalDir.toPortableString());
            Properties properties = new Properties();
            if (configInfoFile.exists()) {
                try {
                    Throwable throwable = null;
                    Object var7_9 = null;
                    try (FileInputStream fileInput = new FileInputStream(configInfoFile);){
                        properties.load(fileInput);
                        String configInfo = (String)properties.get(portalDirKey);
                        if (CoreUtil.isNullOrEmpty((String)configInfo)) break block13;
                        return configInfo;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    LiferayServerCore.logError(e);
                }
            }
        }
        return null;
    }

    private String getPortalVersion(IPath portalDir, IPath[] extraLib) {
        String version = this.getConfigInfoFromCache(CONFIG_TYPE_VERSION, portalDir);
        if (version == null) {
            LiferayPortalValueLoader loader;
            Version loadedVersion;
            version = this.getConfigInfoFromManifest(CONFIG_TYPE_VERSION, portalDir);
            if (version == null && (loadedVersion = (loader = new LiferayPortalValueLoader(portalDir, extraLib)).loadVersionFromClass()) != null) {
                version = loadedVersion.toString();
            }
            if (version != null) {
                this.saveConfigInfoIntoCache(CONFIG_TYPE_VERSION, version, portalDir);
            }
        }
        return version;
    }

    private String getConfigInfoFromManifest(String configType, IPath portalDir) {
        File implJar = portalDir.append("/WEB-INF/lib/portal-impl.jar").toFile();
        String version = null;
        String serverInfo = null;
        if (implJar.exists()) {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (JarFile jar = new JarFile(implJar);){
                    Manifest manifest = jar.getManifest();
                    Attributes attributes = manifest.getMainAttributes();
                    version = attributes.getValue("Liferay-Portal-Version");
                    serverInfo = attributes.getValue("Liferay-Portal-Server-Info");
                    if (CoreUtil.compareVersions((Version)Version.parseVersion((String)version), (Version)MANIFEST_VERSION_REQUIRED) < 0) {
                        version = null;
                        serverInfo = null;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LiferayServerCore.logError(e);
            }
        }
        if (configType.equals(CONFIG_TYPE_VERSION)) {
            return version;
        }
        if (configType.equals(CONFIG_TYPE_SERVER)) {
            return serverInfo;
        }
        return null;
    }

    private void saveConfigInfoIntoCache(String configType, String configInfo, IPath portalDir) {
        IPath versionsInfoPath = null;
        if (configType.equals(CONFIG_TYPE_VERSION)) {
            versionsInfoPath = LiferayServerCore.getDefault().getStateLocation().append("version.properties");
        } else if (configType.equals(CONFIG_TYPE_SERVER)) {
            versionsInfoPath = LiferayServerCore.getDefault().getStateLocation().append("serverInfos.properties");
        }
        if (versionsInfoPath != null) {
            File versionInfoFile = versionsInfoPath.toFile();
            if (configInfo != null) {
                Object var9_13;
                Throwable throwable;
                String portalDirKey = CoreUtil.createStringDigest((String)portalDir.toPortableString());
                Properties properties = new Properties();
                try {
                    throwable = null;
                    var9_13 = null;
                    try (FileInputStream fileInput = new FileInputStream(versionInfoFile);){
                        properties.load(fileInput);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    throwable = null;
                    var9_13 = null;
                    try (FileOutputStream fileOutput = new FileOutputStream(versionInfoFile);){
                        properties.put(portalDirKey, configInfo);
                        properties.store(fileOutput, "");
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    LiferayServerCore.logError(e);
                }
            }
        }
    }
}

