/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.core.portal;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.portal.PortalServerBehavior;
import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class PortalServerLaunchConfigDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)config);
        if (server != null) {
            this.launchServer(server, config, mode, launch, monitor);
        }
    }

    private void launchServer(IServer server, ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IVMInstall vm = this.verifyVMInstall(config);
        IVMRunner runner = vm.getVMRunner(mode) != null ? vm.getVMRunner(mode) : vm.getVMRunner("run");
        File workingDir = this.verifyWorkingDirectory(config);
        String workingDirPath = workingDir != null ? workingDir.getAbsolutePath() : null;
        String progArgs = this.getProgramArguments(config);
        String vmArgs = this.getVMArguments(config);
        String[] envp = this.getEnvironment(config);
        ExecutionArguments execArgs = new ExecutionArguments(vmArgs, progArgs);
        Map vmAttributesMap = this.getVMSpecificAttributesMap(config);
        PortalServerBehavior portalServer = (PortalServerBehavior)server.loadAdapter(PortalServerBehavior.class, monitor);
        String classToLaunch = portalServer.getClassToLaunch();
        String[] classpath = this.getClasspath(config);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(classToLaunch, classpath);
        runConfig.setProgramArguments(execArgs.getProgramArgumentsArray());
        runConfig.setVMArguments(execArgs.getVMArgumentsArray());
        runConfig.setWorkingDirectory(workingDirPath);
        runConfig.setEnvironment(envp);
        runConfig.setVMSpecificAttributesMap(vmAttributesMap);
        Object[] bootpath = this.getBootpath(config);
        if (!CoreUtil.isNullOrEmpty((Object[])bootpath)) {
            runConfig.setBootClassPath((String[])bootpath);
        }
        portalServer.launchServer(launch, mode, monitor);
        try {
            runner.run(runConfig, launch, monitor);
            portalServer.addProcessListener(launch.getProcesses()[0]);
        }
        catch (Exception e) {
            portalServer.cleanup();
        }
    }
}

