/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.util;

import com.liferay.ide.core.IWebProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.server.core.LiferayServerCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.validation.internal.ValType;
import org.eclipse.wst.validation.internal.ValidationRunner;

public class ComponentUtil {
    public static boolean containsMember(IModuleResourceDelta delta, String[] paths) {
        if (delta == null) {
            return false;
        }
        IModuleResourceDelta[] currentChildren = delta.getAffectedChildren();
        if (currentChildren == null) {
            IFile file = (IFile)delta.getModuleResource().getAdapter(IFile.class);
            if (file != null) {
                String filePath = file.getFullPath().toString();
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    if (filePath.contains(path)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        int j = 0;
        int jmax = currentChildren.length;
        while (j < jmax) {
            IPath moduleRelativePath = currentChildren[j].getModuleRelativePath();
            String moduleRelativePathValue = moduleRelativePath.toString();
            String moduleRelativeLastSegment = moduleRelativePath.lastSegment();
            String[] stringArray = paths;
            int n = paths.length;
            int n3 = 0;
            while (n3 < n) {
                String path = stringArray[n3];
                if (moduleRelativePathValue.equals(path) || moduleRelativeLastSegment.equals(path)) {
                    return true;
                }
                ++n3;
            }
            boolean childContains = ComponentUtil.containsMember(currentChildren[j], paths);
            if (childContains) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static IFile findServiceJarForContext(String context) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            IWebProject lrproject;
            IProject project = iProjectArray[n2];
            if (project.getName().equals(context) && (lrproject = (IWebProject)LiferayCore.create(IWebProject.class, (Object)project)) != null && (resource = lrproject.findDocrootResource((IPath)new Path("WEB-INF/lib/" + project.getName() + "-service.jar"))) != null && resource.exists()) {
                return (IFile)resource;
            }
            ++n2;
        }
        return null;
    }

    public static IFolder[] getSourceContainers(IProject project) {
        IPackageFragmentRoot[] sources;
        ArrayList<IFolder> sourceFolders = new ArrayList<IFolder>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = sources = ComponentUtil.getSources(project);
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot source = iPackageFragmentRootArray[n2];
            if (source.getResource() instanceof IFolder) {
                sourceFolders.add((IFolder)source.getResource());
            }
            ++n2;
        }
        return sourceFolders.toArray(new IFolder[sourceFolders.size()]);
    }

    private static IPackageFragmentRoot[] getSources(IProject project) {
        IJavaProject jProject = JavaCore.create((IProject)project);
        if (jProject == null) {
            return new IPackageFragmentRoot[0];
        }
        ArrayList<IPackageFragmentRoot> list = new ArrayList<IPackageFragmentRoot>();
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        try {
            IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IResource resource;
                if (roots[i].getKind() == 1 && (resource = roots[i].getResource()) != null) {
                    IVirtualResource[] vResources = ComponentCore.createResources((IResource)resource);
                    boolean found = false;
                    int j = 0;
                    while (!found && j < vResources.length) {
                        if (vResources[j].getComponent().equals(vc)) {
                            if (!list.contains(roots[i])) {
                                list.add(roots[i]);
                            }
                            found = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (list.size() == 0) {
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                int n = roots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (root.getKind() == 1 && !list.contains(root)) {
                        list.add(root);
                    }
                    ++n2;
                }
            }
        }
        catch (JavaModelException e) {
            LiferayServerCore.logError((Exception)((Object)e));
        }
        return list.toArray(new IPackageFragmentRoot[list.size()]);
    }

    public static boolean hasLiferayFacet(IProject project) {
        boolean retval;
        block4: {
            retval = false;
            if (project == null) {
                return retval;
            }
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                if (facetedProject == null) break block4;
                for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                    IProjectFacet projectFacet = facet.getProjectFacet();
                    if (!projectFacet.getId().startsWith("liferay")) continue;
                    retval = true;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public static void validateFile(IFile file, IProgressMonitor monitor) {
        try {
            ValidationRunner.validate((IFile)file, (ValType)ValType.Manual, (IProgressMonitor)monitor, (boolean)false);
        }
        catch (CoreException e) {
            LiferayServerCore.logError("Error while validating file: " + file.getFullPath(), e);
        }
    }

    public static void validateFolder(IFolder folder, IProgressMonitor monitor) {
        try {
            HashMap projects = new HashMap();
            final HashSet resources = new HashSet();
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile || resource instanceof IFile) {
                        resources.add(resource);
                    }
                    return true;
                }
            });
            projects.put(folder.getProject(), resources);
            ValidationRunner.validate(projects, (ValType)ValType.Manual, (IProgressMonitor)monitor, (boolean)false);
        }
        catch (CoreException e) {
            LiferayServerCore.logError("Error while validating folder: " + folder.getFullPath(), e);
        }
    }
}

