/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.util;

import com.liferay.ide.server.core.portal.PortalServerBehavior;
import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.wst.server.core.IServer;

public class PingThread {
    private static final int PING_DELAY = 2000;
    private static final int PING_INTERVAL = 250;
    private int maxPings;
    private boolean stop = false;
    private String url;
    private IServer server;
    private PortalServerBehavior behaviour;

    public PingThread(IServer server, String url, int maxPings, PortalServerBehavior behaviour) {
        this.server = server;
        this.url = url;
        this.maxPings = maxPings;
        this.behaviour = behaviour;
        Thread t = new Thread("Liferay Ping Thread"){

            @Override
            public void run() {
                PingThread.this.ping();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    protected void ping() {
        int count = 0;
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        while (!this.stop) {
            try {
                if (count == this.maxPings) {
                    try {
                        this.server.stop(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.stop = true;
                    break;
                }
                ++count;
                URL pingUrl = new URL(this.url);
                URLConnection conn = pingUrl.openConnection();
                ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
                int code = ((HttpURLConnection)conn).getResponseCode();
                if (!this.stop && code != 404) {
                    Thread.sleep(200L);
                    this.behaviour.setServerStarted();
                    this.stop = true;
                }
                Thread.sleep(1000L);
            }
            catch (FileNotFoundException fe) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.behaviour.setServerStarted();
                this.stop = true;
            }
            catch (Exception e) {
                if (this.stop) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public void stop() {
        this.stop = true;
    }
}

