/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.core;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.tomcat.core.ILiferayTomcatRuntime;
import com.liferay.ide.server.tomcat.core.LiferayTomcat60Handler;
import com.liferay.ide.server.tomcat.core.LiferayTomcat70Handler;
import com.liferay.ide.server.tomcat.core.LiferayTomcatPlugin;
import com.liferay.ide.server.tomcat.core.util.LiferayTomcatUtil;
import com.liferay.ide.server.util.JavaUtil;
import com.liferay.ide.server.util.LiferayPortalValueLoader;
import com.liferay.ide.server.util.ServerUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.TomcatRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.model.RuntimeDelegate;
import org.osgi.framework.Version;

public class LiferayTomcatRuntime
extends TomcatRuntime
implements ILiferayTomcatRuntime {
    public static final String PROP_JAVADOC_URL = "javadoc-url";
    public static final String PROP_SOURCE_LOCATION = "source-location";
    private IStatus runtimeDelegateStatus;

    private IPath findBundledJREPath(IPath location) {
        if (Platform.getOS().equals("win32") && location != null && location.toFile().exists()) {
            String[] jre;
            File tomcat = location.toFile();
            String[] stringArray = jre = tomcat.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("jre");
                }
            });
            int n = jre.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                File javaw = new File(location.toFile(), String.valueOf(dir) + "/win/bin/javaw.exe");
                if (javaw.exists()) {
                    return new Path(javaw.getPath()).removeLastSegments(2);
                }
                ++n2;
            }
        }
        return null;
    }

    public IVMInstall findPortalBundledJRE(boolean addVM) {
        IPath jrePath = this.findBundledJREPath(this.getRuntime().getLocation());
        if (jrePath == null) {
            return null;
        }
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType vmInstallType = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = vmInstallType.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall vmInstall = iVMInstallArray[n4];
                if (vmInstall.getInstallLocation().equals(jrePath.toFile())) {
                    return vmInstall;
                }
                ++n4;
            }
            ++n2;
        }
        if (addVM) {
            IVMInstallType installType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
            VMStandin newVM = new VMStandin(installType, JavaUtil.createUniqueId((IVMInstallType)installType));
            newVM.setInstallLocation(jrePath.toFile());
            if (!CoreUtil.isNullOrEmpty((String)this.getRuntime().getName())) {
                newVM.setName(String.valueOf(this.getRuntime().getName()) + " JRE");
            } else {
                newVM.setName("Liferay JRE");
            }
            boolean existingVMWithSameName = ServerUtil.isExistingVMName((String)newVM.getName());
            int num = 1;
            while (existingVMWithSameName) {
                newVM.setName(String.valueOf(this.getRuntime().getName()) + " JRE (" + num++ + ")");
                existingVMWithSameName = ServerUtil.isExistingVMName((String)newVM.getName());
            }
            return newVM.convertToRealVM();
        }
        return null;
    }

    public IPath getAppServerDeployDir() {
        return this.getAppServerDir().append("webapps");
    }

    public IPath getAppServerDir() {
        return this.getRuntime().getLocation();
    }

    public IPath getAppServerLibGlobalDir() {
        return this.getAppServerDir().append("lib/ext");
    }

    public IPath getAppServerPortalDir() {
        return LiferayTomcatUtil.getPortalDir(this.getAppServerDir());
    }

    public String getAppServerType() {
        return "tomcat";
    }

    public IPath getDeployDir() {
        return this.getAppServerDir().append("/webapps");
    }

    protected String getExpectedServerInfo() {
        return Msgs.liferayPortal;
    }

    public String[] getHookSupportedProperties() {
        return new LiferayPortalValueLoader(this.getUserLibs()).loadHookPropertiesFromClass();
    }

    public String getJavadocURL() {
        return this.getAttribute(PROP_JAVADOC_URL, null);
    }

    protected Version getLeastSupportedVersion() {
        return ILiferayConstants.LEAST_SUPPORTED_VERSION;
    }

    public IPath getLiferayHome() {
        return this.getAppServerDir().removeLastSegments(1);
    }

    public String getPortalVersion() {
        return LiferayTomcatUtil.getVersion(this);
    }

    public Properties getPortletCategories() {
        return ServerUtil.getPortletCategories((IPath)this.getAppServerPortalDir());
    }

    public Properties getPortletEntryCategories() {
        return ServerUtil.getEntryCategories((IPath)this.getAppServerPortalDir(), (String)this.getPortalVersion());
    }

    public IPath getRuntimeLocation() {
        return this.getRuntime().getLocation();
    }

    @Override
    public String getServerInfo() {
        String serverInfo;
        block6: {
            serverInfo = null;
            try {
                serverInfo = LiferayTomcatUtil.getConfigInfoFromCache("server", this.getAppServerPortalDir());
                if (serverInfo != null) break block6;
                serverInfo = LiferayTomcatUtil.getConfigInfoFromManifest("server", this.getAppServerPortalDir());
                if (serverInfo == null) {
                    try {
                        serverInfo = new LiferayPortalValueLoader(this.getUserLibs()).loadServerInfoFromClass();
                    }
                    catch (Exception e) {
                        LiferayTomcatPlugin.logError("Could not load server info at: runtimeLocation=" + this.getRuntimeLocation().toOSString() + ", portalDir=" + this.getAppServerPortalDir(), e);
                    }
                }
                if (serverInfo != null) {
                    LiferayTomcatUtil.saveConfigInfoIntoCache("server", serverInfo, this.getAppServerPortalDir());
                }
            }
            catch (Exception e) {
                LiferayTomcatPlugin.logError(e);
            }
        }
        return serverInfo;
    }

    public String[] getServletFilterNames() {
        try {
            return ServerUtil.getServletFilterNames((IPath)this.getAppServerPortalDir());
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public IPath getSourceLocation() {
        String location = this.getAttribute(PROP_SOURCE_LOCATION, null);
        return location != null ? new Path(location) : null;
    }

    public IPath[] getUserLibs() {
        return LiferayTomcatUtil.getAllUserClasspathLibraries(this.getRuntimeLocation(), this.getAppServerPortalDir());
    }

    public ITomcatVersionHandler getVersionHandler() {
        String id = this.getRuntime().getRuntimeType().getId();
        if (id.indexOf("runtime.60") > 0) {
            return new LiferayTomcat60Handler();
        }
        if (id.indexOf("runtime.70") > 0) {
            return new LiferayTomcat70Handler();
        }
        return null;
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            IVMInstall vmInstall = this.findPortalBundledJRE(false);
            if (vmInstall != null) {
                this.setVMInstall(vmInstall);
                return vmInstall;
            }
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int size = vmInstalls.length;
            String id = this.getVMInstallId();
            int i = 0;
            while (i < size) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setJavadocURL(String url) {
        if (url != null) {
            this.setAttribute(PROP_JAVADOC_URL, url);
        }
    }

    @Override
    public void setSourceLocation(IPath location) {
        if (location != null) {
            this.setAttribute(PROP_SOURCE_LOCATION, location.toPortableString());
        }
    }

    public IStatus validate() {
        IStatus javadocUrlStatus;
        String javadocUrlValue;
        String serverInfo;
        if (this.runtimeDelegateStatus == null) {
            this.runtimeDelegateStatus = LiferayServerCore.validateRuntimeDelegate((RuntimeDelegate)this);
        }
        if (!this.runtimeDelegateStatus.isOK()) {
            return this.runtimeDelegateStatus;
        }
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        String version = this.getPortalVersion();
        Version portalVersion = Version.parseVersion((String)version);
        if (portalVersion != null && CoreUtil.compareVersions((Version)portalVersion, (Version)this.getLeastSupportedVersion()) < 0) {
            status = LiferayTomcatPlugin.createErrorStatus(NLS.bind((String)Msgs.portalVersionNotSupported, (Object)this.getLeastSupportedVersion()));
        }
        if (!this.getRuntime().isStub() && (CoreUtil.isNullOrEmpty((String)(serverInfo = this.getServerInfo())) || serverInfo.indexOf(this.getExpectedServerInfo()) < 0)) {
            status = LiferayTomcatPlugin.createErrorStatus(NLS.bind((String)Msgs.portalServerNotSupported, (Object)this.getExpectedServerInfo()));
        }
        if (!CoreUtil.empty((String)(javadocUrlValue = this.getJavadocURL())) && !(javadocUrlStatus = this.validateJavadocUrlValue(javadocUrlValue)).isOK()) {
            return javadocUrlStatus;
        }
        return status;
    }

    private IStatus validateJavadocUrlValue(String javadocUrlValue) {
        if (javadocUrlValue.startsWith("http") || javadocUrlValue.startsWith("jar:file:") || javadocUrlValue.startsWith("file:")) {
            return Status.OK_STATUS;
        }
        return LiferayTomcatPlugin.warning(Msgs.javadocURLStart);
    }

    private static class Msgs
    extends NLS {
        public static String javadocURLStart;
        public static String liferayPortal;
        public static String portalServerNotSupported;
        public static String portalVersionNotSupported;

        static {
            Msgs.initializeMessages((String)LiferayTomcatRuntime.class.getName(), Msgs.class);
        }

        private Msgs() {
        }
    }
}

