/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.server.tomcat.core;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.core.util.FileListing;
import com.liferay.ide.core.util.FileUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.AbstractPortalBundle;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PortalTomcatBundle
extends AbstractPortalBundle {
    public PortalTomcatBundle(IPath path) {
        super(path);
    }

    public PortalTomcatBundle(Map<String, String> appServerProperties) {
        super(appServerProperties);
    }

    protected IPath getAppServerLibDir() {
        return this.getAppServerDir().append("lib");
    }

    public IPath getAppServerDeployDir() {
        return this.getAppServerDir().append("webapps");
    }

    public IPath getAppServerLibGlobalDir() {
        return this.getAppServerDir().append("/lib/ext");
    }

    protected int getDefaultJMXRemotePort() {
        Matcher matcher;
        int retval = 8099;
        IPath setenv = this.bundlePath.append("bin/setenv." + this.getShellExtension());
        String contents = FileUtil.readContents((File)setenv.toFile());
        String port = null;
        if (contents != null && (matcher = Pattern.compile(".*-Dcom.sun.management.jmxremote.port(\\s*)=(\\s*)([0-9]+).*").matcher(contents)).matches()) {
            port = matcher.group(3);
        }
        if (port != null) {
            retval = Integer.parseInt(port);
        }
        return retval;
    }

    public String getHttpPort() {
        String retVal = "8080";
        File serverXmlFile = new File(this.getAppServerDir().toPortableString(), "conf/server.xml");
        String portValue = this.getHttpPortValue(serverXmlFile, "Connector", "protocol", "HTTP/1.1", "port");
        if (!CoreUtil.empty((String)portValue)) {
            return portValue;
        }
        return retVal;
    }

    public void setHttpPort(String port) {
        this.setHttpPortValue(new File(this.getAppServerDir().toPortableString(), "conf/server.xml"), "Connector", "protocol", "HTTP/1.1", "port", port);
    }

    public String getMainClass() {
        return "org.apache.catalina.startup.Bootstrap";
    }

    public IPath getAppServerPortalDir() {
        IPath retval = null;
        if (this.bundlePath != null) {
            retval = this.bundlePath.append("webapps/ROOT");
        }
        return retval;
    }

    public IPath[] getRuntimeClasspath() {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        IPath binPath = this.bundlePath.append("bin");
        if (binPath.toFile().exists()) {
            paths.add(binPath.append("bootstrap.jar"));
            IPath juli = binPath.append("tomcat-juli.jar");
            if (juli.toFile().exists()) {
                paths.add(juli);
            }
        }
        return paths.toArray(new IPath[0]);
    }

    public String[] getRuntimeStartProgArgs() {
        String[] retval = new String[]{"start"};
        return retval;
    }

    public String[] getRuntimeStopProgArgs() {
        String[] retval = new String[]{"stop"};
        return retval;
    }

    public String[] getRuntimeStartVMArgs() {
        return this.getRuntimeVMArgs();
    }

    public String[] getRuntimeStopVMArgs() {
        return this.getRuntimeVMArgs();
    }

    private String[] getRuntimeVMArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-Dcatalina.base=\"" + this.bundlePath.toPortableString() + "\"");
        args.add("-Dcatalina.home=\"" + this.bundlePath.toPortableString() + "\"");
        args.add("-Dcom.sun.management.jmxremote");
        args.add("-Dcom.sun.management.jmxremote.authenticate=false");
        args.add("-Dcom.sun.management.jmxremote.port=" + this.getJmxRemotePort());
        args.add("-Dcom.sun.management.jmxremote.ssl=false");
        args.add("-Dfile.encoding=UTF8");
        args.add("-Djava.endorsed.dirs=\"" + this.bundlePath.append("endorsed").toPortableString() + "\"");
        args.add("-Djava.io.tmpdir=\"" + this.bundlePath.append("temp").toPortableString() + "\"");
        args.add("-Djava.net.preferIPv4Stack=true");
        args.add("-Djava.util.logging.config.file=\"" + this.bundlePath.append("conf/logging.properties") + "\"");
        args.add("-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager");
        args.add("-Dorg.apache.catalina.loader.WebappClassLoader.ENABLE_CLEAR_REFERENCES=false");
        args.add("-Duser.timezone=GMT");
        return args.toArray(new String[0]);
    }

    private String getShellExtension() {
        return "win32".equals(Platform.getOS()) ? "bat" : "sh";
    }

    public String getType() {
        return "tomcat";
    }

    public String getDisplayName() {
        return "Tomcat";
    }

    public IPath[] getUserLibs() {
        ArrayList<Path> libs = new ArrayList<Path>();
        try {
            List portallibFiles = FileListing.getFileListing((File)new File(this.getAppServerPortalDir().append("WEB-INF/lib").toPortableString()));
            for (File lib : portallibFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
            List libFiles = FileListing.getFileListing((File)new File(this.getAppServerLibDir().toPortableString()));
            for (File lib : libFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
            List extlibFiles = FileListing.getFileListing((File)new File(this.getAppServerLibGlobalDir().toPortableString()));
            for (File lib : extlibFiles) {
                if (!lib.exists() || !lib.getName().endsWith(".jar")) continue;
                libs.add(new Path(lib.getPath()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return libs.toArray(new IPath[libs.size()]);
    }

    private void setHttpPortValue(File xmlFile, String tagName, String attriName, String attriValue, String targetName, String value) {
        DocumentBuilder db = null;
        DocumentBuilderFactory dbf = null;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
            Document document = db.parse(xmlFile);
            NodeList connectorNodes = document.getElementsByTagName(tagName);
            int i = 0;
            while (i < connectorNodes.getLength()) {
                Node node = connectorNodes.item(i);
                NamedNodeMap attributes = node.getAttributes();
                Node protocolNode = attributes.getNamedItem(attriName);
                if (protocolNode != null && protocolNode.getNodeValue().equals(attriValue)) {
                    Node portNode = attributes.getNamedItem(targetName);
                    portNode.setNodeValue(value);
                    break;
                }
                ++i;
            }
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            DOMSource domSource = new DOMSource(document);
            StreamResult result = new StreamResult(xmlFile);
            transformer.transform(domSource, result);
        }
        catch (Exception e) {
            LiferayServerCore.logError((Exception)e);
        }
    }
}

