/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.asciidoc.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.util.LocationTrackingReader;

public class AsciiDocPreProcessor {
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("^:(.*?):(.*)");
    private static final Pattern ATTRIBUTE_TOKEN_PATTERN = Pattern.compile("(?:\\{(.*?)\\})");

    public String process(String markupContent) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        StringBuilder processedMarkup = new StringBuilder(markupContent.length());
        LocationTrackingReader reader = new LocationTrackingReader((Reader)new StringReader(markupContent));
        try {
            String line = reader.readLine();
            while (line != null) {
                Matcher matcher = ATTRIBUTE_PATTERN.matcher(line);
                if (matcher.matches()) {
                    String key = matcher.group(1);
                    String value = matcher.group(2);
                    if (value != null) {
                        value = value.trim();
                    }
                    attributes.put(key, value);
                } else {
                    Matcher attributesRef = ATTRIBUTE_TOKEN_PATTERN.matcher(line);
                    int offset = 0;
                    while (attributesRef.find()) {
                        String postfix = line.substring(offset, attributesRef.start());
                        if (postfix.endsWith("\\")) {
                            processedMarkup.append(postfix.substring(0, postfix.length() - 1));
                            offset = attributesRef.start();
                            continue;
                        }
                        processedMarkup.append(postfix);
                        String key = attributesRef.group(1);
                        String value = (String)attributes.get(key);
                        if (value == null) {
                            value = attributesRef.group(0);
                        }
                        processedMarkup.append(value);
                        offset = attributesRef.end();
                    }
                    if (offset < line.length()) {
                        processedMarkup.append(line.substring(offset));
                    }
                    processedMarkup.append("\n");
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return processedMarkup.toString();
    }
}

