/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.search.ui.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.ui.DecoratingXMLSearchLabelProvider;
import org.eclipse.wst.xml.search.ui.XMLLabelProvider;
import org.eclipse.wst.xml.search.ui.internal.IXMLSearchContentProvider;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchResult;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchTableContentProvider;
import org.eclipse.wst.xml.search.ui.internal.XMLSearchTreeContentProvider;
import org.eclipse.wst.xml.search.ui.participant.IMatchPresentation;
import org.eclipse.wst.xml.search.ui.util.EditorOpener;

public class XMLSearchResultPage
extends AbstractTextSearchViewPage {
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private IXMLSearchContentProvider fContentProvider;
    private EditorOpener fEditorOpener = new EditorOpener();

    public XMLSearchResultPage() {
        super.setElementLimit(new Integer(1000));
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        XMLLabelProvider innerLabelProvider = new XMLLabelProvider(this);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingXMLSearchLabelProvider(innerLabelProvider));
        viewer.setContentProvider((IContentProvider)new XMLSearchTableContentProvider(this));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (XMLSearchTableContentProvider)viewer.getContentProvider();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        XMLLabelProvider innerLabelProvider = new XMLLabelProvider(this);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingXMLSearchLabelProvider(innerLabelProvider));
        viewer.setContentProvider((IContentProvider)new XMLSearchTreeContentProvider(this, (AbstractTreeViewer)viewer));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)innerLabelProvider));
        this.fContentProvider = (IXMLSearchContentProvider)viewer.getContentProvider();
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    private void addDragAdapters(StructuredViewer viewer) {
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    public void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        XMLSearchResult result;
        IMatchPresentation participant;
        Object element = match.getElement();
        if (element instanceof IDOMNode) {
            IDOMNode node = (IDOMNode)element;
            EditorOpener.openDOMNode(this.getSite().getPage(), node, this.fEditorOpener, this.getSite().getShell());
        } else if (this.getInput() instanceof XMLSearchResult && (participant = (result = (XMLSearchResult)this.getInput()).getSearchParticpant(element)) != null) {
            participant.showMatch(match, offset, length, activate);
        }
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (firstElement instanceof IDOMNode && this.getDisplayedMatchCount(firstElement) == 0) {
            IDOMNode node = (IDOMNode)firstElement;
            EditorOpener.openDOMNode(this.getSite().getPage(), node, this.fEditorOpener, this.getSite().getShell());
            return;
        }
        super.handleOpen(event);
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerComparator {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            this.fLabelProvider = labelProvider;
        }

        public int category(Object element) {
            if (element instanceof IDOMNode || element instanceof IResource) {
                return 1;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getComparator().compare(name1, name2);
        }
    }
}

