/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.editor;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.layouttpl.core.model.LayoutTplElement;
import com.liferay.ide.layouttpl.core.model.LayoutTplElementsFactory;
import com.liferay.ide.layouttpl.core.util.LayoutTplUtil;
import com.liferay.ide.layouttpl.ui.editor.LayoutTplPreviewEditor;
import com.liferay.ide.project.core.descriptor.LiferayDescriptorHelper;
import java.lang.reflect.Method;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.osgi.framework.Version;

public class LayoutTplEditor
extends SapphireEditor
implements IExecutableExtension {
    private static final int SOURCE_PAGE_INDEX = 0;
    private static final int PREVIEW_PAGE_INDEX = 1;
    private static final int DESIGN_PAGE_INDEX = 2;
    private static final String SOURCE_PAGE_TITLE = "Source";
    private static final String PREVIEW_PAGE_TITLE = "Preview";
    private static final String DESIGN_PAGE_TITLE = "Design";
    private StructuredTextEditor sourcePage;
    private LayoutTplPreviewEditor previewPage;
    private DefinitionLoader.Reference<EditorPageDef> definition;
    private IDOMModel sourceModel;
    private boolean isDesignPageChanged;
    private boolean isSourceModelChanged;
    private boolean isBootstrapStyle;
    private boolean is62;

    protected void createEditorPages() throws PartInitException {
        this.sourcePage = new StructuredTextEditor();
        this.sourcePage.setEditorPart((IEditorPart)this);
        this.addPage(0, (IEditorPart)this.sourcePage, this.getEditorInput());
        this.setPageText(0, SOURCE_PAGE_TITLE);
        this.initSourceModel();
        this.addDeferredPage(1, PREVIEW_PAGE_TITLE, "preview");
        this.addDeferredPage(2, DESIGN_PAGE_TITLE, "designPage");
    }

    protected IEditorPart createPage(String pageDefinitionId) {
        if ("preview".equals(pageDefinitionId)) {
            Element element;
            if (this.previewPage == null && (element = this.getModelElement()) instanceof LayoutTplElement) {
                this.previewPage = new LayoutTplPreviewEditor((LayoutTplElement)element){

                    public String getTitle() {
                        return LayoutTplEditor.PREVIEW_PAGE_TITLE;
                    }
                };
            }
            return this.previewPage;
        }
        return super.createPage(pageDefinitionId);
    }

    protected DefinitionLoader.Reference<EditorPageDef> getDefinition(String pageDefinitionId) {
        if ("preview".equals(pageDefinitionId)) {
            if (this.definition == null) {
                this.definition = DefinitionLoader.sdef(LayoutTplEditor.class).page("preview");
            }
            return this.definition;
        }
        return super.getDefinition(pageDefinitionId);
    }

    protected LayoutTplElement createEmptyDiagramModel() {
        LayoutTplElement layoutTpl = (LayoutTplElement)LayoutTplElement.TYPE.instantiate();
        layoutTpl.setBootstrapStyle(Boolean.valueOf(this.isBootstrapStyle()));
        layoutTpl.setClassName(this.getEditorInput().getName().replaceAll("\\..*$", ""));
        layoutTpl.setIs62(Boolean.valueOf(this.is62()));
        return layoutTpl;
    }

    protected Element createModel() {
        IFile file = this.getFile();
        this.isBootstrapStyle = this.isBootstrapStyle();
        this.is62 = this.is62();
        LayoutTplElement layoutTpl = LayoutTplElementsFactory.INSTANCE.newLayoutTplFromFile(file, Boolean.valueOf(this.isBootstrapStyle), Boolean.valueOf(this.is62));
        if (layoutTpl == null) {
            layoutTpl = this.createEmptyDiagramModel();
        }
        layoutTpl.attach(new Listener(){

            public void handle(Event event) {
                LayoutTplEditor.this.setDesignPageChanged(true);
                LayoutTplEditor.this.firePropertyChange(257);
            }
        }, "*");
        return layoutTpl;
    }

    public void dispose() {
        super.dispose();
        this.definition = null;
        this.sourcePage = null;
        this.previewPage = null;
        if (this.sourceModel != null) {
            this.sourceModel.releaseFromEdit();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        int activePage = this.getActivePage();
        if (activePage == 1) {
            if (this.sourcePage.isDirty()) {
                this.sourcePage.doSave(monitor);
            }
        } else if (activePage == 0) {
            if (this.sourcePage.isDirty()) {
                this.sourcePage.doSave(monitor);
                this.refreshDiagramModel();
            }
        } else if (activePage == 2 && this.isDesignPageChanged) {
            this.refreshSourceModel();
            this.sourcePage.doSave(monitor);
        }
        this.setSourceModelChanged(false);
        this.setDesignPageChanged(false);
        this.firePropertyChange(257);
    }

    public IContentOutlinePage getContentOutline(Object page) {
        if (page == this.sourcePage) {
            return (IContentOutlinePage)this.sourcePage.getAdapter(IContentOutlinePage.class);
        }
        return super.getContentOutline(page);
    }

    protected void initSourceModel() {
        if (this.sourceModel == null && this.sourcePage != null && this.sourcePage.getDocumentProvider() != null) {
            IDocumentProvider documentProvider = this.sourcePage.getDocumentProvider();
            IDocument doc = documentProvider.getDocument((Object)this.getEditorInput());
            this.sourceModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForEdit(doc);
            this.sourceModel.addModelStateListener(new IModelStateListener(){

                public void modelAboutToBeChanged(IStructuredModel model) {
                }

                public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
                }

                public void modelChanged(IStructuredModel model) {
                    LayoutTplEditor.this.setSourceModelChanged(true);
                }

                public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
                }

                public void modelReinitialized(IStructuredModel structuredModel) {
                }

                public void modelResourceDeleted(IStructuredModel model) {
                }

                public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
                }
            });
        }
    }

    private boolean isBootstrapStyle() {
        boolean retval = true;
        try {
            ILiferayProject lrproject = LiferayCore.create((Object)this.getFile().getProject());
            ILiferayPortal portal = (ILiferayPortal)lrproject.adapt(ILiferayPortal.class);
            Version version = new Version(portal.getVersion());
            if (CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V620) < 0) {
                retval = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    private boolean is62() {
        IProject project = this.getFile().getProject();
        Version version = new Version(LiferayDescriptorHelper.getDescriptorVersion((IProject)project));
        return CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V620) == 0;
    }

    public boolean isDirty() {
        return this.isDesignPageChanged || this.sourcePage.isDirty();
    }

    protected void pageChange(int pageIndex) {
        int[] lastActivePage = new int[1];
        try {
            Method getLastActivePage = SapphireEditor.class.getDeclaredMethod("getLastActivePage", new Class[0]);
            getLastActivePage.setAccessible(true);
            lastActivePage[0] = (Integer)getLastActivePage.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (lastActivePage[0] == 0 && pageIndex == 1) {
            if (this.sourcePage.isDirty() && this.isSourceModelChanged) {
                this.refreshDiagramModel();
            }
            this.refreshPreviewPage();
        }
        if (lastActivePage[0] == 0 && pageIndex == 2 && this.sourcePage.isDirty() && this.isSourceModelChanged) {
            this.refreshDiagramModel();
        }
        if (lastActivePage[0] == 2 && pageIndex == 0 && this.isDesignPageChanged) {
            this.refreshSourceModel();
        }
        if (lastActivePage[0] == 2 && pageIndex == 1) {
            if (this.isDesignPageChanged) {
                this.refreshSourceModel();
            }
            this.refreshPreviewPage();
        }
        try {
            super.pageChange(pageIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void refreshDiagramModel() {
        LayoutTplElement newElement = LayoutTplElementsFactory.INSTANCE.newLayoutTplFromFile(this.getFile(), Boolean.valueOf(this.isBootstrapStyle), Boolean.valueOf(this.is62));
        if (newElement == null) {
            newElement = this.createEmptyDiagramModel();
        }
        Element model = this.getModelElement();
        model.clear();
        model.copy((Element)newElement);
    }

    protected void refreshPreviewPage() {
        if (this.previewPage != null) {
            this.previewPage.refreshVisualModel((LayoutTplElement)this.getModelElement());
        }
    }

    protected void refreshSourceModel() {
        this.refreshSourceModel((LayoutTplElement)this.getModelElement());
    }

    protected void refreshSourceModel(LayoutTplElement modelElement) {
        if (this.sourceModel != null) {
            String templateSource = LayoutTplUtil.getTemplateSource((LayoutTplElement)modelElement);
            this.sourceModel.aboutToChangeModel();
            this.sourceModel.getStructuredDocument().setText((Object)this, templateSource);
            this.sourceModel.changedModel();
        }
        this.setSourceModelChanged(false);
    }

    protected void setDesignPageChanged(boolean changed) {
        this.isDesignPageChanged = changed;
    }

    protected void setSourceModelChanged(boolean changed) {
        this.isSourceModelChanged = changed;
    }
}

