/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.parts;

import com.liferay.ide.layouttpl.core.model.PortletColumnElement;
import com.liferay.ide.layouttpl.core.model.PortletLayoutElement;
import com.liferay.ide.layouttpl.ui.draw2d.PortletLayoutPanel;
import com.liferay.ide.layouttpl.ui.parts.BaseGraphicalEditPart;
import com.liferay.ide.layouttpl.ui.parts.PortletColumnEditPart;
import com.liferay.ide.layouttpl.ui.parts.PortletRowLayoutEditPart;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.sapphire.ElementList;
import org.eclipse.swt.graphics.Color;

public class PortletLayoutEditPart
extends BaseGraphicalEditPart {
    public static final int COLUMN_SPACING = 5;
    public static final int LAYOUT_MARGIN = 5;
    protected PortletLayoutPanel layoutPanel;

    public static GridData createGridData() {
        return new GridData(4, 4, true, true, 1, 1);
    }

    public int getDefaultColumnHeight() {
        return this.getCastedParent().getPreferredColumnHeight();
    }

    public Object getLayoutConstraint(PortletColumnEditPart columnPart, IFigure figure) {
        if (this.getChildren().contains((Object)columnPart)) {
            return this.getFigure().getLayoutManager().getConstraint(figure);
        }
        return null;
    }

    private PortletRowLayoutEditPart getCastedParent() {
        return (PortletRowLayoutEditPart)this.getParent();
    }

    protected void createEditPolicies() {
    }

    protected IFigure createFigure() {
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 5;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        this.layoutPanel = new PortletLayoutPanel();
        this.layoutPanel.setOpaque(true);
        this.layoutPanel.setBorder((Border)new MarginBorder(5));
        this.layoutPanel.setBackgroundColor(new Color(null, 171, 171, 171));
        this.layoutPanel.setLayoutManager((LayoutManager)gridLayout);
        return this.layoutPanel;
    }

    protected PortletLayoutPanel getCastedFigure() {
        return (PortletLayoutPanel)this.getFigure();
    }

    protected PortletLayoutElement getCastedModel() {
        return (PortletLayoutElement)this.getModel();
    }

    protected ElementList<PortletColumnElement> getModelChildren() {
        return this.getCastedModel().getPortletColumns();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        GridData gd = PortletLayoutEditPart.createGridData();
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)this.layoutPanel, (Object)gd);
        List rows = this.getParent().getChildren();
        if (rows.size() == 1) {
            this.layoutPanel.setTop(true);
            this.layoutPanel.setBottom(true);
        } else if (((Object)((Object)this)).equals(rows.get(0))) {
            this.layoutPanel.setTop(true);
            this.layoutPanel.setBottom(false);
        } else if (((Object)((Object)this)).equals(rows.get(rows.size() - 1))) {
            this.layoutPanel.setTop(false);
            this.layoutPanel.setBottom(true);
        } else {
            this.layoutPanel.setTop(false);
            this.layoutPanel.setBottom(false);
        }
        PortletLayoutPanel panel = this.getCastedFigure();
        GridLayout gridLayout = (GridLayout)panel.getLayoutManager();
        List columns = this.getChildren();
        int numColumns = columns.size();
        if (numColumns > 0) {
            int rowWidth = this.getFigure().getParent().getSize().width - 15;
            if (rowWidth > 0) {
                for (Object col : columns) {
                    PortletColumnEditPart portletColumnPart = (PortletColumnEditPart)((Object)col);
                    PortletColumnElement column = (PortletColumnElement)portletColumnPart.getModel();
                    GridData rowData = portletColumnPart.createGridData();
                    double percent = ((Integer)column.getWeight().content()).doubleValue() / ((Integer)column.getFullWeight().content()).doubleValue();
                    rowData.widthHint = (int)(percent * (double)rowWidth) - 10;
                    IFigure columnFigure = portletColumnPart.getFigure();
                    columnFigure.setSize(rowData.widthHint, columnFigure.getSize().height);
                    portletColumnPart.refresh();
                }
            }
            gridLayout.numColumns = numColumns;
            this.getFigure().repaint();
        }
    }
}

