/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.layouttpl.ui.wizard;

import com.liferay.ide.core.ILiferayConstants;
import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.LiferayCore;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.layouttpl.core.model.LayoutTplElement;
import com.liferay.ide.layouttpl.core.operation.INewLayoutTplDataModelProperties;
import com.liferay.ide.layouttpl.core.operation.LayoutTplDescriptorHelper;
import com.liferay.ide.layouttpl.core.util.LayoutTplUtil;
import com.liferay.ide.layouttpl.ui.LayoutTplUI;
import com.liferay.ide.layouttpl.ui.util.LayoutTemplatesFactory;
import com.liferay.ide.project.core.util.ProjectUtil;
import com.liferay.ide.project.ui.wizard.LiferayDataModelOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.osgi.framework.Version;

public class AddLayoutTplOperation
extends LiferayDataModelOperation
implements INewLayoutTplDataModelProperties {
    public AddLayoutTplOperation(IDataModel model, TemplateStore templateStore, TemplateContextType contextType) {
        super(model, templateStore, contextType);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus retval = null;
        IDataModel dm = this.getDataModel();
        String diagramClassName = dm.getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_ID");
        LayoutTplElement diagramModel = this.createLayoutTplDigram(dm, this.isBootstrapStyle(), diagramClassName);
        try {
            String thumbnailFileName;
            IFile templateFile = null;
            String templateFileName = this.getDataModel().getStringProperty("INewLayoutTplModelProperties.LAYOUT_TEMPLATE_FILE");
            if (!CoreUtil.isNullOrEmpty((String)templateFileName)) {
                templateFile = this.createTemplateFile(templateFileName, diagramModel);
            }
            this.getDataModel().setProperty("INewLayoutTplModelProperties.LAYOUT_TPL_FILE_CREATED", (Object)templateFile);
            String wapTemplateFileName = this.getDataModel().getStringProperty("INewLayoutTplModelProperties.LAYOUT_WAP_TEMPLATE_FILE");
            diagramModel.setClassName(String.valueOf(diagramClassName) + ".wap");
            if (!CoreUtil.isNullOrEmpty((String)wapTemplateFileName)) {
                this.createTemplateFile(wapTemplateFileName, diagramModel);
            }
            if (!CoreUtil.isNullOrEmpty((String)(thumbnailFileName = this.getDataModel().getStringProperty("INewLayoutTplModelProperties.LAYOUT_THUMBNAIL_FILE")))) {
                this.createThumbnailFile(thumbnailFileName);
            }
        }
        catch (CoreException ex) {
            LayoutTplUI.logError((Exception)((Object)ex));
            return LayoutTplUI.createErrorStatus((Exception)((Object)ex));
        }
        catch (IOException ex) {
            LayoutTplUI.logError(ex);
            return LayoutTplUI.createErrorStatus(ex);
        }
        LayoutTplDescriptorHelper layoutTplDescHelper = new LayoutTplDescriptorHelper(this.getTargetProject());
        retval = layoutTplDescHelper.addNewLayoutTemplate(dm);
        return retval;
    }

    protected void createThumbnailFile(String thumbnailFileName) throws CoreException, IOException {
        IFolder defaultDocroot = CoreUtil.getDefaultDocrootFolder((IProject)this.getTargetProject());
        IFile thumbnailFile = defaultDocroot.getFile(thumbnailFileName);
        URL iconFileURL = LayoutTplUI.getDefault().getBundle().getEntry("/icons/blank_columns.png");
        CoreUtil.prepareFolder((IFolder)((IFolder)thumbnailFile.getParent()));
        if (thumbnailFile.exists()) {
            thumbnailFile.setContents(iconFileURL.openStream(), 1, null);
        } else {
            thumbnailFile.create(iconFileURL.openStream(), true, null);
        }
    }

    protected IFile createTemplateFile(String templateFileName, LayoutTplElement element) throws CoreException {
        IFolder defaultDocroot = CoreUtil.getDefaultDocrootFolder((IProject)this.getTargetProject());
        IFile templateFile = defaultDocroot.getFile(templateFileName);
        if (element != null) {
            LayoutTplUtil.saveToFile((LayoutTplElement)element, (IFile)templateFile, null);
        } else {
            ByteArrayInputStream input = new ByteArrayInputStream("".getBytes());
            if (templateFile.exists()) {
                templateFile.setContents((InputStream)input, 1, null);
            } else {
                templateFile.create((InputStream)input, true, null);
            }
        }
        return templateFile;
    }

    protected LayoutTplElement createLayoutTplDigram(IDataModel dm, boolean isBootstrapStyle, String className) {
        LayoutTplElement layoutTpl = (LayoutTplElement)LayoutTplElement.TYPE.instantiate();
        layoutTpl.setBootstrapStyle(Boolean.valueOf(isBootstrapStyle));
        layoutTpl.setClassName(className);
        if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_COLUMN")) {
            LayoutTemplatesFactory.add_Layout_1(layoutTpl);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_I_COLUMN")) {
            LayoutTemplatesFactory.add_Layout_1_2_I(layoutTpl);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_II_COLUMN")) {
            LayoutTemplatesFactory.add_Layout_1_2_II(layoutTpl);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_1_2_1_COLUMN")) {
            LayoutTemplatesFactory.add_Layout_1_2_1(layoutTpl);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_I_COLUMN")) {
            LayoutTemplatesFactory.add_Layout_2_I(layoutTpl);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_II_COLUMN")) {
            LayoutTemplatesFactory.add_Layout_2_II(layoutTpl);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_III_COLUMN")) {
            LayoutTemplatesFactory.add_Layout_2_III(layoutTpl);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_2_2_COLUMN")) {
            LayoutTemplatesFactory.add_Layout_2_2(layoutTpl);
        } else if (dm.getBooleanProperty("INewLayoutTplModelProperties.LAYOUT_IMAGE_3_COLUMN")) {
            LayoutTemplatesFactory.add_Layout_3(layoutTpl);
        }
        return layoutTpl;
    }

    public IProject getTargetProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtil.getProject((String)projectName);
    }

    private boolean isBootstrapStyle() {
        ILiferayProject lrproject = LiferayCore.create((Object)this.getTargetProject());
        ILiferayPortal portal = (ILiferayPortal)lrproject.adapt(ILiferayPortal.class);
        if (portal != null) {
            Version version = new Version(portal.getVersion());
            return CoreUtil.compareVersions((Version)version, (Version)ILiferayConstants.V620) >= 0;
        }
        return true;
    }
}

