/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.preview.adapter.internal.core;

import java.io.FileNotFoundException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.jst.server.preview.adapter.internal.Trace;
import org.eclipse.jst.server.preview.adapter.internal.core.PreviewServerBehaviour;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.Server;

public class PingThread {
    private static final int PING_DELAY = 2000;
    private static final int PING_INTERVAL = 250;
    private int maxPings;
    private boolean stop = false;
    private String url;
    private IServer server;
    private PreviewServerBehaviour behaviour;

    public PingThread(IServer server, String url, PreviewServerBehaviour behaviour) {
        this.server = server;
        this.url = url;
        this.behaviour = behaviour;
        this.maxPings = this.guessMaxPings();
        Thread t = new Thread("Preview Ping Thread"){

            public void run() {
                PingThread.this.ping();
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private int guessMaxPings() {
        int startTimeout = ((Server)this.server).getStartTimeout() * 1000;
        if (startTimeout > 0) {
            return startTimeout / 250;
        }
        return -1;
    }

    protected void ping() {
        int count = 0;
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        while (!this.stop) {
            try {
                if (count == this.maxPings) {
                    try {
                        this.server.stop(false);
                    }
                    catch (Exception exception) {
                        Trace.trace((byte)3, "Ping: could not stop server");
                    }
                    this.stop = true;
                    break;
                }
                Trace.trace((byte)3, "Ping: pinging " + ++count);
                URL pingUrl = new URL(this.url);
                URLConnection conn = pingUrl.openConnection();
                ((HttpURLConnection)conn).getResponseCode();
                if (!this.stop) {
                    Trace.trace((byte)3, "Ping: success");
                    Thread.sleep(200L);
                    this.behaviour.setServerStarted();
                }
                this.stop = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
                this.behaviour.setServerStarted();
                this.stop = true;
            }
            catch (Exception exception) {
                Trace.trace((byte)3, "Ping: failed");
                if (this.stop) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void stop() {
        Trace.trace((byte)3, "Ping: stopping");
        this.stop = true;
    }
}

