/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.service.ui.editor;

import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.service.core.util.ServiceUtil;
import com.liferay.ide.service.ui.editor.ServiceMethodImplementationHyperlink;
import com.liferay.ide.service.ui.editor.ServiceMethodWrapperHyperlink;
import com.liferay.ide.service.ui.editor.ServiceMethodWrapperLookupHyperlink;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class ServiceMethodHyperlinkDetector
extends AbstractHyperlinkDetector {
    private IJavaElement[] lastElements;
    private ITypeRoot lastInput;
    private long lastModStamp;
    private IRegion lastWordRegion;

    private void addHyperlinks(List<IHyperlink> links, IRegion word, SelectionDispatchAction openAction, IMethod method, boolean qualify, JavaEditor editor) {
        if (this.shouldAddServiceHyperlink(editor)) {
            IMethodWrapper wrapperMethod;
            IMethod implMethod = this.getServiceImplMethod(method);
            if (implMethod != null) {
                links.add(new ServiceMethodImplementationHyperlink(word, openAction, implMethod, qualify));
            }
            if ((wrapperMethod = this.getServiceWrapperMethod(method)) != null) {
                if (wrapperMethod.base) {
                    links.add(new ServiceMethodWrapperLookupHyperlink(editor, word, openAction, wrapperMethod.method, qualify));
                } else {
                    links.add(new ServiceMethodWrapperHyperlink(word, openAction, wrapperMethod.method, qualify));
                }
            }
        }
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        int offset;
        IRegion wordRegion;
        IEditorInput editorInput;
        IDocumentProvider documentProvider;
        IDocument document;
        IAction openAction;
        IHyperlink[] retval = null;
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (textEditor == null) {
            return retval;
        }
        ITypeRoot input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, (boolean)false);
        if (this.shouldDetectHyperlinks(textEditor, input, openAction = textEditor.getAction("OpenEditor"), region) && this.isRegionValid(document = (documentProvider = textEditor.getDocumentProvider()).getDocument((Object)(editorInput = textEditor.getEditorInput())), wordRegion = JavaWordFinder.findWord((IDocument)document, (int)(offset = region.getOffset())))) {
            IJavaElement[] elements = new IJavaElement[]{};
            long modStamp = documentProvider.getModificationStamp((Object)editorInput);
            if (input.equals(this.lastInput) && modStamp == this.lastModStamp && wordRegion.equals(this.lastWordRegion)) {
                elements = this.lastElements;
            } else {
                try {
                    elements = input.codeSelect(wordRegion.getOffset(), wordRegion.getLength());
                    elements = this.selectOpenableElements(elements);
                    this.lastInput = input;
                    this.lastModStamp = modStamp;
                    this.lastWordRegion = wordRegion;
                    this.lastElements = elements;
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
            if (elements.length != 0) {
                ArrayList<IHyperlink> links = new ArrayList<IHyperlink>(elements.length);
                IJavaElement[] iJavaElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement element = iJavaElementArray[n2];
                    if (element instanceof IMethod) {
                        this.addHyperlinks(links, wordRegion, (SelectionDispatchAction)openAction, (IMethod)element, elements.length > 1, (JavaEditor)textEditor);
                    }
                    ++n2;
                }
                if (links.size() != 0) {
                    retval = canShowMultipleHyperlinks ? links.toArray(new IHyperlink[0]) : new IHyperlink[]{(IHyperlink)links.get(0)};
                }
            }
        }
        return retval;
    }

    public void dispose() {
        super.dispose();
        this.lastElements = null;
        this.lastInput = null;
        this.lastWordRegion = null;
    }

    private IType findType(IJavaElement parent, String fullyQualifiedName) throws JavaModelException {
        IType retval = parent.getJavaProject().findType(fullyQualifiedName);
        if (retval == null) {
            IJavaProject[] serviceProjects;
            IJavaProject[] iJavaProjectArray = serviceProjects = ServiceUtil.getAllServiceProjects();
            int n = serviceProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject sp = iJavaProjectArray[n2];
                try {
                    retval = sp.findType(fullyQualifiedName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (retval != null) break;
                ++n2;
            }
        }
        return retval;
    }

    private IMethod getServiceImplMethod(IMethod method) {
        Object retval = null;
        try {
            IJavaElement methodClass = method.getParent();
            IType methodClassType = method.getDeclaringType();
            String methodClassName = methodClass.getElementName();
            if (methodClassName.endsWith("Util") && JdtFlags.isPublic((IMember)method) && JdtFlags.isStatic((IMember)method)) {
                String packageName = methodClassType.getPackageFragment().getElementName();
                String baseServiceName = methodClassName.substring(0, methodClassName.length() - 4);
                String fullyQualifiedName = String.valueOf(packageName) + ".impl." + baseServiceName + "Impl";
                IType implType = this.findType(methodClass, fullyQualifiedName);
                if (implType != null) {
                    Object[] methods = implType.findMethods(method);
                    if (CoreUtil.isNullOrEmpty((Object[])methods)) {
                        ITypeHierarchy hierarchy = implType.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                        IType currentType = implType;
                        while (retval == null && currentType != null) {
                            methods = currentType.findMethods(method);
                            if (!CoreUtil.isNullOrEmpty((Object[])methods)) {
                                retval = methods[0];
                                continue;
                            }
                            currentType = hierarchy.getSuperclass(currentType);
                        }
                    } else {
                        retval = methods[0];
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    private IMethodWrapper getServiceWrapperMethod(IMethod method) {
        IMethodWrapper retval = null;
        try {
            IJavaElement methodClass = method.getParent();
            IType methodClassType = method.getDeclaringType();
            String methodClassName = methodClass.getElementName();
            if (methodClassName.endsWith("Util") && JdtFlags.isPublic((IMember)method) && JdtFlags.isStatic((IMember)method)) {
                Object[] wrapperBaseMethods;
                String packageName = methodClassType.getPackageFragment().getElementName();
                String baseServiceName = methodClassName.substring(0, methodClassName.length() - 4);
                String fullyQualifiedName = String.valueOf(packageName) + "." + baseServiceName + "Wrapper";
                IType wrapperType = this.findType(methodClass, fullyQualifiedName);
                if (wrapperType != null && !CoreUtil.isNullOrEmpty((Object[])(wrapperBaseMethods = wrapperType.findMethods(method)))) {
                    ArrayList<IMethod> overrides = new ArrayList<IMethod>();
                    WrapperMethodCollector requestor = new WrapperMethodCollector(overrides, method);
                    IJavaSearchScope scope = SearchEngine.createStrictHierarchyScope(null, (IType)wrapperType, (boolean)true, (boolean)false, null);
                    SearchPattern search = SearchPattern.createPattern((String)method.getElementName(), (int)1, (int)0, (int)8);
                    new SearchEngine().search(search, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
                    if (overrides.size() > 1) {
                        retval = new IMethodWrapper((IMethod)wrapperBaseMethods[0], true);
                    } else if (overrides.size() == 1) {
                        retval = new IMethodWrapper((IMethod)overrides.get(0), false);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    private boolean isInheritDoc(IDocument document, IRegion wordRegion) {
        try {
            String word = document.get(wordRegion.getOffset(), wordRegion.getLength());
            return "inheritDoc".equals(word);
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    private boolean isRegionValid(IDocument document, IRegion wordRegion) {
        return wordRegion != null && wordRegion.getLength() != 0 && !this.isInheritDoc(document, wordRegion);
    }

    private IJavaElement[] selectOpenableElements(IJavaElement[] elements) {
        ArrayList<IJavaElement> result = new ArrayList<IJavaElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IJavaElement element = elements[i];
            switch (element.getElementType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 11: {
                    break;
                }
                default: {
                    result.add(element);
                }
            }
            ++i;
        }
        return result.toArray(new IJavaElement[result.size()]);
    }

    private boolean shouldAddServiceHyperlink(JavaEditor editor) {
        return SelectionConverter.canOperateOn((JavaEditor)editor);
    }

    private boolean shouldDetectHyperlinks(ITextEditor textEditor, ITypeRoot input, IAction openAction, IRegion region) {
        return region != null && textEditor instanceof JavaEditor && openAction instanceof SelectionDispatchAction && input != null;
    }

    private static class IMethodWrapper {
        private final boolean base;
        private final IMethod method;

        public IMethodWrapper(IMethod method, boolean base) {
            this.method = method;
            this.base = base;
        }
    }

    private static class WrapperMethodCollector
    extends SearchRequestor {
        private final List<IMethod> results;
        private final IMethod method;

        public WrapperMethodCollector(List<IMethod> results, IMethod method) {
            this.results = results;
            this.method = method;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object element = match.getElement();
            if (element instanceof IMethod && this.matches((IMethod)element)) {
                this.results.add((IMethod)element);
            }
        }

        private boolean matches(IMethod element) throws JavaModelException {
            boolean matches = false;
            if (this.method.getNumberOfParameters() == element.getNumberOfParameters()) {
                matches = true;
                int i = 0;
                while (i < this.method.getTypeParameters().length) {
                    if (!this.method.getParameterTypes()[i].equals(element.getParameterTypes()[i])) {
                        matches = false;
                        break;
                    }
                    ++i;
                }
            }
            return matches;
        }
    }
}

