/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui;

import com.liferay.ide.core.ILiferayPortal;
import com.liferay.ide.core.ILiferayProject;
import com.liferay.ide.core.util.CoreUtil;
import com.liferay.ide.server.core.LiferayServerCore;
import com.liferay.ide.server.core.portal.PortalBundle;
import com.liferay.ide.xml.search.ui.LiferayXMLSearchUI;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.ServerCore;

public class PortalLanguagePropertiesCacheUtil {
    private static final WeakHashMap<IPath, Properties> languagePortalMap = new WeakHashMap();

    public static Properties getPortalLanguageProperties(ILiferayProject project) {
        if (project == null) {
            return new Properties();
        }
        Properties retval = null;
        ZipFile jar = null;
        InputStream in = null;
        try {
            ILiferayPortal portal = (ILiferayPortal)project.adapt(ILiferayPortal.class);
            if (portal == null) {
                Object[] runtimes = ServerCore.getRuntimes();
                if (!CoreUtil.isNullOrEmpty((Object[])runtimes)) {
                    Object[] objectArray = runtimes;
                    int n = runtimes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object runtime = objectArray[n2];
                        PortalBundle portalBundle = LiferayServerCore.newPortalBundle((IPath)runtime.getLocation());
                        if (portalBundle != null) {
                            portal = portalBundle;
                            break;
                        }
                        ++n2;
                    }
                }
                if (portal == null) {
                    Properties properties = retval;
                    return properties;
                }
            }
            try {
                IPath appServerPortalDir = portal.getAppServerPortalDir();
                retval = languagePortalMap.get(appServerPortalDir);
                if (retval == null) {
                    if (appServerPortalDir != null && appServerPortalDir.toFile().exists()) {
                        jar = new JarFile(appServerPortalDir.append("WEB-INF/lib/portal-impl.jar").toFile());
                        ZipEntry lang = ((JarFile)jar).getEntry("content/Language.properties");
                        retval = new Properties();
                        in = ((JarFile)jar).getInputStream(lang);
                        retval.load(in);
                    }
                    languagePortalMap.put(appServerPortalDir, retval);
                }
            }
            catch (Exception e) {
                LiferayXMLSearchUI.logError("Unable to find portal language properties", e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException iOException) {}
        }
        return retval;
    }
}

