/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ide.xml.search.ui.validators;

import com.liferay.ide.project.core.ValidationPreferences;
import com.liferay.ide.xml.search.ui.util.ValidatorUtil;
import com.liferay.ide.xml.search.ui.validators.LiferayBaseValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.search.core.util.DOMUtils;
import org.eclipse.wst.xml.search.editor.references.IXMLReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class ServiceBuilderDescriptorValidator
extends LiferayBaseValidator {
    @Override
    protected boolean validateSyntax(IXMLReference reference, IDOMNode node, IFile file, IValidator validator, IReporter reporter, boolean batchMode) {
        int severity = this.getServerity(ValidationPreferences.ValidationType.SYNTAX_INVALID, file);
        if (severity != -1) {
            IStatus javaStatus;
            String nodeValue;
            String validationMsg = null;
            if (node.getNodeType() == 3) {
                if (node.getParentNode().getNodeName().equals("namespace") && !ValidatorUtil.isValidNamespace(nodeValue = DOMUtils.getNodeValue((Node)node))) {
                    validationMsg = this.getMessageText(ValidationPreferences.ValidationType.SYNTAX_INVALID, (Node)node);
                }
            } else if (node.getNodeType() == 2 && "package-path".equals(node.getNodeName()) && "service-builder".equals(((Attr)node).getOwnerElement().getNodeName()) && (nodeValue = DOMUtils.getNodeValue((Node)node)) != null && ((javaStatus = JavaConventions.validatePackageName((String)nodeValue, (String)"1.7", (String)"1.7")).getSeverity() == 4 || javaStatus.getSeverity() == 2)) {
                validationMsg = String.valueOf(J2EECommonMessages.ERR_JAVA_PACAKGE_NAME_INVALID) + javaStatus.getMessage();
            }
            if (validationMsg != null) {
                String liferayPluginValidationType = this.getLiferayPluginValidationType(ValidationPreferences.ValidationType.SYNTAX_INVALID, file);
                this.addMessage(node, file, validator, reporter, batchMode, validationMsg, severity, liferayPluginValidationType);
                return false;
            }
        }
        return true;
    }
}

