/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.internal.core.resources;

import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import org.eclipse.jface.text.IDocument;
import tern.ITernFile;
import tern.ITernProject;
import tern.eclipse.ide.internal.core.resources.IDETernFileUploader;
import tern.resources.ITernFileUploader;
import tern.resources.TernFileSynchronizer;
import tern.server.protocol.TernDoc;
import tern.server.protocol.TernFile;
import tern.server.protocol.TernQuery;

public class IDETernFileSynchronizer
extends TernFileSynchronizer {
    protected static final int BIG_FILE = 500;

    public IDETernFileSynchronizer(ITernProject project) {
        super(project);
    }

    protected ITernFileUploader createTernFileUploader() {
        return new IDETernFileUploader(this.getProject());
    }

    protected void addJSFile(TernDoc doc, ITernFile file) throws IOException {
        TernQuery query = doc.getQuery();
        String fileName = file.getFullName(this.getProject());
        query.setFile(fileName);
        IDocument document = (IDocument)file.getAdapter(IDocument.class);
        if (document != null) {
            String oldText;
            String text = document.get();
            if (text.equals(oldText = this.getSentFileContent(fileName))) {
                if (!this.getTernFileUploader().cancel(fileName)) {
                    return;
                }
            } else if (oldText != null && document.getNumberOfLines() > 500) {
                try {
                    int start = 0;
                    while (start < text.length() && start < oldText.length() && text.charAt(start) == oldText.charAt(start)) {
                        ++start;
                    }
                    int offset = oldText.length() - text.length();
                    int end = text.length() - 1;
                    while (end > 0 && end + offset > 0 && text.charAt(end) == oldText.charAt(end + offset)) {
                        --end;
                    }
                    int startLine = document.getLineOfOffset(start);
                    int endLine = document.getLineOfOffset(end);
                    int selEndLine = query.get("end") != null ? document.getLineOfOffset(query.get("end").asInt()) : -1;
                    int selStartLine = query.get("start") != null ? document.getLineOfOffset(query.get("start").asInt()) : selEndLine;
                    if (startLine <= endLine && endLine - startLine < 100 && selStartLine - 2 <= endLine && selEndLine + 2 >= startLine) {
                        if ((startLine -= 50) < 0) {
                            startLine = 0;
                        }
                        if ((endLine += 20) >= document.getNumberOfLines()) {
                            endLine = document.getNumberOfLines() - 1;
                        }
                        start = document.getLineOffset(startLine);
                        end = document.getLineOffset(endLine);
                        String textPart = document.get(start, end - start);
                        doc.addFile(new TernFile(fileName, textPart, null, Integer.valueOf(start)));
                        query.setFile("#" + (doc.getFiles().size() - 1));
                        JsonValue val = query.get("end");
                        if (val != null) {
                            query.setEnd(Integer.valueOf(val.asInt() - start));
                        }
                        if ((val = query.get("start")) != null) {
                            query.add("start", val.asInt() - start);
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    this.getProject().handleException((Throwable)e);
                }
            }
        }
        TernFile tf = file.toTernServerFile(this.getProject());
        doc.addFile(tf);
    }
}

